/*
	Interpolates a given state with "refinement" many more bins with an inteprolationscheme specified
*/

#include <iostream>		// needed for output in control-window
#include <string>		// needed for strings/names
#include <vector>		// needed for vectors/vector-operations
#include <math.h>		// needed for floor, ceil
#include <numeric>		// needed for accumulate or innerproduct

using namespace std;

#include "modulo.h"

void interpolate( vector<double>* roughstate_adr, vector<double>* finestate_adr, int sitenumber, int refinement, string interpolationtype )
{
	int newsitenumber = sitenumber*refinement;	// number of sites of interpolated function

	if( interpolationtype == "none" )
	{
		if( refinement > 1 )
		{
			cout << " Warning - interpolate: Interpolationtype = none, refinement = " << refinement << "\n";
		}
		copy((*roughstate_adr).begin(),(*roughstate_adr).end(),(*finestate_adr).begin()); // copy roughstate into finestate-address
	}
	else if( interpolationtype == "const" )
	{
		int newsitenumber = sitenumber*refinement;	// number of sites of interpolated function
		int jref = -1;								// auxiliary bins in original function
		for( int j=0; j<newsitenumber; j++ )
		{
			jref = modulo( floor(double(j)/refinement+0.5), sitenumber);	// rounding to nearest bin in original setting
			(*finestate_adr).at(j) = (*roughstate_adr).at(jref)/refinement;	// need the devision by "refinement" to normalize the state to the same number of particles again
		}
	}
	else if( interpolationtype == "linear" )
	{
		int jref1 = -1, jref2 = -1;					// auxiliary bins in original function
		for( int j=0; j<newsitenumber; j++ )
		{
			double jest = double(j)/refinement;
			jref1 = modulo( floor(jest), sitenumber );
			jref2 = modulo( floor(jest+1), sitenumber );
			(*finestate_adr).at(j) = ( (jref2-jest)*(*roughstate_adr).at(jref1) + (jest-jref1)*(*roughstate_adr).at(jref2) )/refinement;
		}
	}
	else
	{
		cout << " Warning - interpolate: No valid interpolationtype: " << interpolationtype << "\n";
	}
	
	return;
}