/*
	In this function the main physical and numerical parameters are set and the individual subfunctions are called
*/

#include <iostream>		// needed for output in control-window
#include <ctime>		// needed for timer
#include <string>		// needed for strings/names
#include <sstream>		// needed for ostringstream
#include <vector>		// needed for vectors/vector-operations

using namespace std;

#include "readagainC.h"

int main()
{
	// for timer:
	clock_t t1 = clock();					// start-time of timer

	// get concentration-points:
	static double x0range[] = {0.025,0.05,0.075,0.1,0.125,0.15,0.175,0.2,0.225,0.25,0.275,0.3,0.325,0.35,0.375,0.4,0.425,0.45,0.475,0.5,0.525,0.55,0.575,0.6,0.625,0.65,0.675,0.7,0.725,0.75,0.775,0.8,0.825,0.85,0.875,0.9,0.925,0.95,0.975};	// x0: concentration-point of the filter-function gamma
	const int lx0range = int( sizeof(x0range)/sizeof(x0range[0]) );	// amount of elements in x0range

	// get filtertype:
	string filtertype = "smoothed_wedge";
	static vector<double> filterparameters;	// parameters in filter-function gamma; first argument is "a", second is "b" etc.
	filterparameters.push_back(1.);			// initialize a
	filterparameters.push_back(160.);			// initialize b
	filterparameters.push_back(2.);			// initialize c
	string interpolationtype = "const";		// interpolation of internal processing of intergrals, differentials etc
	int interpolationref = 1;				// increase in resolution when interpolating
	double refinement = 1;
	bool diffscaling = 1;
	double epsilon = 1;						// epsilon as in the definition of Y
	string samplingmode = "separate";		// "separate" = evaluate all files individually, "combined" = average over all files
	int readsampling = 0;					// length of namelist
	
	// get name of filedirectory:
	vector<string> namelist;
	string foldername = "C:\\Users\\mydata\\";	// file directory with "\\" instead of "\"
	string filename = "state (ZRP, dT=1e-003, Nbin=5000, micres=1, Npart=25000, allsamples=50x2000x1, wait=100, fwait=0.1, repeat, stsa, sw_const(1)_flat_rep_1-100000)";		// name of file itself (without ".txt")

	// generate composite name of file:
	stringstream wholename;
	wholename.str("");								// clear earlier content
	wholename << foldername << filename << ".txt";	// name of file with directory and type-suffix
	namelist.push_back(wholename.str());
	readsampling ++;								// one more file in namelist
	
	/*
	// 2nd file:									// more files similarly
	filename = "state (ZRP, dT=1e-005, Nbin=5000, micres=1, Npart=79519, allsamples=50x2000x1, wait=100, fwait=0.1, repeat, stsa, sw_const(1)_sin_rep_1-100000)";
	wholename.str("");								// clear earlier content
	wholename << foldername << filename << ".txt";	// name of file with directory and type-suffix
	namelist.push_back(wholename.str());
	readsampling ++;								// one more file in namelist
	*/

	// run reading-programme:
	readagainC( &namelist, readsampling, samplingmode, filtertype, &filterparameters, x0range, lx0range, refinement, diffscaling, epsilon, interpolationtype, interpolationref  );


	// for timer and final message:
	clock_t t2 = clock();	// stop-time of timer
	cout << "Finddiffusivity total CPU-time-consumption:\n";
	cout << "  " << double(t2-t1)/ CLOCKS_PER_SEC << " sec.\n";

	system("pause");	// for keeping command-window alive

	return 0;
}