/*
	Converts microscopical states to macroscopical states by local averaging over the microresolution
*/

#include <vector>		// needed for vectors/vector-operations
#include <numeric>		// needed for accumulate or innerproduct

using namespace std;

void microtomacro_double( vector<double>* Micro_adr, vector<double>* macro_adr, int Nbin, int micres )
{
	fill((*macro_adr).begin(), (*macro_adr).end(), 0.);	// reset macro-state with only 0-entries
	for( int j=0; j<Nbin; j++)
	{
		(*macro_adr).at(j) = double(accumulate( (*Micro_adr).begin()+j*micres, (*Micro_adr).begin()+(j+1)*micres, 0.))/micres;
	}
	return;
}