#define _USE_MATH_DEFINES  //Needed to get pi: M_PI

#include <iostream>
#include <vector>
#include <string>
#include <cmath>
#include <random>

using namespace std;

void InitialProfile(vector<int>* eta_adr, int Npart, string profile)
{
  int Nbins = (*eta_adr).size();
  double dx = 1.0/(double)Nbins;
  double x[Nbins];
  x[0]= 0.5*dx;
  for(int j=1; j<Nbins; j++)
    x[j]=x[j-1]+dx;
  double average = (double)Npart/(double)Nbins;     //Average number of particles per bin
  random_device rd;
  mt19937_64 seed(rd());
  uniform_real_distribution<double> distribution (0.0,1.0);
  double rand_no;
  vector<int>::iterator it;
  int j;
  int cumsum;
  if(profile=="flat") //Flat profile 
    {
      fill((*eta_adr).begin(),(*eta_adr).end(),(int)average);
    }
  else if(profile=="sin") //sin profile
    {
      for(it=(*eta_adr).begin(), j=0; it!=(*eta_adr).end(); it++, j++)
	{
	  cumsum = 0.0;
	  for(int k=0; k<j; k++)
	    {
	      cumsum += (*eta_adr)[k];
	    }
	  (*it) = (int)((double)Npart/2.0*(1.0-cos(M_PI*x[j])))-cumsum;
	  rand_no = distribution(seed);
	  if (rand_no<0.33)
	    (*it)-=1;
	  else if (rand_no >0.66)
	    (*it)+=1;
	  if((*it)<0)
	    (*it)=0;
	}
    }
  else if(profile=="cos") //cos profile
    for(it=(*eta_adr).begin(),j=0; it!=(*eta_adr).end(); it++, j++)
	{
	  cumsum = 0.0;
	  for(int k=0; k<j; k++)
	    {
	      cumsum += (*eta_adr)[k];
	    }	  
	  (*it) = (int)((double)Npart/2.0/M_PI*sin(2*M_PI*x[j]-M_PI)+(double)Npart*x[j])-cumsum;
	  rand_no = distribution(seed);
	  if (rand_no<0.33)
	    (*it)-=1;
	  else if (rand_no >0.66)
	    (*it)+=1;
	  if((*it)<0)
	    (*it)=0;
	}
  else
    {
      cout << "Warning - unknown profile " << profile << ".\n";
    }
  return;
}
