#include <iostream>
#include <fstream>
#include <ctime>     //Needed for clock
#include <string>
#include <stdio.h>   //Needed for printf
#include <vector>
#include <math.h>

using namespace std;

#include "InitialProfile.h"
#include "ZRP_KMC_new.h"
#include "Postprocessing.h"
#include "SavingParameters.h"

int main()
{
  //Configuration parameters and variables
  static int Nbin=5000;                //Number of bins
  static int Npart=79616;                //Number of particles         
  vector<int> eta(Nbin);               //Configuration at current time
  string profile = "sin";             //Initial profile
  string process = "ZRP";
  double x[Nbin];                         //Coordinate at the center of each bin assuming total length 1
  double dx = 1.0/(double)Nbin;
  x[0]= 0.5*dx;
  for(int j=1; j<Nbin; j++)
      x[j]=x[j-1]+dx;    
  //Time parameters
  static double t_equilibration=100/pow(5000.0,2.0);    //Time for equilibration
  static double t_randomize=0.1/pow(5000.0,2.0);       //Time to create different initial conditions, after t_equilibration
  static double dt=1/pow(5000.0,2.0);              //Time to calculations actually used
  static double t_factor = pow((double)Nbin,2.0);        //t_micro = t_macro*t_factor
  //Sampling parameters
  static int R = 2000;                               //Number of realizations
  static int Req = 50;
  //Filter function parameters
  //static double x0_range[]={0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9};
  static double x0_range[]={0.025,0.05,0.075,0.1,0.125,0.15,0.175,0.2,0.225,0.25,0.275,0.3,0.325,0.35,0.375,0.4,0.425,0.45,0.475,0.5,0.525,0.55,0.575,0.6,0.625,0.65,0.675,0.7,0.725,0.75,0.775,0.8,0.825,0.85,0.875,0.9,0.925,0.95,0.975}; //concentration points of the gamma functions
  int Ngamma = (int)(sizeof(x0_range)/sizeof(x0_range[0]));
  static double a1=160.0;
  static double a2=2.0;
  //Output variables
  ofstream myfile;
  char filename[200];  
  string full_filename;  
  double rho_gN_initial[R*Ngamma];                                     
  double rho_gN_final[R*Ngamma]; 
  string file_path="/mnt/data/p_creina/ZRP_k2/dT/dT_0/";
  //Timer
  clock_t t=clock();
  
  //Saving parameters on summary file
  SavingParameters(file_path,Nbin, Npart,profile,process,t_equilibration,t_randomize,dt,t_factor,R,Ngamma,x0_range,a1,a2);


  for(int req=0; req<Req; req++)
    {
      //Initialization
      InitialProfile(&eta, Npart, profile);
      /*   for(int j=0; j<Nbin; ++j)
	    cout << eta[j] << ", ";
	cout <<endl; 
      */
       	      
      //Equilibration configuration ZRP
      if(process=="ZRP")
	ZRP_KMC_new(&eta,t_equilibration*t_factor); 
      else
	cout<< "Invalid process" << endl;
      
      vector<int> eta_eq(eta);  
      t=clock()-t;
      printf("It took me %f seconds to equilibrate.\n",((float)t)/CLOCKS_PER_SEC);
      
      //Saving parameters on data file
      sprintf(filename,"Data_Nbin_%d_Npart_%d_req_%d.m",Nbin,Npart,req);
      full_filename=file_path+filename;
      myfile.open(full_filename);
      if(myfile.is_open()){
	myfile << "\%It took " << ((float)t)/CLOCKS_PER_SEC << " seconds to equilibrate\n";
	myfile << "\%<rho^N_initial,gamma1>, <rho^N_final,gamma1>, <rho^N_initial,gamma2>, <rho^N_final,gamma2>, ...\n";
	myfile << "rho_gN_initial_final = [";
	myfile.close();
      }

      //Various realizations
      vector<int> eta_initial(eta);
      if(process=="ZRP")
	{
	  for(int r=0; r<R; r++)
	    {
	      eta=eta_eq;
	      ZRP_KMC_new(&eta,t_randomize*t_factor);
	      eta_initial = eta;
	      ZRP_KMC_new(&eta,dt*t_factor);
	      Postprocessing(x,&eta_initial,&eta,rho_gN_initial,rho_gN_final,x0_range,a1,a2,r,R,Ngamma,full_filename);
	    }
	}
      else
	cout<< "Invalid process" << endl;
      
      t=clock()-t;
      printf("It took me %f seconds to do %d samples.\n",((float)t)/CLOCKS_PER_SEC,R);
      myfile.open(full_filename,ios::app);
      if(myfile.is_open()){
	myfile << "\%It took " << ((float)t)/CLOCKS_PER_SEC << " seconds to do " << R << " samples";
	myfile.close();
      }

    }
  
  //Terminate the program
  return 0;
}
