#include <iostream>
#include <fstream>
#include <ctime>
#include <vector>
#include <string>
#include <math.h>
using namespace std;

void Postprocessing(double x[], vector<int>* eta_initial_adr,vector<int>* eta_adr,double* rho_gN_initial, double* rho_gN_final,double x0_range[], double a1, double a2, int r, int R, int Ngamma, string filename)
{
  //Parameter declaration
  ofstream myfile;  
  int Nbin = (*eta_adr).size();      //Number of bins
  double dx=1/(double)Nbin;          //size of bin
  //Postprocessing and saving
  myfile.open(filename,ios::app);
  myfile.precision(11);
  for(int j=0; j< Ngamma; j++)
    {
      int k=0;
      rho_gN_initial[r*Ngamma+j]=0;
      rho_gN_final[r*Ngamma+j]=0;
      while(x[k] < (x0_range[j]-1.0/a1))
	k++;
      while(x[k] < (x0_range[j]+1.0/a1))
	{
	  double gamma_x = pow(max(0.,1.0-pow(a1*fabs(x[k]-x0_range[j]),a2)),a2);
	  rho_gN_initial[r*Ngamma+j]=rho_gN_initial[r*Ngamma+j]+ gamma_x*((*eta_initial_adr)[k])*dx;
	  rho_gN_final[r*Ngamma+j]=rho_gN_final[r*Ngamma+j]+ gamma_x*((*eta_adr)[k])*dx;
	  k++;
	}      
      myfile << rho_gN_initial[r*Ngamma+j] << ", " << rho_gN_final[r*Ngamma+j];
      if(j==Ngamma-1)
	{
	if(r==R-1)
	  myfile << "];";
	else
	  myfile << ";\n";
	}
      else
	myfile << ",";
    }
  myfile.close();
  return;
}
