function Postprocessing_m(Req,Rs)
 
%Loading files containing Nbin, Npart, R, Ngamma, x0_range, a1, a2 and rho_gN_initial_final
Npart=79616;
summary_file=['Summary_Nbin_5000_Npart_',num2str(Npart)];
feval(summary_file);

m=zeros(Ngamma,1);
m_SD=zeros(Ngamma,1);
rho=zeros(Ngamma,1);

for j=1:Ngamma
    rho_gN_initial=[];
    rho_gN_final=[];
    for req=1:Req
	data_file=['Data_Nbin_5000_Npart_',num2str(Npart),'_req_',num2str(req-1)];
        feval(data_file);

        %Calculation of the Phi for each gamma function

        rho_gN_initial=[rho_gN_initial;rho_gN_initial_final(1:Rs,2*(j-1)+1)];
        rho_gN_final=[rho_gN_final;rho_gN_initial_final(1:Rs,2*(j-1)+2)];
    end
    rho_g_ave_initial=mean(rho_gN_initial);
    rho_g_ave_final=mean(rho_gN_final);

    Y_gN_initial=sqrt(Nbin)*(rho_gN_initial-rho_g_ave_initial);
    Y_gN_final=sqrt(Nbin)*(rho_gN_final-rho_g_ave_final);
    fluctuation=mean((Y_gN_final-Y_gN_initial).^2)/dt;

    dx=1/Nbin;
    x=0:dx:1;
    gamma=max(0.,1.0-(a1*abs(x-x0_range(j))).^a2).^a2;
    dgamma=diff(gamma)/dx;
    dgamma2=sum(dgamma.*dgamma)*dx;
    gamma_int=sum(gamma)*dx;
    rho(j)=0.5*(rho_g_ave_initial + rho_g_ave_final)/gamma_int;
    m(j) = fluctuation/dgamma2;
    m_N=(Y_gN_final-Y_gN_initial).^2/dt/dgamma2;
    m_SD(j)=std(m_N);
end


myfile = fopen([summary_file,'.m'],'a');
fprintf(myfile,'%% Expected value of rho, Phi and standard deviation of Phi associated to each gamma\n');
fprintf(myfile,'rho_Req_%d_R_%d=[%6.3f',Req,Rs,rho(1));
for j=2:Ngamma
	fprintf(myfile,', %6.3f',rho(j));
end
fprintf(myfile,'];\n');
fprintf(myfile,'m_Req_%d_R_%d=[%6.3f',Req,Rs,m(1));
for j=2:Ngamma
	fprintf(myfile,', %6.3f',m(j));
end
fprintf(myfile,'];\n');
fprintf(myfile,'m_SD_Req_%d_R_%d=[%6.3f',Req,Rs,m_SD(1));
for j=2:Ngamma
	fprintf(myfile,', %6.3f',m_SD(j));
end
fprintf(myfile,'];\n\n');
fclose(myfile);

end
