#include <iostream>
#include <fstream>
#include <ctime>
#include <vector>
#include <string>
#include <math.h>
using namespace std;

void SavingParameters(string file_path,int Nbin,int Npart,string profile, string process,double t_equilibration, double t_randomize,double dt, double t_factor, int R, int Ngamma, double x0_range[],double a1,double a2)
{
  ofstream myfile;
  char filename[200];
  sprintf(filename,"Summary_Nbin_%d_Npart_%d.m",Nbin,Npart);
  myfile.open(file_path+filename);
  if(myfile.is_open())
    {
      myfile << "\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\n";
      myfile << "\%Parameters of the simulation, " << profile << " profile, " << process << " process \n\n";
      myfile <<"\%Geometry\n";
      myfile << "Nbin=" << Nbin << ";\t\t\t \%Number of bins \n";
      myfile << "Npart=" << Npart << ";\t\t\t \%Number of particles \n\n";
      myfile << "\%Times\n";
      myfile << "t_equilibration=" << t_equilibration << ";\t\t \%Time for equilibration \n";
      myfile << "t_randomize=" << t_randomize << ";\t\t \%Time to create different initial conditions\n";
      myfile << "dt=" << dt << ";\t\t\t \% Short interval of actual calculations\n";
      myfile << "t_factor=" << t_factor << ";\t\t \%T=t_factor*t (ratio between micro and macro scale)\n\n";
      myfile << "\%Sampling parameters\n";
      myfile << "R=" << R << ";\t\t\t\t \%Number of realizations\n\n";
      myfile << "\%Filter function paratmeters\n";
      myfile << "Ngamma=" << Ngamma << ";\t\t\t \%Number of localization points for the filter function in x0_range\n";
      myfile << "x0_range=[" << x0_range[0];
      for(int j=1; j<Ngamma; j++)
	myfile << ", " << x0_range[j];
      myfile << "];\n";
      myfile << "a1=" << a1 << ";\t\t\t\t \%Parameter a1 of filter function \n";
      myfile << "a2=" << a2 << ";\t\t\t\t \%Parameter a2 of filter function \n\n";
      myfile << "\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\n\n";
      myfile.close();
    }

  return;
}
