#include "MCcontrol.h"

//GLOBAL VARIABLES instantiated here, listed as in header. I hate C++ already.
string inpfilename;
bool given_title = false;
bool hastitle = false;
string title;
bool given_elements = false;
bool given_poly = false;
vector< Polyspec > polyspec; // spec when given
bool given_bond = false;
vector< Bondspec > bondspec; // spec when given
bool given_option = false;
bool given_contact = false;
bool given_grid = false;
double gridmin = 3.0; // grid boxes at least this size.
//gridmin = 3.0;
double regrid_after = 0.1; //max move before implementing a regrid
double polypad = 1.3; // multiplier on bondlength when finding poly bonding
bool do_jiggle = false;
double jigsize = 0.1; //jiggle in Angstroms //implement!
bool given_relax_command = false;
bool chebyshev = false; // not by default - explodes on contacts! // replace these with int docheb status
double cheb = 1.0; // over-relaxation factor
bool use_auto_chebyshev = false; //dynamic chebyshev updater
double dampclash = 0.5; // stabilise clash calculations in move
bool criterion_mis = false;
double smallmovecriterion = 1E-6; // stop when move is this small
double smallmiscriterion = 1E-3; // and when mis is this small?
bool given_input = false;
bool given_structure = false;
string input_structure_name;
bool given_new_structure = false;
string new_structure_name;
bool given_bond_input = false;
string input_bonding_name;
vector< Bondline > bondline; //bonds from input file if given
bool given_new_cell = false;
bool do_label = false; // output labels in the xtl output!
bool given_output = false;
bool do_output_structure = false;
string output_structure_name;
bool do_output_bonding = false;
string output_bonding_name;
bool do_output_poly = false;
string output_poly_name;
bool do_output_clusters = false;
string output_clusters_name;
bool do_output_bonds = false;
string output_bonds_name;
bool do_output_angles = false;
string output_angles_name;
bool do_output_mismatches = false;
string output_mismatches_name;
bool nodeloc = false; // do not include delocalisation rigidity
double mcvdwtol = 0.1 ; // make an option later
double maxradius = 0.0; //set once we have elements

bool given_seed = false;
long int seed;
bool do_mctransform = false;
bool do_generate = false;
vector < int > genN;

bool do_mcrun = false;
int mctrials = 2, mcfreq = 1; // total attempts and writeout frequency
int tried=0, accepted=0, rejected=0, clashrejected=0, linkrejected = 0;
string mcname;
bool givenmcname = false;

//bool do_read_mcpot = false;
bool given_mcpot = false;
string mcpotname;

double mct=1.; // MC temperature
double oldenergy=0., tryenergy=0.; // structure energies for MC
bool given_mct = false;
double gasconst = 8.3144621; //in J/mol.K

Structure inputstructure; // use for initial reading or construction
Structure structure; // used when actually running
Structure newstructure; // used if a restart position is given
vector< double > newcellparam; // used if new cell is given

vector< Ligand > ligand; // if I have any
bool given_ligand = false;
vector< Poly > MCpoly; //

vector< MCPot > mcpot; // potentials
double maxr=0.;

//arrays to handle energy potential calculations
vector< bool > inapot; // am I relevant?
vector< vector< int > > whichpot; // what potentials do I belong to?
vector< vector< int > > partner; // the other element in this potential
vector< vector< double > > rmax; // the range of this potential

//toggles to control Monte Carlo small/large moves
bool use_small_move = false;
double smallmovesize = 0.;
bool given_mcprobs = false;
double bigprob = 1.;
double smallprob = 1.;

double RDFbin = 0.1;
double RDFmax = 10.0;
bool doRDF = false;
string rdfbasename;
bool givenrdfbasename = false;

bool dolog = false;
string logname = "MClog.txt"; //default 
int logfreq = 1000; //default

vector< vector< int > > overlapArray;
vector< bool > overlapFilter;
bool doOverlaps = false;
string overlapname = "overlap"; //default
vector< int > overlapHistogram, metalHistogram; //counts!

bool doCollective = false;
vector< vector< int > > supercluster; // supercluster n is a list of clusters i,j...
//supercluster is no longer used in main MC but is used in phase finding
double pCollective = 0.5;
double pLink = 0.5;

vector< int > groupsMade, groupsAccepted; //stat tracker for group moves

bool track3s = false;
vector< vector< int > > savedOA; //saved overlap array for change tracking
vector< int > setA, setB, disA, disB;
vector< int > setA3s, setB3s, disA3s, disB3s;
vector< int > tally3s;
vector< int > GBA, LBA, GBD, LBD;
string log3name="MClog3.txt"; //;placing a default value like MClog.txt


ostream &operator<<(ostream &out, const Ligand &c){
	for ( int q = 0 ; q < c.species.size(); q++){
		out << c.species.at(q) << " " << c.pos.at(q) << endl; 
	}
}

bool Ligand::ligandcluster(){
	//make the ligand's cluster object
	Vector meanpos = nullvec;
	for ( int i = 0; i < pos.size(); i++){
		meanpos += pos.at(i); // adding...
		atom.push_back( nullatom ); // filling array for later
	}
	if ( pos.size() > 0 ) meanpos /= pos.size(); // average
	clust.cpos = meanpos ; // info in
	cerr << "Ligand centre position: " << meanpos << endl;
	for ( int i = 0; i < pos.size(); i++){
		clust.members.push_back(i); // placeholder!
		atom.at(i).species = species.at(i); // pass info!
		atom.at(i).pos = pos.at(i); // pos into atom
		atom.at(i).initial_pos = pos.at(i); // pos into atom
		atom.at(i).inclust.push_back( 0 ); // only one in the ligand!
		atom.at(i).isvertex.push_back( i ); // vertex labels
		atom.at(i).hybrid = 1; // just to guarantee rigidity
		Vector bondvec = pos.at(i) - clust.cpos;
		clust.bond.push_back( bondvec ); //bonds into the cluster
		cerr << "Ligand bond " << i+1 << ": " << bondvec << endl;
	}	
	
	for ( int i =0; i < atom.size(); i++) {
		atom.at(i).type = -1;
		for ( int e = 0 ; e < element.size() ; e++ ){
			if ( atom.at(i).species == to_lower(element.at(e).species) ){
				atom.at(i).type = e;
                atom.at(i).radius = element.at(e).radius;
                atom.at(i).role = element.at(e).role; // transfers role for MC use
                break;
            }
        }
        if ( atom.at(i).type == -1 ){
			cerr << "Unrecognised element: " << atom.at(i).species << endl;
			return false; // choked
		}
		if ( atom.at(i).role == 1 ){
			cerr << "Labelled reactive atom " << i+1 << endl;
		}
	}
	
	cerr << "Scanned " << atom.size() << " atoms." << endl;
	return true; // done initialisation
}

void Ligand::ligbondfind( vector< Bondspec > bondspec ){
       for ( int i = 0; i < bondspec.size(); i++ ) {
           string asp = bondspec.at(i).speciesA;
           double within = bondspec.at(i).within;
           double testw = within * within;
           
           for ( int j = 0 ; j < atom.size(); j++ ){
               if ( atom.at(j).species != asp ) continue; //skip not centre
               for ( int k = j+1 ; k < atom.size() ; k++ ){
				   string ksp = atom.at(k).species; //
				   for ( int q = 0 ; q < bondspec.at(i).speciesB.size() ; q++){
					      string bsp = bondspec.at(i).speciesB.at(q);
					      if ( ksp != bsp ) continue; // not right species
					      Vector rel = pos.at(j) - pos.at(k); // vector between atoms
					      double drel2 = rel.sq(); // compare to bondwithin
					      if ( drel2 < testw ){
							  //atoms close enough to bond
							  cerr << "Detected bonding of atoms " << j+1 << " " << asp << " " << k+1 << " " << ksp << endl;
							  if ( !isin ( k , atom.at(j).bondto ) ){
								atom.at( j ).bondto.push_back( k );
								atom.at( k ).bondto.push_back( j );
								cerr << "Bonding " << j+1 << " to " << k+1 << endl;                        
							  }
						  }
				   }
				   
			   }
               
           }
           
       }
       cerr << "Checking bonding." << endl;
       for ( int j = 0; j < atom.size(); j++ ){
		   int hn = atom.at(j).bondto.size();
		   if ( hn == 0 ){
			   cerr << "WARNING: unbonded atom " << j+1 << " in ligand." << endl;
		   }
	   }
}


//function to make the coefficients
void MCPot::makeh(){
	//first, construct the gradient for each keypoint;
	//I need as many gradients as there are keypoint values
	cerr << "Potential has " << r.size() << " keypoints." << endl;
	int topindex = r.size() - 1;
	cerr << "Topindex: " << topindex << endl;
	grad.resize( r.size() );
	//zero at initial and final
	grad.at(0) = 0.;
	grad.at( topindex ) = 0.;
	//intermediates:
	//zero max and min
	//interpolate others
	for ( int i = 1; i < topindex; i++ ){
		double thisval = E.at( i );
		double previous = E.at( i-1 );
		double next = E.at( i+1 );
		
		if ( previous < thisval && next < thisval ){
			grad.at( i ) = 0; //max
		}
		else if ( previous > thisval && next > thisval ){
			grad.at( i ) = 0; //min
		}
		else{
			//interpolate
			double deltaR = r.at( i+1 ) - r.at( i-1 );
			double deltaE = E.at( i+1 ) - E.at( i-1 );
			grad.at( i ) = deltaE / deltaR ;
		}
	}
	for ( int i = 0 ; i < grad.size() ; i++ ){
		cerr << "Gradient at keypoint " << i << " = " << grad.at(i) << endl;
	}
	
	//second, construct the h coefficients
	//I need coefficients for each keypoint from 0 to topindex-1
	//not for the last point as it's the end.
	//trap later
	h0.resize( topindex ); //topindex is one less than size of r
	h1.resize( topindex );
	h2.resize( topindex );
	h3.resize( topindex );
	for ( int i = 0 ; i < topindex ; i++ ){
		double delta = r.at( i+1 ) - r.at( i );
		h0.at( i ) = E.at( i );
		h1.at( i ) = grad.at( i ) * delta ;
		h2.at( i ) = 3*E.at( i+1 ) - 2*E.at( i ) - delta*grad.at( i+1 ) - 2*delta*grad.at( i );
		h3.at( i ) = E.at( i ) + delta*grad.at( i+1 ) + delta*grad.at( i ) - 2*E.at( i+1 );
		cerr << "Spline h: " << i << " : " << h3.at( i ) << " , " << h2.at( i ) << " , " << h1.at( i ) << " , " << h0.at( i ) << endl;
	}
	
}

//function to return potential E for a given r
double MCPot::pot( double rin ){
	double result;
	int slot;
	//identify the r category into which we fall
	//trap for r below minimum!
	if ( rin < r.at( 0 ) ){
		slot = 0; //trap r as well at u stage
	}
	
	//return 0 if beyond max r
	if ( rin >= r.at( r.size() -1 ) ){
		result = 0.;
		return result;
	}
	//else find a box
	for ( int i = 1; i< r.size(); i++ ){
		if ( rin < r.at( i ) ){
			slot = i-1;
			break; // found a good box
		}
	}
	
	//construct reduced variable u for this block;
	double u;
	if ( rin < r.at( 0 ) ){
		 u = 0;
	}
	else{
		u = ( rin - r.at( slot ) ) / ( r.at( slot+1 ) - r.at( slot ) );
	}
	
	//construct E based on u and coefficients
	result = h0.at( slot ) + h1.at(slot)*u + h2.at(slot)*u*u + h3.at(slot)*u*u*u; //cubic spline
	return result;
}

string MCPot::pothead(){
	stringstream res;
	res << "POT " << sp1 << " " << sp2;
	if ( rider > 0 ) res << " " << rider;
	res << endl;
	return res.str();
}

string MCPot::graphpot(){
	stringstream res;
	double rmin = r.at(0);
	double rmax = r.at( r.size() -1 );
	double workingr = rmin;
	while ( workingr < rmax+0.001 ){
		res << workingr << " " << pot( workingr ) << endl;
		workingr += 0.1; // increment
	}
	return res.str(); // string back
}



bool readpotential( string filename, vector< MCPot > &mcpot ){
	cerr << "Reading a potential file." << endl;
	
	MCPot potin; // use for readin;
	MCPot dummypot; // keep this one blank for resetting
	mcpot.clear(); // clear the decks;
	string linein;
	string foo;
	vector< string > tokensin;
	
	bool inpot = false;
	
	//try to open the file
     ifstream potfile( filename.c_str() );
     if ( potfile.fail() ) {
        cerr << "Problem! Cannot read file " << filename << endl;
        return false;     
     }

     while( getline(potfile, foo) ){
		 linein = to_lower(foo);// lose case for simplicity
		 tokensin = chop(linein, " \t");
		 if (tokensin.size() == 0 ) continue; //blank line
		 
		 if ( !inpot ){
			 if ( tokensin.at(0) == "pot" ){
				 //should be a potential line
				 if ( tokensin.size() < 3 ){
					 cerr << "Not enough entries for potential header: " << linein << endl;
					 return false;
				 }
				 //is okay
				 inpot = true; //reading potential
				 potin = dummypot; // clear an MCpot entry
				 potin.sp1 = tokensin.at(1);
				 potin.sp2 = tokensin.at(2);
				 cerr << "Species in potential: " << potin.sp1 << " " << potin.sp2 << endl;
				 if ( tokensin.size() > 3 ){
					 potin.rider = atoi( tokensin.at(3).c_str() );
					 cerr << "With rider: " << potin.rider << endl;
				 }
				 
			 }
		 }
		 else{  // we're inside a potential block
			if ( tokensin.at(0) == "end" ){
				cerr << "Finished reading potential block." << endl;
				//end of block
				inpot = false;
				potin.makeh(); // set up the spline parameters and arrays
				cerr << endl << potin.pothead();
				cerr << potin.graphpot();
				cerr << endl;
				mcpot.push_back( potin );// push back the potential we just finished reading
			}
			else{
				//we should be reading a line
				if ( tokensin.size() < 2 ){
					cerr << "Bad line " << linein << " in potential block." << endl;
					return false;
				}
				potin.r.push_back( atof( tokensin.at(0).c_str() ) );
				potin.E.push_back( atof( tokensin.at(1).c_str() ) );
				cerr << "Read line " << linein << endl;				
			} 
		 }
		 
	 }	
	
	return true; // all done reading and nothing broke
}






//
//validation routine checks for a valid input before running
//
bool validation(){
     cerr << "Entering validation process." << endl;
     //if ( ! given_input ) {
     //   cerr << "FATAL: No input block given." << endl;
     //   return false;
     //}     
     //if ( ! given_structure ) {
     //   cerr << "FATAL: No input structure given." << endl;
     //   return false;
     //}     
     if ( ! given_elements || ( inputstructure.element.size() == 0 ) ) {
        cerr << "FATAL: No elements given." << endl;
        cerr << "Leeloo Dallas multipass." << endl;
        return false;
     }
     if ( ! given_output ) {
        cerr << "WARNING: no output requested. Really?" << endl;
     }    
     if ( ( ! given_bond) && ( ! given_poly ) ) {
        cerr << "FATAL: No cluster-building information." << endl;
        cerr << "Please provide at least one of: BOND block, POLY block." << endl;
        return false;
     }

     //if ( ( given_new_structure || given_new_cell ) && ! given_relax_command ) {
     //   cerr << "FATAL: must request relax to adapt to new structure or cell." << endl;
     //   return false;     
     //}
     if ( given_bond && ( bondspec.size() == 0 ) ){
          cerr << "WARNING: BOND block given but I have no bond specifications. Really?" << endl;
     }
     if ( given_poly && ( polyspec.size() == 0 ) ){
          cerr << "WARNING: POLY block given but I have no poly specifications. Really?" << endl;
     }
     if ( bondspec.size() == 0 && polyspec.size() == 0 ) {
          cerr << "FATAL: no bond or poly specifications given, cannot build clusters!" << endl;
          return false;
     }
     if ( do_generate && do_mcrun ){
		 cerr << "FATAL: cannot invoke GENERATE and RUN together." << endl;
		 return false;
	 }
     if ( do_generate && do_mctransform ){
		 cerr << "FATAL: cannot invoke GENERATE and TRANSFORM together." << endl;
		 return false;
	 }
     if ( do_mcrun && do_mctransform ){
		 cerr << "FATAL: cannot invoke RUN and TRANSFORM together." << endl;
		 return false;
	 }     
	 if ( do_generate ){
		cerr << "GENERATE function invoked, checking:" << endl;
		cerr << "I am aware of " << polyspec.size() << " polyhedral types and ";
		cerr << ligand.size() << " ligand types." << endl;
		int totthings = polyspec.size() + ligand.size();
		cerr << "I am aware of " << genN.size() << " numbers to make." << endl;
		if ( genN.size() != totthings ){
			cerr << "FATAL: cannot get numbers for generation." << endl;
			return false;
		}
		if ( !given_new_cell ){
			cerr << "FATAL: GENERATE function requires NEW CELL in input to create box." << endl;
			return false;
		}
	 }
	 if ( do_mcrun ){
		 if ( !givenmcname ){
			cerr << "WARNING: no MCNAME given to name file output?" << endl;
		 }
		 if ( mcfreq > mctrials ){
			 cerr << "WARNING: MCFREQ exceeds MCTRIALS, really?" << endl;
		 }
	 }
	 if ( doRDF ){
		 if ( !do_mcrun && !givenrdfbasename ){
			 cerr << "ERROR: I need an RDFNAME for RDF output files." << endl;
			 return false;
		 }
		 if ( do_mcrun && !givenmcname ){
			 cerr << "ERROR: need an MCNAME for RDF output files during MC run." << endl;
			 return false;
		 }
	 }
	 if ( given_mcprobs && !use_small_move ){
		 cerr << "FATAL: must specify mcsmall option if giving big and small weights." << endl;
		 return false;
	 }
	 if ( use_small_move && !given_mcprobs ){
		 cerr << "NOTE: no explicit MC big/small probability weights given." << endl;
		 cerr << "   Setting equal probability weights for both." << endl;
		 bigprob = 1.0;
		 smallprob = 1.0;
	 }


  cerr << "Input logic valid, proceeding." << endl;
  return true; // passed logic tests    
}

//
//read the config file for MCGasp
//
bool readcommands( string commandfilename){
     string linein;
     string foo; //use as buffer
     string foofoo; //use to store case sensitive file names!
     vector< string > tokensin;
     vector< string > toktok; //un-lowercased tokensin
     vector< string > unhashed;
     vector< string > unhashed_toktok;
     ifstream inputfile( commandfilename.c_str() );
     
     if ( inputfile.fail() ) {
        cerr << "Problem! Cannot read file " << commandfilename << endl;
        return false;     
     }

     bool isinblock = false; // are we in a defined block?
     //keywords: title element input bond poly option output
     bool intitle = false;
     bool inelement = false;
     bool ininput = false;
     bool inbond = false;
     bool inpoly = false;
     bool inoption = false;
     bool inoutput = false;
     bool inligand = false;
     ligand.clear(); // clearing array if needed
     int trackligand;
     
     bool iskey = false; // spot keywords
     bool isslash = false; // spot block-ending slash markers
     double bondwithin = 2.0; //check for labelled bond blocks!
     double defaultbondwithin = 2.0;

     while ( getline(inputfile, foo) ){
           iskey = false;
           isslash = false;
           
           foofoo = foo;
           linein = to_lower( foo ) ; // all lower case for simplicity
           
           tokensin = chop(linein, " \t"); // array of tokens     
           toktok = chop( foofoo, " \t"); //non-lowercased tokens for file names
           unhashed.clear();
           unhashed_toktok.clear();
           if ( tokensin.size() < 1 ){
              continue; // blank line
           }
           // drop everything after the first hash token
           for ( int i = 0 ; i < tokensin.size() ; i++ ) {
               string hasher = tokensin.at(i).substr(0,1); // first character
               if ( hasher == "#" ) break; // leave for loop now
               unhashed.push_back( tokensin.at(i) ); // unhashed skips all hash
               unhashed_toktok.push_back( toktok.at(i) ); //unhashed version
           }
           if ( unhashed.size() < 1 ){
              continue; // nothing left but hashes and whitespace
           }
           //if we're here, we have something to do

           if ( isinblock ){
              //check for block-ending tag
              string wordone = unhashed.at(0);
              string slasher = wordone.substr(0,1); // first character of first word
              if ( slasher == "/" ) {
                 isslash = true; // now what?
                 //cerr << "Slasher movie at line: " << foo << endl;         
                 //Check if this is the element ending the current block, or a mistake
                 if ( wordone == "/title"){
                      if ( intitle ) {
                           isinblock = false;
                           intitle = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /title keyword, not in title block." << endl;
                           return false;
                      }
                 }
                 if ( wordone == "/element"){
                      if ( inelement ) {
                           isinblock = false;
                           inelement = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /element keyword, not in element block." << endl;
                           return false;
                      }
                 }
                 if ( wordone == "/input"){
                      if ( ininput ) {
                           isinblock = false;
                           ininput = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /input keyword, not in input block." << endl;
                           return false;
                      }
                 }
                 if ( wordone == "/bond"){
                      if ( inbond ) {
                           isinblock = false;
                           inbond = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /bond keyword, not in bond block." << endl;
                           return false;
                      }
                 }
                 if ( wordone == "/poly"){
                      if ( inpoly ) {
                           isinblock = false;
                           inpoly = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /poly keyword, not in poly block." << endl;
                           return false;
                      }
                 }                 
                 if ( wordone == "/option"){
                      if ( inoption ) {
                           isinblock = false;
                           inoption = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /option keyword, not in option block." << endl;
                           return false;
                      }
                 }                    
                 if ( wordone == "/output"){
                      if ( inoutput ) {
                           isinblock = false;
                           inoutput = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /output keyword, not in output block." << endl;
                           return false;
                      }
                 }                 
                 if ( wordone == "/ligand"){
                      if ( inligand ) {
                           isinblock = false;
                           inligand = false;
                           continue; // go for next line        
                      }
                      else {
                           //wrong block!
                           cerr << "FATAL: /ligand keyword, not in ligand block." << endl;
                           return false;
                      }
                 } 
              } // that's the end of the slash check
              //check for data according to block type
              
              if ( intitle ) {
                   //title processing
                   title = linein;
                   hastitle = true;
                   cerr << "Title: " << linein << endl;
              }
              else if ( inelement ) {
                   //element processing
                   if ( unhashed.size() > 1 ) {
                        char dig = unhashed.at(1).at(0);
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in element block." << endl;
                             continue; // not suitable to be an element spec     
                        }
                        Element newelement;
                        newelement.species = unhashed.at(0);
                        newelement.role = 0;
                        newelement.radius = atof( unhashed.at(1).c_str() );
                        //MC check on reactive label
                        if ( unhashed.size() > 2 ){
							if (  unhashed.at(2).substr(0,1) == "r" ){
								//reactive label
								newelement.role = 1;
							}
							else if (  unhashed.at(2).substr(0,1) == "m" ){
								//metal label
								newelement.role = -1;
							}
						}
                        inputstructure.element.push_back( newelement );
                        //if ( newelement.radius > maxrad ) maxrad = newelement.radius; // track biggest sphere
                        cerr << "Found element " << newelement.species << " , " << newelement.radius << endl;
						if ( newelement.role == 1 ) cerr << "Element " << newelement.species << " is REACTIVE." << endl;
						if ( newelement.role == -1 ) cerr << "Element " << newelement.species << " is METAL." << endl;
                   }
              }   
              else if ( ininput ) {
                   //input processing
                   if ( unhashed.size() < 2 ){
                        cerr << "Skipping line " << linein << " in input block." << endl;
                        continue; // all entries must be two or more tokens!
                   }
                   if ( unhashed.at(0) == "structure" ) {
                        given_structure = true;
                        input_structure_name = unhashed_toktok.at(1);
                        cerr << "Will read input structure from " << input_structure_name << endl;
                        continue; // read next line
                   }
                   if ( unhashed.at(0) == "bonding" ) {
                        given_bond_input = true;
                        input_bonding_name = unhashed_toktok.at(1);
                        cerr << "Will read input bonding from " << input_bonding_name << endl;
                        continue;
                   }
                   if ( unhashed.at(0) == "mcpot" ) {
                        given_mcpot = true;
                        mcpotname = unhashed_toktok.at(1);
                        cerr << "Will read MC potential from " << mcpotname << endl;
                        continue;
                   } 
                   if ( unhashed.at(0) == "new" ){
                        if ( unhashed.at(1) == "structure" ) {
                             if ( unhashed.size() > 2 ) {
                                  given_new_structure = true;
                                  new_structure_name = unhashed_toktok.at(2);
                                  cerr << "New structure given in file " << new_structure_name << endl;
                                  continue;
                             }
                             else {
                                  cerr << "Skipping line " << linein << " in input block." << endl;
                                  continue;
                             }
                        }
                        else if ( unhashed.at(1) == "cell" ) {
                             if ( unhashed.size() < 8 ) {
                                  cerr << "Skipping line " << linein << " in input block." << endl;
                                  continue;
                             }
                             else{
                                  cerr << "New cell params from line " << linein << endl;
                                  given_new_cell = true;
                                  newcellparam.clear();
                                  for ( int i = 0 ; i < 6 ; i++ ) {
                                      double param = atof( unhashed.at(i+2).c_str() );
                                      newcellparam.push_back( param );
                                  }
                                  continue;
                             }
                        }
                   }               
                   
              }           
              else if ( inbond ) {
                   //bond processing
                   if ( unhashed.size() > 1 ) {
                        cerr << "Bonding: " << linein << endl;
                        Bondspec newbondspec;
                        newbondspec.within = bondwithin;
                        newbondspec.speciesA = unhashed.at(0);
                        newbondspec.speciesB.clear();
                        for ( int i = 1 ; i < unhashed.size() ; i++ ){
                            newbondspec.speciesB.push_back( unhashed.at(i) ) ;
                        }
                        bondspec.push_back( newbondspec );
                   }
              }               
              else if ( inpoly ) {
                   //poly processing
                   if ( unhashed.size() > 3 ) {
                        char dig = unhashed.at(3).at(0); // fourth item should be a bondlength!
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in poly block." << endl;
                             continue; // not suitable to be a poly spec     
                        }
                        string key = unhashed.at(0).substr(0,3);
                        if ( key == "tet" ){
                             //tetrahedron
                             Polyspec newpolyspec;
                             newpolyspec.shape = 1; // type 1 is tetrahedron
                             newpolyspec.c_species = unhashed.at(1);
                             newpolyspec.v_species = unhashed.at(2);
                             newpolyspec.bondlength = atof( unhashed.at(3).c_str() );
                             polyspec.push_back ( newpolyspec);
                             cerr << "Found TETrahedron on line: " << linein << endl;
                             continue;
                        }
                        if ( key == "squ" ){
                             //square
                             Polyspec newpolyspec;
                             newpolyspec.shape = 4; // type 4 is square planar
                             newpolyspec.c_species = unhashed.at(1);
                             newpolyspec.v_species = unhashed.at(2);
                             newpolyspec.bondlength = atof( unhashed.at(3).c_str() );
                             polyspec.push_back ( newpolyspec);
                             cerr << "Found SQUare on line: " << linein << endl;
                             continue;
                        }
                        if ( key == "oct" ){
                             //octahedron
                             Polyspec newpolyspec;
                             newpolyspec.shape = 2; // type 2 is octahedron
                             newpolyspec.c_species = unhashed.at(1);
                             newpolyspec.v_species = unhashed.at(2);
                             newpolyspec.bondlength = atof( unhashed.at(3).c_str() );
                             polyspec.push_back ( newpolyspec);
                             cerr << "Found OCTrahedron on line: " << linein << endl;
                             continue;
                        }
                        if ( key == "tri" ){
                             //triangle
                             Polyspec newpolyspec;
                             newpolyspec.shape = 3; // type 3 is triangle
                             newpolyspec.c_species = unhashed.at(1);
                             newpolyspec.v_species = unhashed.at(2);
                             newpolyspec.bondlength = atof( unhashed.at(3).c_str() );
                             polyspec.push_back ( newpolyspec);
                             cerr << "Found TRIangle on line: " << linein << endl;
                             continue;
                        }                        
                        if ( key == "bar" ){
                             //bar
                             Polyspec newpolyspec;
                             newpolyspec.shape = 5; // type 5 is bar (diatomic)
                             newpolyspec.c_species = unhashed.at(1);
                             newpolyspec.v_species = unhashed.at(2);
                             newpolyspec.bondlength = atof( unhashed.at(3).c_str() );
                             polyspec.push_back ( newpolyspec);
                             cerr << "Found BAR on line: " << linein << endl;
                             continue;
                        }                        
                   }
              }               
              else if ( inoption ) {
                   //option processing
                   //contact; relax; others?
                   if ( unhashed.at(0) == "relax" ) {
                        cerr << "RELAX option selected." << endl;
                        given_relax_command = true;
                        continue;
                   }
                   if ( unhashed.at(0) == "overlap" ) {
                        cerr << "OVERLAP option selected." << endl;
                        doOverlaps = true;
                        continue;
                   }
                   if ( unhashed.at(0) == "collective" ) {
                        cerr << "COLLECTIVE option selected." << endl;
                        cerr << "OVERLAP option activated also." << endl;
                        doCollective = true;
                        doOverlaps = true;
                        if ( unhashed.size() > 1 ){
							double p1 = atof( unhashed.at(1).c_str() );
							if ( p1 < 0. || p1 > 1. ){
								cerr << "Inappropriate probability " << p1 << " on COLLECTIVE option, ignoring." << endl;
							}
							else{
								pCollective = p1;
								pLink = p1;
							}
						}
                        if ( unhashed.size() > 2 ){
							double p2 = atof( unhashed.at(2).c_str() );
							if ( p2 < 0. || p2 > 1. ){
								cerr << "Inappropriate link probability " << p2 << " on COLLECTIVE option, ignoring." << endl;
							}
							else{
								pLink = p2;
							}
						} 
                        cerr << "COLLECTIVE MOVE probability " << pCollective;
                        cerr << " and COLLECTIVE LINK probability " << pLink << endl;
                        continue;
                   }
                   //any more options, put here!
                   if ( unhashed.at(0) == "rdf" ) {
                        cerr << "RDF option selected." << endl;
                        doRDF = true;
                        cerr << "Calculating RDF with bin size " << RDFbin << " to range " << RDFmax << endl;
                        continue;
                   }
                   if ( unhashed.at(0) == "nodeloc" ) {
                        cerr << "NODELOC option selected; will not unify sp2 centers." << endl;
                        nodeloc = true;
                        continue;
                   }
                   if ( unhashed.at(0) == "transform" ) {
                        cerr << "TRANSFORM option selected; will prepare MC structure from crystal," << endl;
                        cerr << "   duplicating and splitting reactive atoms" << endl;
                        do_mctransform = true;
                        continue;
                   }
                   if ( unhashed.at(0).substr(0,5) == "gener" ) {
                        cerr << "GENERATE option selected; will generate MC structure," << endl;
                        cerr << "   by creating copies of poly and ligand entities." << endl;
                        do_generate = true;
                        genN.clear();
                        int nps = unhashed.size();
                        for ( int q = 1 ; q < nps ; q++ ){
							char dig = unhashed.at(q).at(0);
							if ( !isdigit ( dig ) ){
								cerr << "Met non-numeric entry instead of number in line " << linein;
								continue; // no more
							}
							double thisN = atoi( unhashed.at(q).c_str() );
							genN.push_back( thisN );
						}
                        continue;
                   }
                   if ( unhashed.at(0) == "mcrun" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        do_mcrun = true;
                        mctrials = atoi ( unhashed.at(1).c_str() );
                        cerr << "Activating MCRUN function." << endl;
                        cerr << "Setting MCTRIALS to " << mctrials << endl;
                   }
                   if ( unhashed.at(0) == "log" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Activating logging with default frequency " << logfreq << endl;
                             dolog = true; //do logging
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Activating logging with default frequency " << logfreq << endl;
                             dolog = true; //do logging    
                        }
                        dolog = true;
                        logfreq = atoi ( unhashed.at(1).c_str() );
                        cerr << "Activating logging with frequency " << logfreq << endl;
                   }
                   if ( unhashed.at(0) == "trois" || unhashed.at(0) == "log3s" ){
                   		//activating tracking of size-3 clusters
                   		if ( !dolog ){
                   			cerr << "Activating logging with default frequency " << logfreq << " because logging 3s." << endl;
                   			dolog = true;
                   		}
                   		if ( !doOverlaps ){
                   			cerr << "Activating doOverlaps option for size-3 cluster tracking." << endl;
                   			doOverlaps = true;
                   		}
                   		track3s = true;
                   }
                   if ( unhashed.at(0) == "mcfreq" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        mcfreq = atoi ( unhashed.at(1).c_str() );
                        cerr << "Setting MCFREQ to " << mcfreq << endl;
                   }
                   if ( unhashed.at(0) == "mct" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        mct = atof ( unhashed.at(1).c_str() );
                        cerr << "Setting MCT to " << mct << endl;
                   }
                   if ( unhashed.at(0) == "mcsmall" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        smallmovesize = atof ( unhashed.at(1).c_str() );
                        use_small_move = true;
                        cerr << "Using small MC moves; setting small move size to " << smallmovesize << endl;
                   }                   
                   if ( unhashed.at(0) == "mcprob" ) {
                        if ( unhashed.size() < 3 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        dig = unhashed.at(2).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }                    
                        bigprob = atof ( unhashed.at(1).c_str() );
                        smallprob = atof ( unhashed.at(2).c_str() );
                        given_mcprobs = true;
                        cerr << "Setting MC big and small move weights to: " << bigprob << " , " << smallprob << endl;
                   }                                    
                   if ( unhashed.at(0) == "grid" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        given_grid = true;
                        gridmin = atof ( unhashed.at(1).c_str() );
                        cerr << "Setting GRID box size to " << gridmin << endl;
                   }                 
                   if ( unhashed.at(0) == "seed" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a number
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        given_seed = true;
                        seed = atoi ( unhashed.at(1).c_str() );
                        cerr << "Setting SEED to " << seed << endl;
                   }
                   if ( unhashed.at(0) == "polypad" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        //given_grid = true;
                        polypad = atof ( unhashed.at(1).c_str() );
                        cerr << "Setting POLYhedron PADding factor to " << gridmin << endl;
                   }
                   if ( unhashed.at(0) == "cheb" ) {
					   //CHEBYSHEV is not used in MCG but if I take it out I will need it tomorrow aargh.
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        //detect auto chebyshev command
                        if ( unhashed.at(1) == "auto" ){
                             cerr << "Detected AUTO CHEByshev option." << endl;
                             chebyshev = true; 
                             use_auto_chebyshev = true;
                             continue; // done, use auto setting
                        }
                        //if we're still here, we want a number for the argument
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        chebyshev = true;
                        cheb = atof ( unhashed.at(1).c_str() );
                        cerr << "Setting CHEByshev acceleration factor to " << cheb << endl;
                   }
                   if ( unhashed.at(0) == "smallmove" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        //given_grid = true;
                        smallmovecriterion = atof ( unhashed.at(1).c_str() );
                        cerr << "Setting SMALLMOVE criterion to " << smallmovecriterion << endl;
                   }
                   if ( unhashed.at(0) == "smallmis" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        //given_grid = true;
                        smallmiscriterion = atof ( unhashed.at(1).c_str() );
                        criterion_mis = true;
                        cerr << "Activating SMALLMISmatch criterion." << endl;
                        cerr << "Setting SMALLMISmatch criterion to " << smallmiscriterion << endl;
                   }
                   if ( unhashed.at(0) == "dampclash" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        //given_grid = true;
                        dampclash = atof ( unhashed.at(1).c_str() );
                        cerr << "Setting SMALLMISmatch criterion to " << dampclash << endl;
                   }
                   if ( unhashed.at(0) == "jiggle" ) {
                        if ( unhashed.size() == 1 ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue;
                        }
                        char dig = unhashed.at(1).at(0); // second item should be a double
                        if ( ! isdigit( dig ) ){
                             cerr << "Skipping line " << linein << " in options block." << endl;
                             continue; // not suitable     
                        }
                        jigsize = atof ( unhashed.at(1).c_str() );
                        do_jiggle = true;
                        cerr << "Setting JIGGLE size to " << jigsize << endl;
                   }
                   if ( unhashed.at(0) == "label" ) {
                        do_label = true;
                        cerr << "LABEL on: will put atom IDs after coords in xtl output." << jigsize << endl;
                   }                   
              }               
              else if ( inoutput ) {
                   //output processing
                   if ( unhashed.size() < 2 ){
                        cerr << "Skipping line " << linein << " in output block." << endl;
                        continue; // all entries must be two tokens!
                   }
                   if ( unhashed.at(0) == "structure" ) {
                        do_output_structure = true;
                        output_structure_name = unhashed_toktok.at(1);
                        cerr << "Will write output structure to " << output_structure_name << endl;
                        continue; // read next line
                   }
                   if ( unhashed.at(0) == "overlap" ) {
                        overlapname = unhashed_toktok.at(1);
                        cerr << "Overlap base name: " << overlapname << endl;
                        continue; // read next line
                   }                   
                   if ( unhashed.at(0) == "mcname" ) {
                        mcname = unhashed_toktok.at(1);
                        cerr << "Setting MCNAME to " << mcname << endl;
                        givenmcname = true;
                        continue; // read next line
                   }
                   if ( unhashed.at(0) == "rdfname" ) {
                        rdfbasename = unhashed.at(1);
                        cerr << "Setting RDFNAME to " << rdfbasename << endl;
                        givenrdfbasename = true; //
                        continue; // read next line
                   }
                   if ( unhashed.at(0) == "logname" ) {
                        logname = unhashed_toktok.at(1);
                        cerr << "Setting LOGNAME to " << logname << endl;
                        continue; // read next line
                   }
                   if ( unhashed.at(0) == "bonding" ) {
                        do_output_bonding = true;
                        output_bonding_name = unhashed_toktok.at(1);
                        cerr << "Will write output bonding to " << output_bonding_name << endl;
                        continue;
                   }                   
                   if ( unhashed.at(0).substr(0,3) == "pol" ) {
                        do_output_poly = true;
                        output_poly_name = unhashed_toktok.at(1);
                        cerr << "Will write output polyhedra to " << output_poly_name << endl;
                        continue;
                   }
                   if ( unhashed.at(0).substr(0,5) == "clust" ) {
                        do_output_clusters = true;
                        output_clusters_name = unhashed_toktok.at(1);
                        cerr << "Will write output clusters to " << output_clusters_name << endl;
                        continue;
                   }                            
                   if ( unhashed.at(0) == "bonds" || unhashed.at(0) == "bondlengths" ) {
                        do_output_bonds = true;
                        output_bonds_name = unhashed_toktok.at(1);
                        cerr << "Will write bond lengths to " << output_bonds_name << endl;
                        continue;
                   } 
                   if ( unhashed.at(0) == "angles" ) {
                        do_output_angles = true;
                        output_angles_name = unhashed_toktok.at(1);
                        cerr << "Will write bond lengths to " << output_angles_name << endl;
                        continue;
                   } 
                   if ( unhashed.at(0) == "mismatch" || unhashed.at(0) == "clash" ) {
                        do_output_mismatches = true;
                        output_mismatches_name = unhashed_toktok.at(1);
                        cerr << "Will write MISMATCH and CLASH info to " << output_mismatches_name << endl;
                        continue;
                   }
              }
              else if ( inligand ) {
                   //read lines into the current ligand entry
                   if ( unhashed.size() < 4 ){
					 cerr << "Skipping undersized line " << linein << " in ligand block" << endl;
					 continue; // next line
				   }
                   else {
					    for ( int q = 1; q < 4; q++){
							char dig = unhashed.at(q).at(0); // three items should be coords
							if ( ! isdigit( dig ) ){
								cerr << "Skipping malformed line " << linein << " in ligand block." << endl;
								continue; // not suitable    
							}
						}
                        string ele = unhashed.at(0); // element name
                        double coox, cooy, cooz; // reading coords
                        coox = atof ( unhashed.at(1).c_str() );                                               
                        cooy = atof ( unhashed.at(2).c_str() );
                        cooz = atof ( unhashed.at(3).c_str() );
                        Vector pos = Vector( coox, cooy, cooz );
                        ligand.at(trackligand).species.push_back( ele );
                        ligand.at(trackligand).pos.push_back( pos );
                        //now we've pushed a line into a ligand
                   }
              }           
           }
           else {
                // not in a block
                //check for block starting tag, ignore everything else
                string wordone = unhashed.at(0);
                if ( wordone == "title" ) {
                     isinblock = true;
                     intitle = true;
                     cerr << "Found TITLE block." << endl;
                     given_title = true;
                     continue;     
                }
                if ( wordone == "element" ) {
                     isinblock = true;
                     inelement = true;
                     cerr << "Found ELEMENT block." << endl;
                     given_elements = true;
                     continue;     
                }               
                if ( wordone == "input" ) {
                     isinblock = true;
                     ininput = true;
                     cerr << "Found INPUT block." << endl;
                     given_input = true;
                     continue;     
                } 
                if ( wordone == "bond" ) {
                     isinblock = true;
                     inbond = true;
                     cerr << "Found BOND block." << endl;
                     given_bond = true;
                     bondwithin = defaultbondwithin; // in case it was set differently somewhere else!
                     //introduce WITHIN check here!
                     if ( unhashed.size() > 2 ) {
                          if ( unhashed.at(1) == "within" ) {
                               char dig = unhashed.at(2).at(0); // first char of third word
                               if ( isdigit( dig ) ){
                                    bondwithin = atof( unhashed.at(2).c_str() );
                                    cerr << "This block: bondwithin set to " << bondwithin << endl;
                               }
                          }
                     }
                     continue;     
                } 
                if ( wordone == "poly" ) {
                     isinblock = true;
                     inpoly = true;
                     cerr << "Found POLY block." << endl;
                     given_poly = true;
                     continue;     
                }
                if ( wordone == "option" ) {
                     isinblock = true;
                     inoption = true;
                     cerr << "Found OPTION block." << endl;
                     given_option = true;
                     continue;     
                }
                if ( wordone == "output" ) {
                     isinblock = true;
                     inoutput = true;
                     cerr << "Found OUTPUT block." << endl;
                     given_output = true;
                     continue;     
                }
                if ( wordone == "ligand" ) {
                     isinblock = true;
                     inligand = true;
                     cerr << "Found LIGAND block." << endl;
                     given_ligand = true;
                     Ligand lig;
                     ligand.push_back( lig ); // put an empty ligand into the array
                     trackligand = ligand.size() -1; // which ligand are we going to fill?
                     continue;
                }
           }
     
     
     } // done with WHILE on inputfile
  
  inputfile.close();
  return true;   
}

void mctransform( Structure &inputstructure ){
	//only call this if we want to split reactives out from others!
	  //let's duplicate reactive atoms if called upon
	  //duplicate atoms if they have metal neighbours?
	  //and unify non-polys into single rigid objects
	  //is the and really an and?? find out...
	  cerr << "Hello, I'm the MC TRANSFORM function." << endl;
	  cerr << "Finding the reactive atoms" << endl;
	  vector< int > nm, nc; // will count number of metal and other neighbours
	  nm.resize( inputstructure.atom.size() );
	  nc.resize( inputstructure.atom.size() );
	  	  
	  int initialnumberofatoms = 0;
	  initialnumberofatoms = inputstructure.atom.size(); // because we're extending the array during the loop!
	  
	  for ( int i = 0; i < initialnumberofatoms; i++ ){
		  nm.at(i) = 0; nc.at(i) = 0; // null at start
		  int r = inputstructure.atom.at(i).role;
		  if ( r != 1 ) continue; // not reactive
		  cerr << "Atom " << i+1 << " is reactive." << endl;
		  
		  int ntot = inputstructure.atom.at(i).bondto.size();
		  for ( int j = 0; j < ntot; j++){
			  int which = inputstructure.atom.at(i).bondto.at(j); // considering this bond
			  int whichr = inputstructure.atom.at(which).role;
			  if ( whichr == -1 ){
				  nm.at(i)++;
			  }
			  else{
				  nc.at(i)++;
			  }
		  }
		  cerr << "Has " << ntot << " neighbours of which " << nm.at(i) << " metal and " << nc.at(i) << " other." << endl;

		  int status = 0; // use this to track cases
		  if ( ntot == 0 ){
			  status = -1;  //probably a problem!
		  }
		  else if ( ntot == 1 ){
			  status = 1; // simplest case, no need for any action
		  }
		  else if ( nm.at(i) == 0 ){
			  status = 2; // has no M neighbours, no need for action
		  }
		  else if ( nc.at(i) == 0 ){
			  status = 3; // has no non-M neighbours and two or more M neighbours
		  }
		  else{
			  status = 4; // has both M and other neighbours
		  }
		  
		  if ( status == -1){
			  cerr << "WARNING: Reactive atom " << i+1 << "has no neighbours at all. Really?" << endl;
		  }
		  if ( status == 0){
			  cerr << "WARNING: unhandled case. Really?" << endl;
		  }
		  if ( status == 1){
			  cerr << "Case 1, only one neighbour. No action taken." << endl;
		  }
		  if ( status ==2 ){
			  cerr << "Case 2, not bonded to metal. No action taken." << endl;
		  }
		  if ( status == 3){
			  cerr << "Case 3, shared between " << nm.at(i) << " metal neighbours." << endl;
			  cerr << "Action: make " << nm.at(i) - 1 << " duplicates, so each poly gets one." << endl;
			  //loop over neighbours two up;
			  //remove i from neighbour's bondto
			  //remove neighbour from i's bondo
			  //create a duplicate atom at top of array which is a copy of i
			  //duplicate is bonded only to neighbour
			  //and neighbour is bonded to duplicate
			  vector< int > neighs =  inputstructure.atom.at(i).bondto; // so we can change it later
			  for ( int q = 1; q < ntot; q++){
				  //cerr << "Making a duplicate of " << i+1 << endl;
				  int topper = inputstructure.atom.size(); // this will be the new entry position
				  cerr << "Making a duplicate of " << i+1 << " at duplicate position: " << topper +1 << endl;
				  Atom newtop = inputstructure.atom.at(i); // duplicate;
				  newtop.bondto.clear(); // erase
				  int neigh = neighs.at(q); // this is an mcluster centre
				  inputstructure.atom.at(i).bondto.at(q) = -1; // mark to erase it later
				  for ( int qq = 0; qq < inputstructure.atom.at(neigh).bondto.size(); qq++){
					  int lookback = inputstructure.atom.at(neigh).bondto.at(qq);
					  if ( lookback == i ){
						  cerr << "Found in bondto list of neighbour " << neigh << " ; replacing." << endl;
						  inputstructure.atom.at(neigh).bondto.at(qq) = topper; //duplicate instead of original
						  break; // out of loop now
					  }
				  }
				  newtop.bondto.push_back( neigh ); // duplicate bonded only to neigh
				  inputstructure.atom.push_back( newtop ); // duplicate joins the party
			  }
			  //now erase the bad entries from i's bondto
			  for ( int q = inputstructure.atom.at(i).bondto.size() -1 ; q > -1 ; q-- ){
				  //cerr << "Checking original bondto entry " << q << " which is " << inputstructure.atom.at(i).bondto.at(q) << endl;
				  if ( inputstructure.atom.at(i).bondto.at(q) == -1 ){
					  //cerr << "Erasing entry from original bondto list" << endl;
					  inputstructure.atom.at(i).bondto.erase( inputstructure.atom.at(i).bondto.begin()+q ); // wiped
				  }
			  }
			  //special case test
			  if ( inputstructure.atom.at(i).bondto.size() > 1 ){
				  cerr << "WARNING: For some reason the original still has more than one connection?" << endl;
			  }
		  }
		  if ( status == 4 ){
			  cerr << "Case 4, shared between " << nm.at(i) << " metal neighbours and " << nc.at(i) << " other neighbours." << endl;
			  cerr << "Action: make " << nm.at(i) << " duplicates and give one to each metal." << endl;
			  cerr << "  Original atom remains with non-metal neighbours." << endl;

			  //loop over neighbours detecting specifically the metal ones
			  //remove i from neighbour's bondto
			  //remove neighbour from i's bondo
			  //create a duplicate atom at top of array which is a copy of i
			  //duplicate is bonded only to neighbour
			  //and neighbour is bonded to duplicate
			  vector< int > neighs =  inputstructure.atom.at(i).bondto; // so we can change it later
			  for ( int q = 0; q < ntot; q++){
				  int which = inputstructure.atom.at(i).bondto.at(q);
				  int whichr = inputstructure.atom.at( which ).role;
				  if ( whichr != -1 ) continue; // pass if it's not a metal centre
				  cerr << "Making a duplicate of " << i+1 << endl;
				  int topper = inputstructure.atom.size(); // this will be the new entry position
				  cerr << "Making a duplicate of " << i+1 << " at duplicate position: " << topper +1 << endl;
				  Atom newtop = inputstructure.atom.at(i); // duplicate;
				  newtop.bondto.clear(); // erase
				  int neigh = neighs.at(q); // this is an mcluster centre
				  inputstructure.atom.at(i).bondto.at(q) = -1; // mark to erase it later
				  for ( int qq = 0; qq < inputstructure.atom.at(neigh).bondto.size(); qq++){
					  int lookback = inputstructure.atom.at(neigh).bondto.at(qq);
					  if ( lookback == i ){
						  //cerr << "Found in bondto list of neighbour " << neigh << " ; replacing." << endl;
						  inputstructure.atom.at(neigh).bondto.at(qq) = topper; //duplicate instead of original
						  break; // out of loop now
					  }
				  }
				  newtop.bondto.push_back( neigh ); // duplicate bonded only to neigh
				  inputstructure.atom.push_back( newtop ); // duplicate joins the party
			  }
			  //now erase the bad entries from i's bondto
			  for ( int q = inputstructure.atom.at(i).bondto.size() -1 ; q > -1 ; q-- ){
				  //cerr << "Checking original bondto entry " << q << " which is " << inputstructure.atom.at(i).bondto.at(q) << endl;
				  if ( inputstructure.atom.at(i).bondto.at(q) == -1 ){
					  //cerr << "Erasing entry from original bondto list" << endl;
					  inputstructure.atom.at(i).bondto.erase( inputstructure.atom.at(i).bondto.begin()+q ); // wiped
				  }
			  }			  
			  
			  
		  }
		  
		  
	  }
	  
	  int newn = inputstructure.atom.size();
	  if ( newn > initialnumberofatoms ){
		  cerr << "Atom array expanded from " << initialnumberofatoms << " to " << newn << endl;
	  }
	  bool reinit = inputstructure.initialise( gridmin); // get the new atoms sorted
	return;
}

void mcbigrandom( Cluster &acluster, vector< Atom > &tryatom, Structure &inputstructure){
			  acluster.randomorient(); // wheee!
			  Vector apos = wrapfracpos( cubic_vector() ); // somewhere in the box
			  acluster.cpos = inputstructure.cell.fractocart( apos ); // Cartesian position
			  //keep consistent
			  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
				  Vector atpos = acluster.cpos + acluster.bond.at( thisat ); // cartposition
				  tryatom.at( thisat ).pos = inputstructure.cell.wrapcartpos( atpos ); // in cell!
				  tryatom.at( thisat ).initial_pos = tryatom.at( thisat ).pos;
				  tryatom.at( thisat ).fracpos = inputstructure.cell.carttofrac( tryatom.at( thisat ).pos );
				  //cerr << "Placed trial atom " << tryatom.at( thisat ).species << " at " << tryatom.at( thisat ).fracpos << endl;
				  //now do some grid stuff
				  tryatom.at( thisat ).gridx = inputstructure.cell.fracNx( tryatom.at( thisat ).fracpos.x );
				  tryatom.at( thisat ).gridy = inputstructure.cell.fracNy( tryatom.at( thisat ).fracpos.y );
				  tryatom.at( thisat ).gridz = inputstructure.cell.fracNz( tryatom.at( thisat ).fracpos.z );
			  }
}

void mcsmallrandom( Cluster &acluster, vector< Atom > &tryatom, Structure &inputstructure, double step){
	//generate two random vectors of size 0 to step
	//these are the displacement and the rotation
	Vector vmove, vrot;
	vmove = unit_vector();
	vrot = unit_vector();
	double scale = getRandom()*step;
	vmove *= scale;
	scale = getRandom()*step;
	vrot *= scale;
	//also scale the rotation by the cluster size in order to prevent big swing effects
	vrot /= sqrt( tryatom.size() );
	
	//apply them to the cluster: first move
	Vector sumvec = vmove + acluster.cpos;
	acluster.cpos = inputstructure.cell.wrapcartpos( sumvec );
	
	//now the turn
	rotate( acluster, vrot );
	
	//and fill back into tryatom array
	for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
		Vector atpos = acluster.cpos + acluster.bond.at( thisat ); // cartposition
		tryatom.at( thisat ).pos = inputstructure.cell.wrapcartpos( atpos ); // in cell!
		tryatom.at( thisat ).initial_pos = tryatom.at( thisat ).pos;
		tryatom.at( thisat ).fracpos = inputstructure.cell.carttofrac( tryatom.at( thisat ).pos );
		//cerr << "Placed trial atom " << tryatom.at( thisat ).species << " at " << tryatom.at( thisat ).fracpos << endl;
		//now do some grid stuff
		tryatom.at( thisat ).gridx = inputstructure.cell.fracNx( tryatom.at( thisat ).fracpos.x );
		tryatom.at( thisat ).gridy = inputstructure.cell.fracNy( tryatom.at( thisat ).fracpos.y );
		tryatom.at( thisat ).gridz = inputstructure.cell.fracNz( tryatom.at( thisat ).fracpos.z );
	}
}



void mcgenerate( Structure &inputstructure ){
	  cerr << "Hi, I'm the GENERATE function." << endl;
	  cerr << "I am aware of " << polyspec.size() << " polyhedral types and ";
	  cerr << ligand.size() << " ligand types." << endl;
	  int totthings = polyspec.size() + ligand.size();
	  cerr << "I am aware of " << genN.size() << " numbers to make." << endl;
	  //do not sanity check because validation() already did that.
	  //if we have any polys let's make some MCpoly entities
	  if ( polyspec.size() > 0 ){
		  MCpoly.resize( polyspec.size() ); // one MCpoly Poly per polyspec
	  }
	  for ( int p = 0 ; p < polyspec.size(); p++ ){
		  //let's make an MCpoly with the polyspec geometry
		  MCpoly.at(p).c_species = polyspec.at(p).c_species;
		  MCpoly.at(p).v_species = polyspec.at(p).v_species;		  
		  MCpoly.at(p).shape = polyspec.at(p).shape;
		  MCpoly.at(p).bondlength = polyspec.at(p).bondlength;
		  MCpoly.at(p).cpos = nullvec;
		  MCpoly.at(p).type = p; // this type of spec
		  MCpoly.at(p).bond.clear();
		  //now do perfect geometry building and dummy members
		  buildghost( MCpoly.at(p) );
	  }
	  
	  //so now I have MCpoly objects and ligand objects;
	  //also I should have been given a new cell
	  //with which to build inputstructure...
	  
	  //first build the cell
	  cerr << "Introducing new cell parameters to structure." << endl;
	  inputstructure.newcell( newcellparam );
	  cerr << "Initialising cell and grid." << endl;
	  double gridval = inputstructure.maxrad();
	  if ( gridmin > gridval ) gridval = gridmin; // use larger of structure min and given value
	  inputstructure.initialise( gridval ); // the grid will be empty but OK
	  
	  //then for each poly object
	  //build a new copy with random location and orientation XX
	  //create a dummy atom list with the positions in the cell XX
	  //get sample grid locations
	  //search the grid for any actual collision
	  //reject if MCcollide says no. Computer says no.
	  bool insertionfailed = false;
	  for ( int tomake = 0 ; tomake < polyspec.size(); tomake++ ){
		  if ( insertionfailed ) break;
		  int howmany = genN.at(tomake);
		  cerr << "Making " << howmany << " copies of poly spec " << tomake+1 << endl;
		  int whatsize = MCpoly.at(tomake).bond.size(); // this many atoms each go
		  bool stillworking = true;
		  int ndone = 0;
		  int nfail = 0;
		  int maxfail = 1000;
		  int ntry = 0;
		  while ( stillworking ){
			  ntry++;
			  cerr << "Attempt " << ntry << endl;
			  //make some atoms out of the polyspec
			  vector< Atom > tryatom;
			  tryatom.resize( whatsize );
			  Poly apoly = MCpoly.at( tomake );
			  Cluster acluster = clusterfrompoly( apoly ); // info in here for use
			  //okay, atom species assign
			  tryatom.at( 0 ).species = apoly.c_species;
			  tryatom.at( 0 ).inclust.push_back( 0 );
			  tryatom.at( 0 ).isvertex.push_back( 0 ); // 0th vertex in this object
			  for ( int thisat = 1 ; thisat < tryatom.size(); thisat++){
				  tryatom.at(thisat).species = apoly.v_species;
				  tryatom.at(0).bondto.push_back( thisat );
				  tryatom.at( thisat).bondto.push_back( 0 ); // the bonding in the poly
				  tryatom.at( thisat ).inclust.push_back( 0 );
				  tryatom.at( thisat ).isvertex.push_back( thisat ); //nth vertex in this object
				  tryatom.at( thisat ).hybrid = 1; // set so each cluster is rigid
			  }
			  //do element check and reactive check
			  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
				  bool anygood = inputstructure.elecheck( tryatom.at(thisat) )  ;// should put element properties in place
				  if (!anygood){
					  cerr << "I have died of bad elements." << endl;
					  exit( 1 ); // aaaargh // this will always be fatal so no point in retrying
				  }
				  //new labelling concept:
				  //label reactive 2 if atom is reactive 1 and all neighbours are metal -1
				  //specifically for poly:
				  //vertices with role 1 become role 2 if centre has role -1;
				  if ( ( thisat > 0 ) && ( tryatom.at( thisat ).role == 1 ) ){
					  if ( tryatom.at(0).role == -1 ){
						  tryatom.at( thisat ).role = 2; // labels reactive vertex
						  cerr << "Reactive vertex labelled." << endl;
					  }	
				  }
			  }			  
			  // I'm going to place the Cluster at a random place and in a random orientation
			  mcbigrandom( acluster, tryatom, inputstructure );
			  
			  //now try to insert the atoms, stopping if we hit a bad clash
			  bool badclash = false;
			  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
				  if ( badclash ) break; // one clash is enough;
				  badclash = mcinsertclash( tryatom.at( thisat ), inputstructure );
			  }			  
			  if ( badclash ){
				  //rejecting this attempt
				  nfail++;
				  cerr << "Failed insertion attempt " << ntry << " (failure " << nfail << ")." << endl;
				  if (  nfail > maxfail ){
					  insertionfailed = true;
					  stillworking = false; 
				  }
			  }
			  else{
				  //accepting this attempt
				  ndone++;
				  cerr << "Successful insertion attempt " << ndone << " of " << howmany << endl;
				  if ( ndone == howmany) stillworking = false; // done with this kind of poly
				  //increment bondto registers in tryatom by atom.size() for consistent numbering
				  //increment cluster membership inclust by cluster.size()
				  int atomplus = inputstructure.atom.size();
				  int clustplus = inputstructure.cluster.size();
				  cerr << "Inserting atoms " << atomplus+1 << " to " << atomplus+tryatom.size()+1 << endl;
				  cerr << "   as cluster " << clustplus +1 << endl;
				  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					  tryatom.at( thisat ).inclust.at(0) += clustplus; // by construction, only one entry!
					  for ( int qb = 0; qb < tryatom.at( thisat ).bondto.size() ; qb++ ){
						  tryatom.at( thisat ).bondto.at( qb ) += atomplus;
					  }
					  for ( int qb = 0; qb < acluster.members.size() ; qb++ ){
						  acluster.members.at( qb ) += atomplus; // cluster member list also consistent!
					  }
				  }
				  // need to put atoms into atom array
				  //cluster into cluster array
				  //poly into poly array
				  //atoms into grid
				  putclusterinpoly( acluster, apoly ); // feed back correct info
				  inputstructure.cluster.push_back(  acluster );
				  inputstructure.poly.push_back ( apoly );
				  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					  inputstructure.atom.push_back ( tryatom.at( thisat ) );
					  int gcell = inputstructure.cell.Ngrid( tryatom.at( thisat ).gridx, tryatom.at( thisat).gridy, tryatom.at( thisat ).gridz  );
					  inputstructure.cell.grid.at( gcell ).push_back ( thisat + atomplus ); // atom listed in cell now
				  }
				  // acceptance complete!
				  cerr << "Structure now contains " << inputstructure.atom.size() << " atoms and " << inputstructure.cluster.size() << " polyhedral clusters." << endl;
			  }
			    
		  } // end of while (stillworking ) loop
		  if ( insertionfailed ){
			  cerr << "Death due to failed insertion attempts" << endl;
			  exit( 1 );
		  }
		  
	  } // end of poly insertion attempt loop
	  
	  //then likewise for each ligand object
/*
		Ligand entity contains:
         vector< string > species; // list of elements
         vector< Vector > pos; // atom positions
		 vector< Element > element; // my elements live here
		 vector< Atom > atom; // my atoms live in here
		 Cluster clust; // just one cluster per ligand in current version!
*/	  
	  //so the tryatom array is the ligand atom array
	  //and remember that ligbondfind has set bonding already
	  insertionfailed = false;
	  for ( int tomake = 0 ; tomake < ligand.size(); tomake++ ){
		  int whichmake = tomake + polyspec.size(); // because we already made the polys
		  if ( insertionfailed ) break;
		  int howmany = genN.at(whichmake);
		  cerr << "Making " << howmany << " copies of ligand spec " << tomake+1 << endl;
		  int whatsize = ligand.at(tomake).atom.size(); // this many atoms each go
		  bool stillworking = true;
		  int ndone = 0;
		  int nfail = 0;
		  int maxfail = 1000;
		  int ntry = 0;
		  while ( stillworking ){ 
			  ntry++;
			  cerr << "Attempt " << ntry << endl;
			  //make some atoms out of the LIGAND spec
			  vector< Atom > tryatom;
			  tryatom = ligand.at( tomake ).atom; 
			  Cluster acluster = ligand.at( tomake ).clust; // info in here for use
			  
			  //at this point in the new logic I should check reactivity and metal status
			  for ( int nat = 0 ; nat < tryatom.size() ; nat++ ){
				  int natrole = tryatom.at( nat ).role;
				  if ( natrole != 1 ) continue; //not interesting case
				  
				  int nn = tryatom.at( nat ).bondto.size(); //how many neighbours
				  bool setto2 = true;
				  for ( int jj = 0 ; jj < nn ; jj++ ){
					  int kk = tryatom.at( nat ).bondto.at( jj );
					  int kkrole = tryatom.at( kk ).role;
					  if ( kkrole != -1 ){
						  setto2 = false;
						  break; // leave this loop
					  }
				  }
				  if ( setto2 ){
					  tryatom.at( nat ).role = 2;
					  cerr << "Labelled REACTIVE VIRTUAL atom." << endl;
				  }
				  
			  }
			  //completed new reactivity check on generate
			    
			  // I'm going to place the Cluster at a random place and in a random orientation
			  mcbigrandom( acluster, tryatom, inputstructure );
			  //now try to insert the atoms, stopping if we hit a bad clash
			  bool badclash = false;
			  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
				  if ( badclash ) break; // one clash is enough;
				  badclash = mcinsertclash( tryatom.at( thisat ), inputstructure );
			  }			  
			  if ( badclash ){
				  //rejecting this attempt
				  nfail++;
				  cerr << "Failed insertion attempt " << ntry << " (failure " << nfail << ")." << endl;
				  if (  nfail > maxfail ){
					  insertionfailed = true;
					  stillworking = false; 
				  }
			  }
			  else{
				  //accepting this attempt
				  ndone++;
				  cerr << "Successful insertion attempt " << ndone << " of " << howmany << endl;
				  if ( ndone == howmany) stillworking = false; // done with this kind of poly
				  //increment bondto registers in tryatom by atom.size() for consistent numbering
				  //increment cluster membership inclust by cluster.size()
				  int atomplus = inputstructure.atom.size();
				  int clustplus = inputstructure.cluster.size();
				  cerr << "Inserting atoms " << atomplus+1 << " to " << atomplus+tryatom.size()+1 << endl;
				  cerr << "   as cluster " << clustplus +1 << endl;
				  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					  tryatom.at( thisat ).inclust.at(0) += clustplus; // by construction, only one entry!
					  for ( int qb = 0; qb < tryatom.at( thisat ).bondto.size() ; qb++ ){
						  tryatom.at( thisat ).bondto.at( qb ) += atomplus;
					  }
					  for ( int qb = 0; qb < acluster.members.size() ; qb++ ){
						  acluster.members.at( qb ) += atomplus; // cluster member list also consistent!
					  }
				  }
				  // need to put atoms into atom array
				  //cluster into cluster array
				  //atoms into grid
				  inputstructure.cluster.push_back(  acluster );
				  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					  inputstructure.atom.push_back ( tryatom.at( thisat ) );
					  int gcell = inputstructure.cell.Ngrid( tryatom.at( thisat ).gridx, tryatom.at( thisat).gridy, tryatom.at( thisat ).gridz  );
					  inputstructure.cell.grid.at( gcell ).push_back ( thisat + atomplus ); // atom listed in cell now
				  }
				  // acceptance complete!
				  cerr << "Structure now contains " << inputstructure.atom.size() << " atoms and " << inputstructure.cluster.size() << " clusters." << endl;
			  }
			    
		  } // end of while (stillworking ) loop
		  if ( insertionfailed ){
			  cerr << "Death due to failed insertion attempts" << endl;
			  exit( 1 );
		  }
		  
	  } // end of ligand insertion attempt loop
	  
	  inputstructure.formbondlines( bondline ); // bondlines to output, also handles rigidity
}

//
//MCinsertclash looks at the given atom versus those in the structure's grid
//returning false if there are NO clashes and TRUE if there is an intolerable clash
//
bool mcinsertclash( Atom &atom, Structure &structure ){
	int ax, ay, az, ox, oy, oz, tg, og; //*g is the grid cell label
	bool result= false;
	if ( atom.role == 2 ) return false; // a virtual site clashes not
	//borrow logic from GASP clash finder but simpler
	ax = atom.gridx;
	ay = atom.gridy;
	az = atom.gridz;

       Vector diff; // initial difference before wrapping
       Vector deltaf, delta; // Cartesian difference
       double d2; // distance-squared
       double dbad, dbad2;
       //set searchpar based on maxradius
       int searchpar = ceil( 2.*maxradius / structure.cell.mygridmin );

/*       
       for ( int dx = -1 ; dx < 2 ; dx++ ){
		   if ( result ) break; // stop if there's any bad clash!
           ox = (ax + dx );
           if ( ox == -1 ) ox += structure.cell.Nx; // mind negative!
           if ( ox == structure.cell.Nx ) ox = 0 ; // top of cell
           for ( int dy = -1; dy < 2 ; dy++ ){
			   if ( result ) break; // stop if there's any bad clash!
               oy = ( ay + dy ) % structure.cell.Ny ;
               if ( oy == -1 ) oy += structure.cell.Ny; // mind negative!
               if ( oy == structure.cell.Ny ) oy = 0 ; // top of cell               
               for ( int dz = -1 ; dz < 2 ; dz++ ){
				   if ( result ) break; // stop if there's any bad clash!
                   oz = ( az + dz ) % structure.cell.Nz;
                   if ( oz == -1 ) oz += structure.cell.Nz; // mind negative!
                   if ( oz == structure.cell.Nz ) oz = 0 ; // top of cell                   
*/
       for ( int dx = ax - searchpar; dx < ax + searchpar + 1 ; dx++ ){
		   for ( int dy = ay - searchpar; dy < ay + searchpar + 1 ; dy++ ){
			   for ( int dz = az - searchpar; dz < az + searchpar + 1 ; dz++ ){
				   
				   ox = dx ;
				   oy = dy ;
				   oz = dz ;
				   //wrap into grid
				   if ( ox < 0 ) ox += structure.cell.Nx; // mind negative!
				   if ( ox > structure.cell.Nx - 1 ) ox -= structure.cell.Nx ; // top of cell
				   if ( oy < 0 ) oy += structure.cell.Ny; // mind negative!
				   if ( oy > structure.cell.Ny - 1 ) oy -= structure.cell.Ny ; // top of cell
				   if ( oz < 0 ) oz += structure.cell.Nz; // mind negative!
				   if ( oz > structure.cell.Nz - 1 ) oz -= structure.cell.Nz ; // top of cell

                   og = oz + ( oy * structure.cell.Nz ) + ( ox * structure.cell.Ny * structure.cell.Nz );
                   //cerr << "Looking in grid " << og << " of " << grid.size() << endl;
                   // look in og for possible neighbours
                   for ( int j = 0; j < structure.cell.grid.at(og).size(); j++){
					   if ( result ) break; // stop if there's any bad clash!
                       int you = structure.cell.grid.at(og).at(j); // other atom!
                       if ( structure.atom.at(you).role == 2 ) continue; // virtual atom clashes not
                       dbad = atom.radius + structure.atom.at(you).radius - mcvdwtol; // allowing a little tolerance
                       dbad2 = dbad*dbad;

                       diff = atom.fracpos - structure.atom.at(you).fracpos;
                       deltaf = wrapfracdel ( diff ) ; // shortest vector, not across cell
                       delta = structure.cell.fractocart( deltaf) ; // Cartesians now
                       
                       d2 = delta.dot( delta ); // distance-squared!
                       if ( d2 < dbad2 ){

							   cerr << "Rejecting clash with atom " << you+1 << " of current structure." << endl;
							   result = true; // bad clash!

                       }
                   }
                  
               }
           }
       }
	return result;
}


//
//MCinsertclash looks at the given atom versus those in the structure's grid
//returning false if there are NO clashes and TRUE if there is an intolerable clash
//this overloaded version takes an array of ids to not check
//so it's usable when moving atoms
//
bool mcinsertclash( Atom &atom, Structure &structure, vector< int > ignore ){
	int ax, ay, az, ox, oy, oz, tg, og; //*g is the grid cell label
	bool result= false;
	if ( atom.role == 2 ) return false; // a virtual site clashes not
	//borrow logic from GASP clash finder but simpler
	ax = atom.gridx;
	ay = atom.gridy;
	az = atom.gridz;

       Vector diff; // initial difference before wrapping
       Vector deltaf, delta; // Cartesian difference
       double d2; // distance-squared
       double dbad, dbad2;
       int searchpar = ceil( 2.*maxradius / structure.cell.mygridmin );

/*       
       for ( int dx = -1 ; dx < 2 ; dx++ ){
		   if ( result ) break; // stop if there's any bad clash!
           ox = (ax + dx );
           if ( ox == -1 ) ox += structure.cell.Nx; // mind negative!
           if ( ox == structure.cell.Nx ) ox = 0 ; // top of cell
           for ( int dy = -1; dy < 2 ; dy++ ){
			   if ( result ) break; // stop if there's any bad clash!
               oy = ( ay + dy ) % structure.cell.Ny ;
               if ( oy == -1 ) oy += structure.cell.Ny; // mind negative!
               if ( oy == structure.cell.Ny ) oy = 0 ; // top of cell               
               for ( int dz = -1 ; dz < 2 ; dz++ ){
				   if ( result ) break; // stop if there's any bad clash!
                   oz = ( az + dz ) % structure.cell.Nz;
                   if ( oz == -1 ) oz += structure.cell.Nz; // mind negative!
                   if ( oz == structure.cell.Nz ) oz = 0 ; // top of cell                   
*/
       for ( int dx = ax - searchpar; dx < ax + searchpar + 1 ; dx++ ){
		   for ( int dy = ay - searchpar; dy < ay + searchpar + 1 ; dy++ ){
			   for ( int dz = az - searchpar; dz < az + searchpar + 1 ; dz++ ){
				   
				   ox = dx ;
				   oy = dy ;
				   oz = dz ;
				   //wrap into grid
				   if ( ox < 0 ) ox += structure.cell.Nx; // mind negative!
				   if ( ox > structure.cell.Nx - 1 ) ox -= structure.cell.Nx ; // top of cell
				   if ( oy < 0 ) oy += structure.cell.Ny; // mind negative!
				   if ( oy > structure.cell.Ny - 1 ) oy -= structure.cell.Ny ; // top of cell
				   if ( oz < 0 ) oz += structure.cell.Nz; // mind negative!
				   if ( oz > structure.cell.Nz - 1 ) oz -= structure.cell.Nz ; // top of cell

                   og = oz + ( oy * structure.cell.Nz ) + ( ox * structure.cell.Ny * structure.cell.Nz );
                   //cerr << "Looking in grid " << og << " of " << grid.size() << endl;
                   // look in og for possible neighbours
                   for ( int j = 0; j < structure.cell.grid.at(og).size(); j++){
					   if ( result ) break; // stop if there's any bad clash!
                       int you = structure.cell.grid.at(og).at(j); // other atom!
                       if ( structure.atom.at(you).role == 2 ) continue; // virtual atom clashes not
                       if ( isin( you, ignore ) ) continue; // do not test ignored atoms
                       dbad = atom.radius + structure.atom.at(you).radius - mcvdwtol; // allowing a little tolerance
                       dbad2 = dbad*dbad;

                       diff = atom.fracpos - structure.atom.at(you).fracpos;
                       deltaf = wrapfracdel ( diff ) ; // shortest vector, not across cell
                       delta = structure.cell.fractocart( deltaf) ; // Cartesians now
                       
                       d2 = delta.sq(); // distance-squared!
                       if ( d2 < dbad2 ){
						   
							   cerr << "Rejecting clash with atom " << you+1 << "." << endl;
							   result = true; // bad clash!

                       }
                   }
                  
               }
           }
       }
	return result;
}

//width should default to 8 from header definition
string mcfilename( int n, int width ){
	stringstream foo;
	foo << mcname; // common rider
	foo << setw( width ) << setfill('0') << n << ".cif"; //zero-padded entry number
	return foo.str();
}

//mc energy calculation loop
double mcenergy( Structure &structure ){
	double result = 0.;
	int searchpar = ceil( maxr / structure.cell.mygridmin  ); // grid search range
	//cerr << " ECHECK ";
	
	for ( int i = 0 ; i < structure.atom.size(); i++ ){
		if ( !inapot.at( i ) ) continue; // irrelevant atom
		
		int ax = structure.atom.at(i).gridx;
		int ay = structure.atom.at(i).gridy;
		int az = structure.atom.at(i).gridz;
		
		int topx = structure.cell.Nx - 1; // top index of X cell
		int topy = structure.cell.Ny - 1; // top index of Y cell
		int topz = structure.cell.Nz - 1; // top index of Z cell
		
		for ( int ox = ax - searchpar; ox < ax + searchpar+1 ; ox++ ){
			for ( int oy = ay - searchpar; oy < ay + searchpar+1 ; oy++ ){
				for ( int oz = az - searchpar; oz < az + searchpar+1 ; oz++ ){
					int oox = ox;
					int ooy = oy;
					int ooz = oz;
					//wrap into grid
					if ( oox < 0 ) oox += structure.cell.Nx;
					if ( oox > topx ) oox -= structure.cell.Nx;
					if ( ooy < 0 ) ooy += structure.cell.Ny;
					if ( ooy > topy ) ooy -= structure.cell.Ny;
					if ( ooz < 0 ) ooz += structure.cell.Nz;
					if ( ooz > topz ) ooz -= structure.cell.Nz;
					//identify grid cell
					int og = ooz + ( ooy * structure.cell.Nz ) + ( oox * structure.cell.Ny * structure.cell.Nz );
					//look in this cell;
					for ( int j = 0; j < structure.cell.grid.at( og ).size(); j++ ){
						int you = structure.cell.grid.at( og ).at(j);
						if ( i > you ) continue; // don't double count
						if ( i== you ) continue; // self
						if ( !inapot.at( you ) ) continue; // irrelevant atom
						if ( bonded( structure.atom.at(i), structure.atom.at(you) ) ) continue; // same cluster
						//identify the relevant potentials
						//check only my potential partner list not others
						int osp = structure.atom.at(you).type; //numeric version of species
						for ( int np = 0 ; np < partner.at( i ).size(); np++ ){
							if ( osp == partner.at( i ).at( np ) ){
								//this type matches species
								int wp = whichpot.at( i ).at( np ); // identify from array
								//pass on wrong rider
								//cases:
								//a 11 rider does not take a role 2 or 0 atom
								//a 22 rider does not take a role 1 or 0 atom
								//a 12 or 21 rider must take one of each of 1 and 2
								//a 1 rider takes a 0 and a 1
								//a 2 rider takes a 0 and a 2
								bool nazgul = false; // bad rider
								int rider = mcpot.at( wp ).rider;
								int arole = structure.atom.at( i ).role;
								int brole = structure.atom.at( you ).role;
								if ( rider > 0 ){
									if ( rider == 22 && ( arole != 2 || brole != 2) ){
										nazgul = true;
									}
									else if ( rider == 11 && ( arole != 1 || brole != 1) ){
										nazgul = true;
									}
									else if ( rider == 12 || rider == 21 ){
										//test the 12/21 case
										int sum = arole+brole;
										if ( sum != 3 ) nazgul = true;
									}
									else if ( rider == 1 ){
										if ( arole ==2 || brole == 2 ) nazgul = true;
										int sum = arole+brole;
										if ( sum !=1 ) nazgul = true;
									}
									else if ( rider == 2 ){
										if ( arole ==1 || brole == 1 ) nazgul = true;
										int sum = arole+brole;
										if ( sum !=2 ) nazgul = true;
									}									
								}
								if ( nazgul ) continue; // skip bad rider case
								//now do a distance check!
								
								//modify logic  to include a trap on closest reactive
								Vector dab = structure.atom.at( you ).pos - structure.atom.at( i ).pos; //raw vector, Cartesian
								Vector dwrapped = structure.cell.wrapcartdel( dab ); //wrapped vector
								double d2 = dwrapped.sq(); // squared distance to compare;
								double dmax = mcpot.at( wp ).r.at(  mcpot.at( wp ).r.size() -1 ); // biggest range on this potential
								if ( d2 > ( dmax*dmax ) ) continue; // too far to count
								
								//if we're here do the closest reactive trap here on reactive types...
								//if "i" is reactive, check other vertices and pass if needed
								//new logic: only pass on virtual (type 2) sites
								bool closerone = false;
								if ( arole ==2 ){
									//I expect only one cluster but let's not keep it formal
									for ( int acl = 0 ; acl < structure.atom.at( i ).inclust.size() ; acl++ ){
										if ( closerone ) break; // already got
										int acln = structure.atom.at( i ).inclust.at( acl );
										for ( int cls = 0 ; cls < structure.cluster.at( acln ).members.size(); cls++ ){
											int c = structure.cluster.at( acln ).members.at( cls ); //other atom to check
											if ( c == i ) continue; // pass identity
											//pass if it's not the same type and role as atom i
											if ( structure.atom.at(c).role != structure.atom.at(i).role ) continue;
											if ( structure.atom.at(c).type != structure.atom.at(i).type ) continue;
											// check distance
											Vector dbc = structure.atom.at(c).pos - structure.atom.at(you).pos;
											Vector dbcwrapped = structure.cell.wrapcartdel( dbc );
											double dbc2 = dbcwrapped.sq();
											if ( dbc2 < d2 ){
												closerone = true; // i is eclipsed by c
												//cerr << "Skipping " << i+1 << " as eclipsed by " << c+1 << endl;
												break;
											}
										}
									}
								}
								if ( closerone ) continue; // don't count eclipsed vertices
								
								//if "you" is reactive check other vertices and pass if needed
								//new logic - only do passing on virtual (type 2) sites
								closerone = false;
								if ( brole == 2 ){
									//I expect only one cluster but let's not keep it formal
									for ( int acl = 0 ; acl < structure.atom.at( you ).inclust.size(); acl++ ){
										if ( closerone ) break; // already got
										int acln = structure.atom.at( you ).inclust.at( acl );
										for ( int cls = 0 ; cls < structure.cluster.at( acln ).members.size(); cls++ ){
											int c = structure.cluster.at( acln ).members.at( cls ); //other atom to check
											if ( c == i ) continue; // pass identity
											//pass if it's not the same type and role as atom i
											if ( structure.atom.at(c).role != structure.atom.at(you).role ) continue;
											if ( structure.atom.at(c).type != structure.atom.at(you).type ) continue;
											// check distance
											Vector dac = structure.atom.at(c).pos - structure.atom.at(i).pos;
											Vector dacwrapped = structure.cell.wrapcartdel( dac );
											double dac2 = dacwrapped.sq();
											if ( dac2 < d2 ){
												closerone = true; // you is eclipsed by c
												//cerr << "Skipping " << you+1 << " as eclipsed by " << c+1 << endl;
												break;
											}
										}
									}
								}
								if ( closerone ) continue; // don't count eclipsed vertices								
								
								
								double d = sqrt( d2 );
								double energy = mcpot.at( wp ).pot( d ); // energy for this interaction
								//debug line
								//cerr << "Energy contribution of " << energy << " from atoms " << i+1 << " and " << you+1 << endl;
								result += energy;
							}
						}
						
										
					}
				}
			}
		}
		
		
		
		
	}
	
	return result; // total energy
}


//mc energy calculation loop // using moving-array list of atoms to restrict check
double mc_moving_energy( vector< int > mover, Structure &structure ){
	double result = 0.;
	int searchpar = ceil( maxr / structure.cell.mygridmin  ); // grid search range
	//cerr << " ECHECK ";
	
	//for ( int i = 0 ; i < structure.atom.size(); i++ ){
	for ( int mv = 0 ; mv < mover.size(); mv++ ){
		int i = mover.at( mv ); // i is now the relevant atom, as in mcenergy case
		if ( !inapot.at( i ) ) continue; // irrelevant atom
		
		int ax = structure.atom.at(i).gridx;
		int ay = structure.atom.at(i).gridy;
		int az = structure.atom.at(i).gridz;
		
		int topx = structure.cell.Nx - 1; // top index of X cell
		int topy = structure.cell.Ny - 1; // top index of Y cell
		int topz = structure.cell.Nz - 1; // top index of Z cell
		
		for ( int ox = ax - searchpar; ox < ax + searchpar+1 ; ox++ ){
			for ( int oy = ay - searchpar; oy < ay + searchpar+1 ; oy++ ){
				for ( int oz = az - searchpar; oz < az + searchpar+1 ; oz++ ){
					int oox = ox;
					int ooy = oy;
					int ooz = oz;
					//wrap into grid
					if ( oox < 0 ) oox += structure.cell.Nx;
					if ( oox > topx ) oox -= structure.cell.Nx;
					if ( ooy < 0 ) ooy += structure.cell.Ny;
					if ( ooy > topy ) ooy -= structure.cell.Ny;
					if ( ooz < 0 ) ooz += structure.cell.Nz;
					if ( ooz > topz ) ooz -= structure.cell.Nz;
					//identify grid cell
					int og = ooz + ( ooy * structure.cell.Nz ) + ( oox * structure.cell.Ny * structure.cell.Nz );
					//look in this cell;
					for ( int j = 0; j < structure.cell.grid.at( og ).size(); j++ ){
						int you = structure.cell.grid.at( og ).at(j);
						//we now consider energy contributions between i and you
						//if ( i > you ) continue; // don't double count
						if ( i== you ) continue; // self
						if ( isin( you, mover ) ) continue; //if you is also a mover, skip it of course
						if ( !inapot.at( you ) ) continue; // irrelevant atom
						if ( bonded( structure.atom.at(i), structure.atom.at(you) ) ) continue; // same cluster
						//identify the relevant potentials
						//check only my potential partner list not others
						int osp = structure.atom.at(you).type; //numeric version of species
						for ( int np = 0 ; np < partner.at( i ).size(); np++ ){
							if ( osp == partner.at( i ).at( np ) ){
								//this type matches species
								int wp = whichpot.at( i ).at( np ); // identify from array
								//pass on wrong rider
								//cases:
								//a 11 rider does not take a role 2 or 0 atom
								//a 22 rider does not take a role 1 or 0 atom
								//a 12 or 21 rider must take one of each of 1 and 2
								//a 1 rider takes a 0 and a 1
								//a 2 rider takes a 0 and a 2
								bool nazgul = false; // bad rider
								int rider = mcpot.at( wp ).rider;
								int arole = structure.atom.at( i ).role;
								int brole = structure.atom.at( you ).role;
								if ( rider > 0 ){
									if ( rider == 22 && ( arole != 2 || brole != 2) ){
										nazgul = true;
									}
									else if ( rider == 11 && ( arole != 1 || brole != 1) ){
										nazgul = true;
									}
									else if ( rider == 12 || rider == 21 ){
										//test the 12/21 case
										int sum = arole+brole;
										if ( sum != 3 ) nazgul = true;
									}
									else if ( rider == 1 ){
										if ( arole ==2 || brole == 2 ) nazgul = true;
										int sum = arole+brole;
										if ( sum !=1 ) nazgul = true;
									}
									else if ( rider == 2 ){
										if ( arole ==1 || brole == 1 ) nazgul = true;
										int sum = arole+brole;
										if ( sum !=2 ) nazgul = true;
									}									
								}
								if ( nazgul ) continue; // skip bad rider case
								//now do a distance check!
								
								//modify logic  to include a trap on closest reactive
								Vector dab = structure.atom.at( you ).pos - structure.atom.at( i ).pos; //raw vector, Cartesian
								Vector dwrapped = structure.cell.wrapcartdel( dab ); //wrapped vector
								double d2 = dwrapped.sq(); // squared distance to compare;
								double dmax = mcpot.at( wp ).r.at(  mcpot.at( wp ).r.size() -1 ); // biggest range on this potential
								if ( d2 > ( dmax*dmax ) ) continue; // too far to count
								
								//if we're here do the closest reactive trap here on reactive types...
								//if "i" is reactive, check other vertices and pass if needed
								//new logic: only pass on virtual (type 2) sites
								bool closerone = false;
								if ( arole ==2 ){
									//I expect only one cluster but let's not keep it formal
									for ( int acl = 0 ; acl < structure.atom.at( i ).inclust.size() ; acl++ ){
										if ( closerone ) break; // already got
										int acln = structure.atom.at( i ).inclust.at( acl );
										for ( int cls = 0 ; cls < structure.cluster.at( acln ).members.size(); cls++ ){
											int c = structure.cluster.at( acln ).members.at( cls ); //other atom to check
											if ( c == i ) continue; // pass identity
											//pass if it's not the same type and role as atom i
											if ( structure.atom.at(c).role != structure.atom.at(i).role ) continue;
											if ( structure.atom.at(c).type != structure.atom.at(i).type ) continue;
											// check distance
											Vector dbc = structure.atom.at(c).pos - structure.atom.at(you).pos;
											Vector dbcwrapped = structure.cell.wrapcartdel( dbc );
											double dbc2 = dbcwrapped.sq();
											if ( dbc2 < d2 ){
												closerone = true; // i is eclipsed by c
												//cerr << "Skipping " << i+1 << " as eclipsed by " << c+1 << endl;
												break;
											}
										}
									}
								}
								if ( closerone ) continue; // don't count eclipsed vertices
								
								//if "you" is reactive check other vertices and pass if needed
								//new logic - only do passing on virtual (type 2) sites
								closerone = false;
								if ( brole == 2 ){
									//I expect only one cluster but let's not keep it formal
									for ( int acl = 0 ; acl < structure.atom.at( you ).inclust.size(); acl++ ){
										if ( closerone ) break; // already got
										int acln = structure.atom.at( you ).inclust.at( acl );
										for ( int cls = 0 ; cls < structure.cluster.at( acln ).members.size(); cls++ ){
											int c = structure.cluster.at( acln ).members.at( cls ); //other atom to check
											if ( c == i ) continue; // pass identity
											//pass if it's not the same type and role as atom i
											if ( structure.atom.at(c).role != structure.atom.at(you).role ) continue;
											if ( structure.atom.at(c).type != structure.atom.at(you).type ) continue;
											// check distance
											Vector dac = structure.atom.at(c).pos - structure.atom.at(i).pos;
											Vector dacwrapped = structure.cell.wrapcartdel( dac );
											double dac2 = dacwrapped.sq();
											if ( dac2 < d2 ){
												closerone = true; // you is eclipsed by c
												//cerr << "Skipping " << you+1 << " as eclipsed by " << c+1 << endl;
												break;
											}
										}
									}
								}
								if ( closerone ) continue; // don't count eclipsed vertices								
								
								
								double d = sqrt( d2 );
								double energy = mcpot.at( wp ).pot( d ); // energy for this interaction
								//debug line
								//cerr << "Energy contribution of " << energy << " from atoms " << i+1 << " and " << you+1 << endl;
								result += energy;
							}
						}
						
										
					}
				}
			}
		}
		
		
		
		
	}
	
	return result; // total energy
}


void findOverlap( Structure &structure , vector< vector< int > > &oa ){
	//sizes
	//cerr << "New overlap finding system." << endl;
	int nc = structure.cluster.size(); // how many clusters
	int na = structure.atom.size(); //how many atoms
	int nr = structure.reactive.size(); // how many reactive atoms
	oa.clear(); // death
	oa.resize( nc ); // room for all	
	
	//loop over reactive atoms getting clusters
	//if I meet an overlap
	//feed clusters to each other in oa
	
	for ( int i =0 ; i < nr ; i++ ){
		int k = structure.reactive.at( i ); // atom k is the i'th reactive atom
		
		vector< int > nearme = structure.nearlist( k, 0.5 ); //just the closest - overlapping clusters
		int nn = nearme.size();
		if ( nn == 0 ) continue; //skip empties!
		
		for ( int p = 0 ; p < nn ; p++ ){
			int an = nearme.at( p ) ; // an other, overlapping atom
			if ( an < k ) continue; //don't double count
			if ( structure.atom.at( an ).role == 0 ) continue; //skip non-reactive
			
			//if we're here, feed the clusters to each other
			for ( int z = 0 ; z < structure.atom.at( k ).inclust.size() ; z++ ){
				int c1 = structure.atom.at( k ).inclust.at( z );
				
				for ( int y = 0 ; y < structure.atom.at( an ).inclust.size() ; y++ ){
					int c2 = structure.atom.at( an ).inclust.at( y );
					insertIfNotIn( c1, oa.at( c2 ) );
					insertIfNotIn( c2, oa.at( c1 ) );
					
				}
				
			}
			
			
		}
		
	}
	
	//for ( int i = 0 ; i < oa.size() ; i++ ){
	//	if ( oa.at(i).size() == 0 ) continue; // skip blanks
	//	cerr << "Cluster index " << i << " has overlaps with:";
	//	for ( int j = 0 ; j < oa.at(i).size() ; j++ ){
	//		cerr << " " << oa.at(i).at(j);
	//	}
	//	cerr << endl;
	//}	
	
}

void removeFromOverlap( int i, vector< vector< int > > &oa ){
	//
	if ( i >= oa.size() ) return; //don't run inappropriate indices
	for ( int k = 0 ; k < oa.at(i).size() ; k++ ){
		int j = oa.at(i).at(k);
		removeIfIn( i , oa.at( j ) ); //erase i from j's array 
	}
	oa.at(i).clear();//i no longer has any overlaps (floating in the ether)
}

void disOverlap( int i, int j, vector< vector< int > > &oa ){
	//cuts i and j out of each other's overlap array
	removeIfIn( j, oa.at(i) );
	removeIfIn( i, oa.at(j) );
}

void removeFromOverlap( vector< int > &i, vector< vector< int > > &oa ){
	//overloaded version takes array argument
	for ( int t = 0 ; t < i.size() ; t++ ){
		int k = i.at(t); //this cluster in question
		removeFromOverlap( k, oa ); //use the single version
	}
	
}


void addToOverlap( vector< int > &i, Structure &structure, vector< vector< int > > &oa){
	//
	for ( int k = 0; k < i.size() ; k++ ){
		int thisi = i.at(k); //the cluster we are looking at
		for ( int p = 0 ; p < structure.cluster.at(thisi).members.size(); p++ ){
			int thisa = structure.cluster.at(thisi).members.at(p); //an atom to consider
			if ( structure.atom.at( thisa ).role == 0 ) continue; //ignore the non-reactive ones
			//cerr << "DEBUG checking atom " << thisa << " in cluster " << thisi << endl;
			vector< int > nearme = structure.nearlist( thisa, 0.5 ); //just the closest - overlapping clusters
			int nn = nearme.size();
			if ( nn == 0 ) continue; //skip empties!
			//loop over the nearme atoms;
			//for each one, loop over their clusters and stick into oa
			
			for ( int q = 0 ; q < nn ; q++ ){
				int thisb = nearme.at(q); //the other atom
				if ( structure.atom.at(thisb).role == 0 ) continue; //ignore non-reactive neighbours
				
				//cerr << "DEBUG: found cluster overlap using atoms " << thisa << " , " << thisb << endl;
				
				//now consider cluster thisi versus other clusters that thisb is in
				for ( int y = 0 ; y < structure.atom.at(thisb).inclust.size() ; y++ ){
					int thisc = structure.atom.at(thisb).inclust.at( y ); //other cluster to consider
					
					//if ( isin( thisc, i ) ) continue; //already in the supercluster list, pass
					//cerr << "DEBUG: overlap of clusters " << thisi << " , " << thisc << endl;
					insertIfNotIn( thisc, oa.at( thisi ) ); //thisi to thisc
					insertIfNotIn( thisi, oa.at( thisc ) ); //thisc to thisi
					
				}
				
				
			}
			
		}
		
	}
}


vector< vector< int > > SCfromOA( vector< vector< int > > &oa ){
	//use a Garibaldi-like unification
	vector< vector< int > > result; // the supercluster list to return
	vector< bool > inSC;
	vector< int > mySC;
	
	inSC.clear();
	mySC.clear();
	
	for ( int i = 0; i < oa.size(); i++ ){
		if ( oa.at(i).size() > 0 ){
			inSC.push_back( true );
			mySC.push_back( i );
		}
		else{
			inSC.push_back( false );
			mySC.push_back( -1 );
		}
	}
		
	//bool seeking = true;
	bool changing = true;
	int rounds = 0;
	
	while ( changing ){
		rounds++;
		//cerr << "DEBUG SCfromOA:  round " << rounds << endl;
		changing = false;
		//bool localchanging = false;
		
		for ( int i = 0 ; i < oa.size() ; i++ ){
			if ( !inSC.at( i ) ) continue; // skip not overlapping
			
			for ( int j = 0 ; j < oa.at( i ).size() ; j++ ){
				int k = oa.at(i).at(j);
				
				if ( mySC.at( k ) < mySC.at( i ) ){
					changing = true;
					mySC.at( i ) = mySC.at( k );
				}
				else if ( mySC.at( i ) < mySC.at( k ) ){
					changing = true;
					mySC.at( k ) = mySC.at( i );
				}
				
			}
			
			
		}
		
		//if ( changing ) cerr << "DEBUG SCfromOA: still changing." << endl;
		//if ( !changing ) cerr << "DEBUG SCfromOA: no longer changing." << endl;
	}
	
	//now translate from mySC values into result array
	//new version using multi pass instead of n(n+1) scaling
	vector< int > trueSC;
	trueSC.resize( mySC.size() );
	for ( int i = 0; i < trueSC.size(); i++ ){
		trueSC.at(i) = -1;
	}	
	for ( int i = 0; i < mySC.size(); i++ ){
		//cases where !inSC are skipped
		if ( !inSC.at( i ) ) continue; //trueSC is still -1
		//cases where mySC(i)==i spawn a new cluster
		//it contains i to begin with
		//it is pushed onto result
		//it is cluster k = result.size() - 1
		//trueSC(i) becomes k
		if ( mySC.at(i) == i ){
			vector< int > sc;
			sc.push_back( i );
			result.push_back( sc );
			int k = result.size() - 1;
			trueSC.at(i) = k;
		}
		//cases where mySC(i) = j < i must belong to an already existing cluster by construction
		//so there trueSC(i) becomes trueSC(j) = k
		//they are pushed onto result(k)
		else{
			int j = mySC.at(i); //parent object
			int  k = trueSC.at(j); //cluster id
			result.at(k).push_back( i );
		}		
		
	}	
	
	
	return result;
}

// build the cluster containing id X
vector< int > SCofX( int X, vector< vector< int > > &oa ){
	vector< int > ash;
	vector< int > flame;
	vector< int > spark;
	
	ash.clear();
	flame.clear();
	flame.push_back( X ); //start the fire
	
	bool searching = true;
	
	while ( searching ){
		spark.clear();
		for ( int i = 0 ; i < flame.size() ; i++ ){
			int iii = flame.at( i ); //the id, i.e. initially X...
			ash.push_back( iii );
			for ( int j = 0 ; j < oa.at(iii).size() ; j++ ){
				int jjj = oa.at(iii).at( j ); //another id, to catch fire...
				if ( isin( jjj, ash ) ) continue;
				if ( isin( jjj, flame ) ) continue;
				spark.push_back( jjj );
			}
		}
		if ( spark.size() < 1 ) searching = false;
		flame = spark; //all of flame got put into ash; now spark becomes flame
	}
	return ash; // the result of the burning
}

//build clusters of only members of Y, using OA
vector< vector< int > > SCinY( vector< int > &Y, vector< vector< int > > &oa ){
	vector< int > bondto, SC;
	bondto.resize( Y.size() );
	SC.resize( Y.size() );
	for ( int i = 0 ; i < Y.size() ; i++ ){
		bondto.at(i) = i; //initial setup
		SC.at(i) = -1;
	}
	
	bool changing = true;
	
	vector< vector< int > > oay; //sub-overlap routine for faster handling
	
	for ( int i = 0 ; i < Y.size() ; i++ ){
		vector< int > thisoa;
		int iii = Y.at(i); //the id to check in oa;
		for ( int j = 0 ; j < oa.at(iii).size() ; j++ ){
			int jjj = oa.at(iii).at(j); //the other id to check
			if ( isin( jjj, Y ) ) thisoa.push_back( jjj ); //an id put into the smaller array
		}
		oay.push_back( thisoa ); //a row of oay;
	}
	//oay now contains the ids of atoms of Y overlapping with other atoms of Y
	//first index is i of Y
	//contents are ids to compare to contents of Y
	
	while ( changing ){
		changing = false;
		
		//loop over Y using i
		//loop over Y using j >i
		//exclude neighbours not in Y //we have now done this first, by building oay!
		//use italy/bondto unification on indices of Y
		
		for ( int i = 0 ; i < Y.size() ; i++ ){
			//int iii = Y.at(i);
			for ( int j = i+1 ; j < Y.size() ; j++ ){
				int jjj = Y.at(j);
				
				if ( !isin( jjj, oay.at(i) ) ) continue; //so we skip noncontact cases
				
				int italy = bondto.at(i);
				if ( italy > bondto.at(j) ) italy = bondto.at(j);
				
				bool localchanging = false;
				if ( italy != bondto.at(i) ) localchanging = true;
				if ( italy != bondto.at(j) ) localchanging = true;
				if ( localchanging ) changing = true; //maintaining flag
				
				bondto.at(i) = italy;
				bondto.at(j) = italy;
			}
		}
	}
	
	//now: cases that have bondto[i]==i seed clusters;
	//cases that have bondto[i]!=i join other, lower clusters
	//do in two passes
	int SCtracker = 0;
	for ( int i = 0 ; i < Y.size() ; i++ ){
		if ( bondto.at(i) == i ){
			SC.at(i) = SCtracker; //father of this SC
			SCtracker++; //increment!
		}
		else{
			for ( int j = 0 ; j < i ; j++ ){
				if ( bondto.at(i) == j ){
					SC.at(i) = SC.at(j); //child of this SC
				}
			}
		}
		if ( SC.at(i) < 0 ){
			cerr << "Failure state in OAY loop!" << endl;
			exit(1);
		} //this should never happen
	}
	
	vector< vector< int > > result;
	result.resize( SCtracker ); //this many!
	for ( int i = 0 ; i < Y.size() ; i++ ){
		result.at( SC.at(i) ).push_back( Y.at(i) );
	}
	
	return result;
}




vector< bool > getFilter( Structure &structure, vector< vector< int > > &oa){
	vector< bool > result;
	result.resize( structure.atom.size() ); //filter by atoms, remember!
	
	for ( int i = 0 ; i < structure.atom.size() ; i++ ){
		result.at(i) = false;
		//return true if any of this atom's clusters have nonzero oa size
		int nc = structure.atom.at(i).inclust.size();
		for ( int j = 0 ; j < nc ; j++ ){
			int k = structure.atom.at(i).inclust.at(j);
			if ( oa.at(k).size() > 0 ) result.at(i) = true; //labelled!
		}
		
	}
	return result;
}

vector< int > getHisto( vector< vector< int > > &oa ){
	vector< int > result;
	for ( int j = 0 ; j < 7; j++){
		result.push_back( 0 ); //initial padding
	}
	//convert oa array into histogram form;
	for ( int i = 0 ; i < oa.size(); i++ ){
		int n = oa.at(i).size(); // this is coordination n
		//can the array contain it;
		if ( n > result.size() ){
			for ( int a = result.size(); a < n; a++ ){
				result.push_back( 0 ); //pad with zeroes to size
			}
		}
		//increment entry
		result.at(n)++;
	}
	
	cerr << "HISTOGRAM" << endl;
	for ( int i = 0 ; i < result.size(); i++ ){
		cerr << i << " " << result.at( i ) << endl;
	}
	return result;
}

vector< int > metalHisto( vector< vector< int > > &oa, int np ){
	vector< int > result;
	for ( int j = 0 ; j < 7; j++){
		result.push_back( 0 ); //initial padding
	}
	//convert oa array into histogram form;
	for ( int i = 0 ; i < np; i++ ){
		int n = oa.at(i).size(); // this is coordination n
		//can the array contain it;
		if ( n > result.size() ){
			for ( int a = result.size(); a < n; a++ ){
				result.push_back( 0 ); //pad with zeroes to size
			}
		}
		//increment entry
		result.at(n)++;
	}
	
	cerr << "METAL HISTOGRAM" << endl;
	for ( int i = 0 ; i < result.size(); i++ ){
		cerr << i << " " << result.at( i ) << endl;
	}
	return result;	
}


void writeHisto( string hisname, vector< int > &histo ){
	cerr << "Writing histogram to " << hisname << endl;
    ofstream histfile( hisname.c_str() );
     
     for ( int i = 0 ; i < histo.size(); i++ ){
         histfile << i << " " << histo.at(i) << endl;
     }
     
     histfile.close();   

}


vector< int > linkedCluster( vector< vector< int > > &oa, int i, double p ){
	vector< int > result;
	vector< int > testing;
	
	testing.push_back( i ); //initial case
	
	while ( testing.size() > 0 ){
		//do this while candidates remain
		int o = testing.at(0);
		testing.erase( testing.begin() ); //kill the candidate from the list
		if ( isin( o, result ) ){
			//already handled
			continue;
		}
		result.push_back( o ); //this testing candidate becomes part of the cluster
		//now check its overlap neighbours
		for ( int j = 0 ; j < oa.at(o).size() ; j++ ){
			int k = oa.at(o).at(j); //k is an object that o overlaps with
			//do probability test to link
			double pp = getRandom();
			if ( pp > p ) continue; //skip, no link formed
			testing.push_back( k );
		}
	}
	
	//debug code here!
	//cerr << endl;
	//cerr << "LC : ";
	if ( oa.at(i).size() == 0 ) cerr << "(00) ";
	for ( int z = 0; z < result.size() ; z++ ){
		if ( z == 0 ){
			//cerr << " ";
			continue; //doesn't print first member
		}
		cerr << result.at(z) +1 << " ";
	}
	//cerr << endl;
	
	return result;
}


int countEdges( vector< int > &mc, vector< vector< int > > &oa ){
	int result = 0;
	for ( int i = 0 ; i < mc.size() ; i++ ){
		int j = mc.at(i) ;//the object we are testing
		for ( int k = 0 ; k < oa.at(j).size() ; k++ ){
			int q = oa.at(j).at(k) ; //another object
			if  ( !isin( q, mc ) ) result++; //there is an overlap between moving cluster member j and other object q
		}
	}
	return result; //number of dangling overlaps
}

int type3( vector< int > &C, Structure &S, vector< vector< int > > &oa ){
	//C should be an overlapping cluster of 3
	//Return values:
	//1 for MMM
	//2 for MML;
	//3 for MLM;
	//4 for LML
	//0 for problem cases, or if not size 3
	if ( C.size() != 3 ) return 0; //catch!

	vector< int > status;
	status.resize( 3 );
	int nM = 0;
	int nL = 0;
	for ( int i = 0 ; i < 3 ; i++ ){
		//C.at(i) is the id of a cluster in S.cluster
		status.at(i) = S.metalLigandStatus( S.cluster.at( C.at(i) ) );
		if ( status.at(i) == 1 ) nM++;
		if ( status.at(i) == 2 ) nL++;
	}
	
	if ( nM + nL != 3 ) return 0; //weird case?
	if ( nL == 3 ) return 0;//shouldn't happen!
	
	if ( nM == 3 ) return 1; //MMM cluster	
	if ( nL == 2 && nM == 1 ) return 4; //LML cluster
	//this just leaves nL==1, nM==2
	//MML and MLM are distinguished by the connectivity of the L: two or one M neighbours?
	int m1 = 0; int m2 = 0 ; int l1 = 0; 
	//use these to index the metal and ligand ids for checking oa
	if ( status.at(0) == 2 ){
		l1 = C.at(0); m1 = C.at(1); m2 = C.at(2);
	}
	else if ( status.at(1) == 2 ){
		l1 = C.at(1); m1 = C.at(0); m2 = C.at(2);
	}	
	else {
		l1 = C.at(2); m1 = C.at(0); m2 = C.at(1);
	}
	if ( isin( m1, oa.at( l1 ) ) && isin ( m2, oa.at(l1) ) ){
		return 3; //l1 has both m1 and m2 as overlap neighbours
	}
	else{
		return 2; //l1 only has one metal neighbour
	}
	
	return 0; //just in case!
}

vector< int > count3s( vector< vector< int > > &C, Structure &S, vector< vector< int > > &oa ){
	vector< int > result;
	result.resize( 4 ); //entries 0-3 hold counts for cluster types 1-4 ; be consistent
	for ( int j = 0 ; j < 4 ; j++ ){
		result.at(j) = 0; //just for certain!
	}
	for ( int i = 0 ; i < C.size(); i++ ){
		int t = type3( C.at(i), S, oa );
		if ( t == 0 ) continue;
		result.at( t-1 )++; //up the count
	}
	return result;
}



