#include "basic_utils.h"
#include "Vectors.h"
#include "Rotors.h"
#include "Geometry.h"
#include "Structure.h"

#ifndef __MCCONTROL_H_DEFINED_
#define __MCCONTROL_H_DEFINED_

extern string inpfilename;
extern bool given_title ;
extern bool hastitle ;
extern string title;
extern bool given_elements ;
extern bool given_poly ;
extern vector< Polyspec > polyspec; // spec when given
extern bool given_bond ;
extern vector< Bondspec > bondspec; // spec when given
extern bool given_option ;
extern bool given_contact ;
extern bool given_grid ;
extern double gridmin; // grid boxes at least this size.
extern double regrid_after; //max move before implementing a regrid
extern double polypad; // multiplier on bondlength when finding poly bonding
extern bool do_jiggle ;
extern double jigsize; //jiggle in Angstroms
extern bool given_relax_command ;
extern bool chebyshev ; // not by default - explodes on contacts! // replace these with int docheb status
extern double cheb; // over-relaxation factor
extern bool use_auto_chebyshev ; //dynamic chebyshev updater
extern double dampclash; // stabilise clash calculations in move
extern bool criterion_mis ;
extern double smallmovecriterion; // stop when move is this small
extern double smallmiscriterion; // and when mis is this small?
extern bool given_input ;
extern bool given_structure ;
extern string input_structure_name;
extern bool given_new_structure ;
extern string new_structure_name;
extern bool given_bond_input ;
extern string input_bonding_name;
extern vector< Bondline > bondline; //bonds from input file if given
extern bool given_new_cell ;
extern bool do_label ; // output labels in the xtl output!
extern bool given_output ;
extern bool do_output_structure ;
extern string output_structure_name;
extern bool do_output_bonding ;
extern string output_bonding_name;
extern bool do_output_poly ;
extern string output_poly_name;
extern bool do_output_clusters ;
extern string output_clusters_name;
extern bool do_output_bonds ;
extern string output_bonds_name;
extern bool do_output_angles ;
extern string output_angles_name;
extern bool do_output_mismatches ;
extern string output_mismatches_name;
extern bool nodeloc ; // do not include delocalisation rigidity

extern bool given_seed;
extern long int seed;

extern bool do_mctransform;
extern bool do_generate; // create a structure for monte carlo
extern vector < int > genN; // number of objects to generate

extern Structure inputstructure; // use for initial reading
extern Structure structure; // used when actually running
extern Structure newstructure; // used if a restart position is given
extern vector< double > newcellparam; // used if new cell is given
extern double mcvdwtol;
extern double maxradius;

extern bool do_mcrun;
extern int mctrials, mcfreq;
extern int tried, accepted, rejected, clashrejected, linkrejected;
extern string mcname;
extern bool givenmcname;

//extern bool do_read_mcpot;
extern bool given_mcpot;
extern string mcpotname;

extern double mct; // MC temperature
extern double oldenergy, tryenergy; // structure energies for MC
extern bool given_mct;
extern double gasconst;

extern double maxr; // maximum MC interaction distance
//arrays to handle energy potential calculations
extern vector< bool > inapot; // am I relevant?
extern vector< vector< int > > whichpot; // what potentials do I belong to?
extern vector< vector< int > > partner; // the other element in this potential
extern vector< vector< double > > rmax; // the range of this potential

//toggles to control Monte Carlo small/large moves
extern bool use_small_move;
extern double smallmovesize;
extern bool given_mcprobs;
extern double bigprob;
extern double smallprob;

extern double RDFbin;
extern double RDFmax;
extern bool doRDF;
extern string rdfbasename;
extern bool givenrdfbasename;

extern bool dolog;
extern string logname;
extern int logfreq;

extern vector< vector< int > > overlapArray; //
extern vector< bool > overlapFilter;
extern bool doOverlaps;
extern string overlapname;
extern vector< int > overlapHistogram, metalHistogram;

extern bool doCollective;
extern vector< vector< int > > supercluster; // supercluster n is a list of clusters i,j...
extern double pCollective ;
extern double pLink;

extern vector< int > groupsMade, groupsAccepted; //stat tracker for group moves

extern bool track3s;
extern vector< vector< int > > savedOA; //saved overlap array for change tracking
extern vector< int > setA, setB, disA, disB;
extern vector< int > setA3s, setB3s, disA3s, disB3s;
extern vector< int > tally3s;
extern vector< int > GBA, LBA, GBD, LBD; //Gain/Loss By Assembly, Disassembly
extern string log3name;


struct Ligand{
  public:
         vector< string > species; // list of elements
         vector< Vector > pos; // atom positions
		 vector< Element > element; // my elements live here
		 vector< Atom > atom; // my atoms live in here
		 Cluster clust; // just one cluster per ligand in current version!
         
  friend ostream &operator<<(ostream &out, const Ligand &c);
  bool ligandcluster(); // makes the clust in a ligand
  void ligbondfind( vector< Bondspec > bondspec ); // find the interatomic bonding in the ligand - needed?
};

struct MCPot{
	public:
		string sp1;
		string sp2;
		int rider;
		vector< double > r;
		vector< double > E;
		vector< double > grad;
		//now the coefficients for calculation
		vector< double > h0;
		vector< double > h1;
		vector< double > h2;
		vector< double > h3;
		//constructor;
		MCPot(){
			sp1=""; sp2="";rider=0;
		}
		
		//function to make the coefficients
		void makeh();
		//function to return E for a given r
		double pot( double rin );
		string pothead(); //write out header
		string graphpot(); // write out as r,E graph
};


extern vector< Ligand > ligand; // if I get any ligands
extern bool given_ligand;
extern vector< Poly > MCpoly; //for constructed poly objects
extern vector< MCPot > mcpot; // for potentials


bool validation(); // validates input logic before attempting to run
bool readcommands( string commandfilename); // read the GASP config file
void mctransform( Structure &inputstructure ); // cut into polys and ligands
void mcgenerate( Structure &inputstructure ); // create a box full of polys and ligands
void mcbigrandom( Cluster &acluster, vector< Atom > &tryatom, Structure &inputstructure); // put the cluster and its member atoms in a new place
void mcsmallrandom( Cluster &acluster, vector< Atom > &tryatom, Structure &inputstructure, double step); // small move with step size

bool mcinsertclash( Atom &atom, Structure &structure );
bool mcinsertclash( Atom &atom, Structure &structure, vector< int > ignore ); // overloaded with ignore array

string mcfilename( int n, int width=8 );

bool readpotential( string filename, vector< MCPot > &mcpot ); // read a potential file
double mcenergy( Structure &structure ); // calculate energy using mcpot
double mc_moving_energy( vector< int > mover, Structure &structure ); // calculate energy using mcpot

vector< vector< int > > SCfromOA( vector< vector< int > > &oa ); // make supercluster lists from overlap array
void findOverlap( Structure &structure, vector< vector< int > > &oa); // get overlaps into an array recording cluster to cluster
void removeFromOverlap( int i, vector< vector< int > > &oa ); //remove cluster i from the overlap array
void disOverlap( int i, int j, vector< vector< int > > &oa ); //split up clusters i,j in overlapArray oa
void removeFromOverlap( vector< int > &i, vector< vector< int > > &oa ); // remove whole array of clusters from array
void addToOverlap( vector< int > &i, Structure &structure, vector< vector< int > > &oa); //add the list in i to the overlap array

vector< int > SCofX( int X, vector< vector< int > > &oa ); // build the cluster containing id X
vector< vector< int > > SCinY( vector< int > &Y, vector< vector< int > > &oa ); //build clusters of only members of Y, using OA



vector< bool > getFilter( Structure &structure, vector< vector< int > > &oa); // make a bool filter from the oa array
vector< int > getHisto( vector< vector< int > > &oa ); //count histogram
vector< int > metalHisto( vector< vector< int > > &oa, int np ); //histogram over only the np poly clusters
void writeHisto( string hisname, vector< int > &histo ); //write a histogram as text

vector< int > linkedCluster( vector< vector< int > > &oa, int i, double p ); //make a cluster from overlaps with link probability p
int countEdges( vector< int > &mc, vector< vector< int > > &oa ); //counts overlaps between mc and not-mc objects

int type3( vector< int > &C, Structure &S, vector< vector< int > > &oa ); //classify a size-3 cluster by contents and topology.
vector< int > count3s( vector< vector< int > > &C, Structure &S, vector< vector< int > > &oa ); //use type3 on each of C, return array with counts by type


#endif
