#include "MCcontrol.h"

int main(int argc, char *argv[]){
    
  cerr << "Welcome to MCGASP, experimental MOF Monte Carlo code." << endl;
  cerr << "Written by Stephen Wells at Bath Uni." << endl;
  cerr << endl;

  //srand(static_cast<unsigned>(time(0)));
  //init_genrand( static_cast< unsigned > (time(0) ) );
  //do initialiseRandom later;
  
  //cerr << "Args: " << argc << endl;
  if ( argc == 1 ) {
     cerr << "No filename given; seeking default file mcg.inp" << endl;
     inpfilename = "mcg.inp"; 
  }
  else{
     stringstream whatin;
     whatin << argv[1];
     inpfilename = whatin.str();
     cerr << "Reading input from file " << inpfilename << endl;
  }
        
  //Step 1: parse input file
  bool inputokay = readcommands (inpfilename );
  if (inputokay){
     cerr << "Input okay, continuing." << endl;
  }
  else {
       cerr << "Input not found. Goodbye, cruel world." << endl;
       exit(1);
  }
  
  //Step 2: validate input file
  
  bool valid = validation();
  if ( !valid ) {
     cerr << "Stopping execution due to invalid input logic." << endl;
     cerr << "Cretans are liars, said Epimenides the Cretan." << endl;
     exit(1);     
  }
  
  if ( !given_seed ){
	  seed = static_cast< long >( time(0) );
  }
  cerr << "Initiating Mersenne Twister with seed " << seed << endl;
  initialiseRandom( seed );
  
  ofstream seednote;
  seednote.open("seednote");
  seednote << "RANDOM SEED " << seed << endl;
  seednote.close();
  
  //initial check on ligand logic
  if ( ligand.size() > 0 ){
	  cerr << "Found " << ligand.size() << " ligand specifications." << endl;
	  for ( int i = 0 ; i < ligand.size(); i++ ){
		  cerr << "Ligand spec " << i+1 << ":" << endl;
		  cerr << ligand.at(i);
		  if ( ligand.at(i).pos.size() == 0 ){
			  cerr << "WARNING: empty ligand spec!" << endl;
		  }
		  ligand.at(i).element = inputstructure.element; // grabbing info from config
		  bool liginit = ligand.at(i).ligandcluster(); // initialisation
		  if ( liginit ){
			  cerr << "Initialised ligand spec " << i+1 << endl;
		  }
		  else{
			  cerr << "Failed in initialising ligand spec " << i+1 << endl;
			  exit(1);
		  }
		  ligand.at(i).ligbondfind( bondspec ); // make bonding in the ligands
	  }
  }

  maxradius = inputstructure.maxrad(); //set from elements
  
  if ( do_generate ){
	  mcgenerate( inputstructure );
  } // end of generate
  
//from here assumes a structure input
//this will not be the case if we are using the generate approach
//so need to encase this in a conditional
  if ( given_structure ){
	//Step 3: obtain structure and bonding
	//read initial_structure vector< Atom > and initial_cellparam from input_structure_name
	bool cifok = inputstructure.readcif( input_structure_name );
	if ( !cifok ) {
		cerr << "Stopping execution due to invalid cif input." << endl;
		cerr << "I require flawless crystals." << endl;
		exit(1);     
	}
	if ( inputstructure.atom.size() == 0 ){
		cerr << "Problem - no atoms in input!" << endl;
		exit(1);
	}
	else {
       cerr << "Read " << inputstructure.atom.size() << " atoms." << endl;
	}
  
	bool isinit = inputstructure.initialise( gridmin);
	//do cell vectors, inverse vectors, and cartesian positions, also fill grid
	if ( !isinit ){
		cerr << "Sadly, we have choked on an unknown element. Please call an alchemist." << endl;
		exit(1); // die
	}

	//if bonding file given, read bonding
	//give atoms their bond lists here.
	if ( given_bond_input ){
		bool bok = readbonds( input_bonding_name , bondline );
		if ( !bok ) {
			cerr << "Stopping execution due to invalid bonding input. Better bondage please." << endl;
			exit(1);     
		}
		inputstructure.bondsintoatoms( bondline );
	}

	if ( !given_bond_input && given_poly ){
		inputstructure.polybondfind( polyspec, polypad );
	}

	if ( !given_bond_input && given_bond ){
		inputstructure.bondbondfind( bondspec );
	}

	//OK, let's make mctransform into a routine in MCcontrol for clarity
	//routine turns connection atoms into multiple copies to separate the polys and ligands
	if ( do_mctransform ){
		mctransform( inputstructure ); // method is in MCcontrol
	}

	inputstructure.formbondlines( bondline ); // bondlines to output, also handles rigidity

	//okay, all bonding done
	inputstructure.allrigidcheck(); // set labels for Garibaldi later
    //reactive vertex labelling:
    inputstructure.setvirtual();
	
	//parse neighbours for poly specs
	if ( given_poly ){
		cerr << "Parsing polyhedra." << endl;
		inputstructure.parsepoly( polyspec );
	}
	cerr << "Found " << inputstructure.poly.size() << " polyhedra." << endl;

	//now the non-poly bond clusters
	//note cluster array already contains null entry for each poly!
	if ( given_bond ){ // note given bond is required even if we have given bond input... tidy later?
			vector< Cluster > candidate = inputstructure.candidatecluster( bondspec ); // initial bonding clusters
			cerr << "Found " << candidate.size() << " non-poly clusters." << endl;          
			vector< Cluster > goodcandidate;
			goodcandidate = inputstructure.Garibaldi( candidate ); // reunification

			//finally put into cluster and ghost!
			for ( int i = 0 ; i < goodcandidate.size() ; i++ ){
				inputstructure.cluster.push_back( goodcandidate.at(i) );
				inputstructure.ghost.push_back( goodcandidate.at(i) );
			}
			candidate.clear();
			goodcandidate.clear(); // just housekeeping.
	}
  
	cerr << "Found " << inputstructure.cluster.size() << " total clusters." << endl;

	inputstructure.prepclustersandghosts();
	//polys now exist as poly, as cluster, and as ghost
	//nonpolys exist as cluster and as ghost
	// poly-ghosts have perfect geometry
	//hey, for MC purposes, we should replace the imperfect read polys with their perfect ghosts!
	
	//label atoms by inclust! and isvertex
	inputstructure.labelvertices();
	//initial structure has defined bonding, cluster and poly geometry.
	//initial_structure goes into structure now ready to move.
  }	// "if given input structure" ends here

  structure = inputstructure; // :) use structure subsequently for e.g. relax
  //maxradius = structure.maxrad();
 
  if (doOverlaps ){
	  findOverlap( structure, overlapArray );
	  //supercluster = SCfromOA( overlapArray );
	  groupsMade.clear();
	  groupsMade.push_back( 0 );
	  groupsAccepted.clear();
	  groupsAccepted.push_back( 0 );
  }
  
 
  //Step 4: MONTE CARLO logic happens in here

  newstructure = structure; //we attempt moves on newstructure and move them into structure if they are acceptable
  cerr << setprecision( 3 );

  //get some potentials maybe
  if ( given_mcpot ){
	  cerr << "Attempting to read potentials." << endl;
	  bool goodpot = false;
	  goodpot = readpotential( mcpotname, mcpot ); // fills mcpot with potentials
	  if ( goodpot ){
		  cerr << "Read potentials successfully." << endl;
	  }
	  else{
		  cerr << "FATAL: Potential read failed. Pfft." << endl;
		  exit(1);
	  }
	  cerr << "I have read " << mcpot.size() << " MC potentials." << endl;
	  
	  for ( int i = 0; i < mcpot.size(); i++){
		  double thismaxr = mcpot.at(i).r.at( mcpot.at(i).r.size() - 1 ); // longest range in this potential
		  if ( thismaxr > maxr ) maxr = thismaxr;
	  }
	  cerr << "Maximum interaction range: " << maxr << endl;
	  int searchpar = ceil( maxr/gridmin );
	  cerr << "Grid search parameter: " << searchpar << endl;
	  
	  //now prepare the management arrays
	  inapot.resize( structure.atom.size() );
	  whichpot.resize( structure.atom.size() );
	  partner.resize( structure.atom.size() );
	  rmax.resize( structure.atom.size() );
	  for ( int i = 0 ; i < structure.atom.size(); i++ ){
		  inapot.at( i ) = false; // preset
		  string myname = structure.atom.at(i).species;
		  int myrole = structure.atom.at(i).role;
		  for ( int j = 0; j < mcpot.size(); j++ ){
			   bool goodspec = false;
			   string other;
			   bool goodrole = true;
			   
			   if ( myname == mcpot.at(j).sp1 ){
				   other = mcpot.at(j).sp2;
				   goodspec = true;
			   }
			   else if ( myname == mcpot.at(j).sp2 ){
				   other = mcpot.at(j).sp1;
				   goodspec = true;
			   }
			   if ( !goodspec ) continue; // no match
			   //Riders:
			   //22 covers two role 2 (virtual reactive) sites
			   //11 covers two role 1 (real reactive) sites
			   //12 or 21 covers one of each so excludes role 0
			   //1 is for a role 0 to role 1, so excludes role 2
			   //2 is for a role 0 to role 2 so excludes role 1
			   if ( mcpot.at(j).rider == 22 && myrole < 2 ) goodrole = false;
			   if ( mcpot.at(j).rider == 11 && myrole == 2 ) goodrole = false;
			   if ( mcpot.at(j).rider == 12 && myrole == 0 ) goodrole = false;
			   if ( mcpot.at(j).rider == 21 && myrole == 0 ) goodrole = false;
			   if ( mcpot.at(j).rider == 1 && myrole == 2 ) goodrole = false;
			   if ( mcpot.at(j).rider == 2 && myrole == 1 ) goodrole = false;
			   if (!goodrole ) continue; // wrong kind
			   
			   double thisr = mcpot.at(j).r.at(  mcpot.at(j).r.size() -1 );
			   inapot.at( i ) = true; //
			   whichpot.at( i ).push_back( j ); // this kind of potential
			   int otheri = structure.eletype( other ); // numeric type=species
			   partner.at( i ).push_back( otheri ); // friend type
			   rmax.at( i ).push_back( thisr ); // range
			   //cerr << "Atom " << i+1 << " is in potential type " << j << endl;
		  }
	  }
	  
  }

  ofstream logstream;
  if ( dolog ){
	  logstream.open( logname.c_str() );
  }
  
  ofstream log3stream;
  if ( track3s ){
  	log3stream.open( log3name.c_str() );
  }
  
  if ( do_mcrun ){
	  cerr << "Hello, I'm the MCRUN function." << endl;
	  time_t startmctime, endmctime;
	  startmctime = time(0);
	  cerr << "MCRUN start time " << startmctime << endl;

      if ( track3s ){
      	setA3s.resize( 4 );
      	setB3s.resize( 4 );
      	disA3s.resize( 4 );
      	disB3s.resize( 4 );
      	tally3s.resize( 4 );
      	GBA.resize( 4 );
      	LBA.resize( 4 );
      	GBD.resize( 4 );
      	LBD.resize( 4 );
      }

	  bool mcrunning = true; // switch for ending the run
	  Cluster oldcluster, trycluster; //the cluster we're playing with
	  
	  vector< int > movingCluster; // list of moving clusters: one or, if doCollective, more
	  vector< Cluster > oldc, tryc; // use these instead of oldcluster, newcluster as we may be moving several
	  Cluster squadron; //squadron will be the supercluster Cluster object made from the moving object
	  
	  vector< int > id; //the atom ids in it
	  int whichc; // this cluster number
	  int whicho; // which moving object number?
	  vector< Atom > oldatom, tryatom; // the atoms we're playing with
	  oldenergy = 0.;
	  tryenergy = 0.;
      oldenergy = mcenergy( newstructure );
      cerr << "Starting energy: " << oldenergy << endl;
      int nsmall = 0, nbig = 0; // big and small moves

	  while ( mcrunning ){
		  tried++; // counts trials
		  //cerr << endl;
		  cerr << "Trial " << fixed << setw(10) << tried << " ";
		  if ( tried == mctrials ){
			  mcrunning = false;
			  cerr << "All of " << tried << " trials: last round." << endl;
		  }
		  
		  //housekeeping
		  id.clear();
		  oldatom.clear();
		  tryatom.clear();
		  movingCluster.clear();
		  oldc.clear();
		  tryc.clear();
		  squadron = nullcluster; // zeroing out
		  
		  bool isSC = false; //is the moving object a supercluster?
		  do{
		      whicho = getRandom() * newstructure.cluster.size();
		  } while ( whicho == newstructure.cluster.size() ); //in case of top-of-range slop		  
		  
		  //if tracking size 3 clusters:
		  //set A is the percolating overlap cluster of whicho
		  //regardless of whether move is collective or single
		  //and doOverlaps was activated by trois/log3s if given
		  if ( track3s ){
		  	setA = SCofX ( whicho, overlapArray );
		  	savedOA = overlapArray; //saving a copy for later
		  }
		  //setB etc. can only be created after move acceptance, so go there next.
		  
		  
		  //make the choice of moving object
		  if ( doCollective){
			  //use pCollective to decide whether to move a group or not
			  double pp = getRandom();
			  if ( pp < pCollective ) isSC = true; //we will attempt a group move

			  if ( isSC ){
				  cerr << "Cluster@" << fixed << setw(10) << whicho+1 << " "; //@ now just flags an attempt at a group move
			  }
			  else{
				  cerr << "Cluster " << fixed << setw(10) << whicho+1 << " ";
			  }
		  }
		  else{
			  cerr << "Cluster " << fixed << setw(10) << whicho+1 << " ";
		  }
		  
		  //now implement into arrays;
		  // if isSC, implement supercluster logic;
		  //otherwise, implement single cluster logic;
		  //retain maximum generality otherwise
		   if ( isSC ){
			   //whicho is the id of a cluster
			   //we derive a supercluster using its overlaps
			   movingCluster = linkedCluster( overlapArray, whicho, pLink ); //this may just be whicho on its own!
			   for ( int m = 0 ; m < movingCluster.size() ; m++ ){
				   //which single cluster?
				   int c = movingCluster.at( m ); //this cluster
				   //cerr << "SC DEBUG: moving cluster " << c << endl;
				   oldc.push_back( newstructure.cluster.at( c ) );
				   for ( int t = 0 ; t < newstructure.cluster.at( c ).members.size() ; t++ ){
					   int a = newstructure.cluster.at( c ).members.at( t ); //this atom
					   //cerr << "SC DEBUG: moving atom " << a << endl;
					   id.push_back( a ) ;//id a goes on the list
					   oldatom.push_back( newstructure.atom.at( a ) ); // atom a goes on the list
				   }
			   }
			   tryc = oldc;
			   tryatom = oldatom;
			   squadron.members = id; //squadron is a cluster whose members are all the moving atoms together
			   //newstructure.formcluster( squadron ); //generate the geometry of squadron
			   newstructure.newformcluster( squadron ); //generate the geometry of squadron USING NEW WRAPPING FUNCTION
			   
			   //statistics block!
			   int groupSize = movingCluster.size(); //count of group size;
			   if ( groupSize > groupsMade.size() -1 ){
				   int nToAdd = 1 + groupSize - groupsMade.size();
				   for ( int z = 0 ; z < nToAdd ; z++ ){
					   groupsMade.push_back( 0 );
					   groupsAccepted.push_back( 0 );
				   }
					//arrays are now appropriately sized			   
			   }
			   groupsMade.at( groupSize ) += 1; //keep tally
			   //cerr << "Groups of size " << groupSize << " made : " << groupsMade.at( groupSize ) << endl;	
			   
		   }
		   else{
			   //whicho is just a cluster id anyway
			   oldc.push_back(  newstructure.cluster.at( whicho ) ); //oldc contains one cluster, whicho
			   tryc = oldc; //copy over
			   movingCluster.push_back( whicho ); //one moving cluster, id is whicho
			   id = oldc.at(0).members; //the atom list is the list of members of whicho
			   for ( int t = 0 ; t < id.size() ; t++ ){
				   oldatom.push_back( newstructure.atom.at( id.at( t ) ) ); //list contains the moving atoms
			   }
			   tryatom = oldatom;
			   
			   squadron = oldc.at( 0 ); //squadron IS this cluster
		   }
		   
		   bool clusterf = false;
		   //to deal with problematic large size clusters: if squadron is problematic, reject forthwith
		   if ( squadron.problematic ){
			   rejected++;
			   cerr << "Rejecting PROBLEMATIC (oversized) cluster." << endl;
			   clusterf = true;
		   }
		  
		  
		  //let's get the energy associated with just the moving atoms at the start
		  double e_before = mc_moving_energy( id, newstructure ); //this is OK because uses id
		  double e_after = 0.;
		  
		  //now choose the move type and make it
		  if ( clusterf ){
			  bool wow = true; //placeholder thing :)
		  } //do nothing!
		  else if (use_small_move){
			  //select the move type
			  double totalw = bigprob + smallprob; // probability weight range
			  double selector = getRandom() * totalw; // a number in this range
			  if ( selector < bigprob ){
				  //mcbigrandom( trycluster, tryatom, newstructure );
				  mcbigrandom( squadron, tryatom, newstructure );
				  nbig++;
			  }
			  else{
				  //mcsmallrandom( trycluster, tryatom, newstructure, smallmovesize );
				  mcsmallrandom( squadron, tryatom, newstructure, smallmovesize );
				  nsmall++;
			  }
		  }
		  else{
			  //big move: put that cluster of atoms into a completely random location
			  //mcbigrandom( trycluster, tryatom, newstructure );
			  mcbigrandom( squadron, tryatom, newstructure );
			  nbig++;
		  }
		  
		  //steric test: can I put these atoms without a serious clash?
		  bool badclash = false;
		  badclash = clusterf; // already broken!
		  for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
				if ( badclash ) break; // one clash is enough;
				badclash = mcinsertclash( tryatom.at( thisat ), newstructure, id ); // use overloaded version with ignore list
				//works because uses tryatom and id, no problem
		  }			  
		  //now using a modified version of the acceptance logic from insert...
		  if ( badclash ){
				//rejecting this attempt
				rejected++;
				clashrejected++;
				//cerr << "Failed move attempt " << tried << " (failure " << rejected << ")." << endl;
				//okay now - we make no changes to newstructure itself
				//just abandon the acluster and the tryatom
		  }
		  else{
			    //accepting this attempt on steric grounds - not tested energy yet
				//need to put atoms into atom array
				//cluster into cluster array
				//atoms into grid
				//new logic: replace all clusters in movingCluster list, one or many
				//FIRST update the atoms; THEN reform the cluster geometries
				
				for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					//remove the current atom id from the cell grid
					//put the tryatom into the structure atom array
					//put the atom into the cell grid
					int theid = id.at( thisat );
					newstructure.gridremove( theid ); // out of grid
					newstructure.atom.at( theid ) = tryatom.at( thisat ); // replace atom info
					newstructure.gridreplace( theid ); // and put it back in its new place
				}
				if ( isSC ){
					//re-form each moving cluster from its atom positions
					for ( int t = 0 ; t < movingCluster.size() ; t++ ){
						newstructure.formcluster( tryc.at( t ) ); // reset the cluster geometry in tryc USING ORIGINAL SMALL CLUSTER ROUTINE
						//formcluster feeds off atom.pos which we reset in the loop above
						int c = movingCluster.at( t );
						newstructure.cluster.at( c ) = tryc.at( t ); // update this cluster geometry into the main list
					}
					
				}
				else{
					newstructure.cluster.at(whicho) = squadron; //squadron is the moving entity
				}
				
			}	//end of steric test    
			
			//catch up on the new overlap status here...
			if ( doOverlaps){
				removeFromOverlap( movingCluster, overlapArray ); //this takes the members of movingCluster out of overlaps
				addToOverlap( movingCluster, newstructure, overlapArray ); //adds back in again using newstructure
			}
			//we will use this for isSC checking
			
			bool goodstructure= !badclash;
			//in full; carry out energy test here, also isSC link suppression
			//if passed; put atoms into structure		
			//if failed; remove atoms from newstructure, replace with the versions from structure
			//also cluster
			
			//intervene here if isSC for link supression
			if ( goodstructure && isSC ){
				//how many new links does the moving cluster form in newstructure?
				int newLinks = countEdges( movingCluster, overlapArray );
				double pp = 1.; //probability of this being good in group selection...
				for ( int l = 0 ; l < newLinks; l++ ){
					pp *= ( 1. - pLink );
				}
				
				cerr << "nL: " << newLinks << " p!L: " << pp << " ";
				
				double dieroll = getRandom();
				if ( dieroll > pp ){
					//reject!
					cerr << "Roll: " << dieroll << " , rejecting." << endl;
					goodstructure = false; //use this to say don't accept move
					rejected++;
					linkrejected++;
				}
				else{
					cerr << "Roll: " << dieroll << " , good; ";
				}
				
			}
			
			
			bool goodenergy = false;
			if ( goodstructure ){
				//cerr << "In energy test loop." << endl;
				//run the energy function on newstructure
				//tryenergy = mcenergy( newstructure );
				e_after = mc_moving_energy( id, newstructure );
				//cerr << "E: " << fixed << setw(10) << tryenergy << " ";
				//Metropolis!
				//double echange = tryenergy - oldenergy;
				double echange = e_after - e_before;
				cerr << "dE: " << fixed << setw(10) << echange << " ";
				//cerr << "Move-E-Before: " << e_before << " Move-E-After: " << e_after << " New-dE: " << move_echange << " ";
				// auto accept negative change
				if ( echange < 0. ){
					goodenergy = true;
					accepted++;
					cerr << "Accepting." << endl;
				}
				else{
					echange *= ( 1000.0/(mct*gasconst) ) ; //scaling to kJ/mol to match potential definition
					double Metro = exp( -1.0*echange );
					cerr << "Met: " << Metro << " ";
					double dieroll = getRandom();
					if ( dieroll < Metro ){
						goodenergy = true;
						accepted++;
						cerr << "Roll: " << dieroll << " , accepting." << endl;
					}
					else{
						goodenergy = false;
						cerr << "Roll: " << dieroll << " , rejecting." << endl;
						rejected++;
					}
				}
				
			}
			
			//for now: put atoms and cluster into structure as well
			if ( goodstructure && goodenergy ){
				//the move is accepted for real!

				//if tracking 3s, do the before/after calculation here
				//because I might need both (old)structure and newstructure info! 
				//I think it's ok but let's not take risks
				if ( track3s ){
					//firstly, get set B:
					setB = SCofX ( whicho, overlapArray );
					
					//now, get the common and disjoint:
					commonSet( setA, setB, disA, disB );
					//we are doing this to create disA and disB
					//and discarding the common return as not needed.
					
					//cluster-holding arrays:
					vector< vector< int > > setAclusters = SCinY( setA, savedOA ); //clusters in A using saved overlap version
					vector< vector< int > > disAclusters = SCinY( disA, overlapArray ); //clusters in disA using updated overlap version
					vector< vector< int > > setBclusters = SCinY( setB, overlapArray ); //clusters in B using updated overlap version
					vector< vector< int > > disBclusters = SCinY( disB, savedOA ); //clusters in disB using saved overlap version
					//note we expect setA and setB to have only one entry, but the logic doesn't care
					
					//tally up the number of clusters of size 3 of each of the four types:
					setA3s = count3s( setAclusters, structure, savedOA );
					setB3s = count3s( setBclusters, newstructure, overlapArray );
					disA3s = count3s( disAclusters, newstructure, overlapArray );
					disB3s = count3s( disBclusters, structure, savedOA );
					
					//now tally the types of gain and loss;
					//If present in setA but not disA: Loss By Disassembly
					//if present in disA but not setA: Gain By Disassembly
					//if present in setB but not disB: Gain By Assembly
					//if present in disB but not setB: Loss By Assembly
					//net gain: GBA + GBD - LBA - LDB
					
					//NEW this count actually depends on whether disA, disB or both are null
					//where to introduce distinction?
					//most direct is to do it outside;
					//but easiest logic is to do it within;
					//try the easy way first
					//let's set some state cases outside for easy testing within
					bool nullDisA = false;
					bool nullDisB = false;
					if ( disA.size() == 0 ){
						nullDisA = true;
					}
					if ( disB.size() == 0 ){
						nullDisB = true;
					}
					
					
					
					for ( int type = 0 ; type < 4 ; type++ ){
						int dA = setA3s.at( type ) - disA3s.at( type );
						int dB = setB3s.at( type ) - disB3s.at( type );
						int net = setB3s.at( type ) + disA3s.at( type ) - setA3s.at( type ) - disB3s.at( type );
						//net is the number of this type AFTER less the number BEFORE, i.e. delta i -> j
						tally3s.at( type ) += net;
						//DEBUG flagging
						if ( false && net != 0 ){
							cerr << endl << "3-tracking: change of " << net << " in type " << type << " with dA " << dA << " dB " << dB << endl;
						}
						
						if ( nullDisA && nullDisB ){
							//make no counts, no change!
							continue;
						}
						if ( dA > 0 ){
							if ( nullDisA ){
								LBA.at( type ) += dA; //A moved bodily to join B', leaving no A' behind
							}
							else{
								LBD.at( type ) += dA;
							}
						}
						else if ( dA < 0 ){
							GBD.at( type ) -= dA; //because we want the GBD count to be positive :)
						}
						if ( dB > 0 ){
							if ( nullDisB ){
								GBD.at( type ) += dB; //C left A and became B, joining no B'
							}
							else{
								GBA.at( type ) += dB;
							}
						}
						else if ( dB < 0 ){
							LBA.at( type ) -= dB; //because we want the LBA count to be positive :)
						}

					}	
					
				}

				//feed atoms back into structure
				//also clusters
				//for isSC, cluster replacement is a loop over movingCluster list
				//structure.cluster.at(whichc) = trycluster; // stick it back in
				for ( int t = 0 ; t < movingCluster.size() ; t++ ){
					int c = movingCluster.at( t );
					structure.cluster.at( c ) = newstructure.cluster.at( c );
				}
				
				for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					//remove the current atom id from the cell grid
					//put the tryatom into the structure atom array
					//put the atom into the cell grid
					int theid = id.at( thisat );
					structure.gridremove( theid ); // out of grid
					structure.atom.at( theid ) = tryatom.at( thisat ); // replace atom info
					structure.gridreplace( theid ); // and put it back in its new place
				}
				
				//overlapArray is correct as calculated above using newstructure
				
				tryenergy = oldenergy + e_after - e_before;
				oldenergy = tryenergy;
				
				if ( isSC ){
					int groupSize = movingCluster.size(); //count of group size;
					groupsAccepted.at( groupSize ) += 1; //keep tally	
				}
				
					
			}
			else{
				//this is the rejection step where everything is reset
				
				//for isSC, cluster replacement is a loop over movingCluster list
				for ( int t = 0 ; t < movingCluster.size() ; t++ ){
					int c = movingCluster.at( t );
					newstructure.cluster.at( c ) = structure.cluster.at( c );
				}
				//newstructure.cluster.at(whichc) = oldcluster; // stick it back in
				for ( int thisat = 0 ; thisat < tryatom.size(); thisat++){
					//remove the current atom id from the cell grid
					//put the tryatom into the structure atom array
					//put the atom into the cell grid
					int theid = id.at( thisat );
					newstructure.gridremove( theid ); // out of grid
					newstructure.atom.at( theid ) = oldatom.at( thisat ); // replace atom info
					newstructure.gridreplace( theid ); // and put it back in its new place
				}

				if ( doOverlaps){
					removeFromOverlap( movingCluster, overlapArray ); //this takes the members of movingCluster out of overlaps
					addToOverlap( movingCluster, structure, overlapArray ); //adds back in again using structure
				}
						
				tryenergy = oldenergy; //unnecessary but symmetrical
			}
			
			if ( dolog && ( ( tried % logfreq ) == 0 ) ){
				cerr << "Outputting to logfile." << endl;
				logstream << tried << " " << oldenergy << " " << accepted << " " << clashrejected << " " << linkrejected << " " << rejected << " ";
				if ( doCollective ){
					logstream << "Collective: ";
					for ( int z = 1 ; z < groupsMade.size() ; z++ ){
						logstream << z << ":" << groupsMade.at(z) << ":" << groupsAccepted.at(z) << " ";
					}
				}
				
				logstream << endl;	
				
				//now log 3s into their own stream if we used that option
				if ( track3s ){
					//output format:
					//Iteration = tried :
					//For types 1 to 4:
					//total = tally3s , GBA, GBD, LBA, LBD :
					log3stream << tried;
					for ( int t = 0 ; t < 4 ; t++ ){
						log3stream << " : " << tally3s.at(t) << " ";
						log3stream << GBA.at(t) << " " << GBD.at(t) << " " << LBA.at(t) << " " << LBD.at(t);
					}
					log3stream << endl;
				}
						
			}
			 
		    if (  (tried % mcfreq ) == 0 ){
				cerr << "Reporting structure " << tried << endl;
				int width=8;
				if ( mctrials >= 1e8 ){
					width = 3 + log10( mctrials );
				}
				
				string framename = mcfilename( tried, width );
				stringstream titles;
				titles << "MC frame " << tried;
				//structure.writextl( framename, titles.str(), false );
				//string cifframename = framename+".cif";
				cerr << "Writing " << framename << endl;
				structure.writecif( framename, titles.str() );
				
				if ( doRDF ){
					//RDF calculation and output here
					int nel = structure.element.size();
					structure.initialiseRDF( RDFbin, RDFmax, nel);
					structure.getRDF( RDFbin, RDFmax );
					structure.reportRDF( framename ); // use MC frame base name as RDF base name
				}

				if (doOverlaps ){
					findOverlap( structure, overlapArray );
					supercluster = SCfromOA( overlapArray );
					//overlapHistogram = getHisto( overlapArray );
					//int np = structure.poly.size();
					//metalHistogram = metalHisto( overlapArray, np );
					  //make the filter array
					  overlapFilter = getFilter( structure, overlapArray );
					  //name an xtl file
					  //stringstream lapstream;
					  //lapstream << framename << "overlap.xtl";
					  //string aname = lapstream.str();
					  //title string
					  stringstream tstream;
					  tstream << framename << " overlap-filtered file";
					  string t = tstream.str();
					  //output a filtered xtl file
					  //structure.filteredxtl( aname, t, overlapFilter );
					  //and a filtered cif file
					  stringstream blapstream;
					  blapstream << framename << "overlap.cif";
					  string cname = blapstream.str();
					  //output a filtered cif file
					  structure.filteredcif( cname, t, overlapFilter );
					  //and a histogram
					  /*
					  stringstream hstream;
					  hstream << framename << "histo.txt";
					  string hname = hstream.str();
					  writeHisto( hname, overlapHistogram);
					  stringstream mstream;
					  mstream << overlapname << "histo.metal.txt";
					  string mname = mstream.str();
					  writeHisto ( mname, metalHistogram );
					  */
				}

			}
		  
	  } //end of mcrunning loop
	  
	  
	  
	  endmctime = time(0);
	  cerr << "End MCRUN time:" << endmctime << endl;
	  cerr << "Elapsed run time " << endmctime - startmctime << endl;
	  cerr << "SEED was: " << seed << endl;
	  cerr << "MCRUN stats for you:" << endl;
	  cerr << "Accepted: " << accepted << endl;
	  cerr << "Clash-rejected: " << clashrejected << endl;
	  cerr << "Link-rejected: " << linkrejected << endl;
	  cerr << "Total rejected: " << rejected << endl;
	  if ( use_small_move){
		  cerr << "Big and small moves: " << nbig << " , " << nsmall << endl;
	  }
	  
	  if ( doCollective ){
		  if ( groupsMade.size() > 1 ){
			  cerr << "Collective move statistics report:" << endl;
			  for ( int z = 1 ; z < groupsMade.size() ; z++ ){
				  cerr << " Size " << z << " Made: " << groupsMade.at(z) << " Accepted: " << groupsAccepted.at(z) << endl;
			  }
			  cerr << "End of collective move statistics." << endl;
		  }
	  }
	  
	  cerr << "Thank you and goodnight." << endl;
	  
	  if ( dolog ){
		logstream << "End MCRUN time:" << endmctime << endl;
		logstream << "Elapsed run time " << endmctime - startmctime << endl;
		logstream << "SEED was: " << seed << endl;
		logstream << "MCRUN stats for you:" << endl;
		logstream << "Accepted: " << accepted << endl;
		logstream << "Clash-rejected: " << clashrejected << endl;
		logstream << "Link-rejected: " << linkrejected << endl;
		logstream << "Total rejected: " << rejected << endl;
		if ( use_small_move){
			logstream << "Big and small moves: " << nbig << " , " << nsmall << endl;
		}
		
		if ( doCollective ){
			if ( groupsMade.size() > 1 ){
				logstream << "Collective move statistics report:" << endl;
				for ( int z = 1 ; z < groupsMade.size() ; z++ ){
					logstream << " Size " << z << " Made: " << groupsMade.at(z) << " Accepted: " << groupsAccepted.at(z) << endl;
				}
				logstream << "End of collective move statistics." << endl;
			}
		}		
		
		logstream << "Thank you and goodnight." << endl;
		//now log 3s into their own stream if we used that option
		if ( track3s ){
			//output format:
			//Iteration = tried :
			//For types 1 to 4:
			//total = tally3s , GBA, GBD, LBA, LBD :
			log3stream << tried;
			for ( int t = 0 ; t < 4 ; t++ ){
				log3stream << " : " << tally3s.at(t) << " ";
				log3stream << GBA.at(t) << " " << GBD.at(t) << " " << LBA.at(t) << " " << LBD.at(t);
			}
			log3stream << endl;
		}
		
			  
	  }
	  
	  
  }
  
  if ( dolog ) logstream.close();
  if ( track3s ) log3stream.close();
 
  //Step 5: file output
  if ( do_output_structure && !do_mcrun ){
	  //because mcrun does its own structure output thing
	  structure.writecif( output_structure_name, title );
  }
  if ( do_output_bonding ){
       writebonding( output_bonding_name, bondline ); // method is in Geometry
  }
  if ( do_output_poly ){
       structure.writepol( output_poly_name );
  }
  if ( do_output_clusters ){
       structure.writeclusters( output_clusters_name );
  }  
  if ( do_output_angles ){
       structure.writeangles( output_angles_name );
  }  
  if ( do_output_bonds ){
       structure.writebondlengths( output_bonds_name );
  }
  if ( do_output_mismatches ){
       structure.writemismatches(output_mismatches_name );      
  }
  if (doRDF){
	  int nel = structure.element.size();
	  structure.initialiseRDF( RDFbin, RDFmax, nel);
	  structure.getRDF( RDFbin, RDFmax );
	  structure.reportRDF( rdfbasename );
  }
  if (doOverlaps && !do_mcrun){
	  findOverlap( structure, overlapArray );
	  supercluster = SCfromOA( overlapArray );
	  //overlapHistogram = getHisto( overlapArray );
	  //int np = structure.poly.size();
	  //metalHistogram = metalHisto( overlapArray, np );
	  //make the filter array
	  overlapFilter = getFilter( structure, overlapArray );
	  //name an xtl file
	  //stringstream lapstream;
	  //lapstream << overlapname << ".xtl";
	  //string aname = lapstream.str();
	  //title string
	  stringstream tstream;
	  tstream << "overlap-filtered file";
	  string t = tstream.str();
	  //output a filtered xtl file
	  //structure.filteredxtl( aname, t, overlapFilter );
	  //and a filtered cif file
	  stringstream blapstream;
	  blapstream << overlapname << ".cif";
	  string cname = blapstream.str();
	  //output a filtered cif file
	  structure.filteredcif( cname, t, overlapFilter );
	  //and a histogram
	  /*
	  stringstream hstream;
	  hstream << overlapname << "histo.txt";
	  string hname = hstream.str();
	  writeHisto( hname, overlapHistogram);
	  stringstream mstream;
	  mstream << overlapname << "histo.metal.txt";
	  string mname = mstream.str();
	  writeHisto ( mname, metalHistogram );
	  */
  }


    cerr << "I am going to- or I am about to- die; either expression is correct." << endl;
    //cerr << "Consummatum est." << endl;
    exit(0); //final exit
} // END OF MAIN


