#include "MCcontrol.h"

int main(int argc, char *argv[]){
    
  cerr << "Welcome to phaseFFinder, analysing MOF simulation output." << endl;
  cerr << "Written by Stephen Wells at Bath Uni." << endl;
  cerr << endl;

  
  //cerr << "Args: " << argc << endl;
  string extraArgument;
  bool gotExtra = false;
  if ( argc == 1 ) {
     cerr << "No control filename given; seeking default file mcg.inp" << endl;
     inpfilename = "mcg.inp"; 
  }
  else{
     stringstream whatin;
     whatin << argv[1];
     inpfilename = whatin.str();
     cerr << "Reading input from file " << inpfilename << endl;
     
     if ( argc > 2 ){
		 stringstream fibble;
		 fibble << argv[2];
		 extraArgument = fibble.str();
		 cerr << "Additional argument: " << extraArgument << endl;
		 gotExtra = true;
	 }
     
  }
        
  //Step 1: parse input file
  bool inputokay = readcommands (inpfilename );
  if (inputokay){
     cerr << "Input okay, continuing." << endl;
  }
  else {
       cerr << "Input not found. Goodbye, cruel world." << endl;
       exit(1);
  }
  
  //Step 2: validate input file
  //do not use main validation routine
  //use only local validation:
  //I need a structure input and a bonding input
  
  
  //we shouldn't need any random thing but keep this for now...
  if ( !given_seed ){
	  seed = static_cast< long >( time(0) );
  }
  cerr << "Initiating Mersenne Twister with seed " << seed << endl;
  initialiseRandom( seed );

  //for now: no ligand logic check
  //will later divide clusters into Metal and Ligand based on containing metal atoms

  //using the structure input lines from main...
  
  if (!given_structure){
	  cerr << "Dying: we require structure input." << endl;
	  exit(1);
  }
  
  if ( input_structure_name == "$" ){
	  cerr << "Special structure input name: $" << endl;
	  if ( gotExtra ){
		  input_structure_name = extraArgument;
	  }
	  else{
		  cerr << "ERROR: $ calls for an additional filename argument on the command line." << endl;
		  exit(1);
	  }
  }
  
  
	bool cifok = inputstructure.readcif( input_structure_name );
	if ( !cifok ) {
		cerr << "Stopping execution due to invalid cif input." << endl;
		cerr << "I require flawless crystals." << endl;
		exit(1);     
	}
	if ( inputstructure.atom.size() == 0 ){
		cerr << "Problem - no atoms in input!" << endl;
		exit(1);
	}
	else {
       cerr << "Read " << inputstructure.atom.size() << " atoms." << endl;
	}
	bool isinit = inputstructure.initialise( gridmin);
	//do cell vectors, inverse vectors, and cartesian positions, also fill grid
	if ( !isinit ){
		cerr << "Sadly, we have choked on an unknown element. Please call an alchemist." << endl;
		exit(1); // die
	}


	if ( given_bond_input ){
		bool bok = readbonds( input_bonding_name , bondline );
		if ( !bok ) {
			cerr << "Stopping execution due to invalid bonding input. Better bondage please." << endl;
			exit(1);     
		}
		inputstructure.bondsintoatoms( bondline );
	}
	else{
		//die here without bonding!
		cerr << "Dying: we require bonding input." << endl;
		exit(1);
	}

	inputstructure.formbondlines( bondline ); // bondlines to output, also handles rigidity

	//okay, all bonding done
	inputstructure.allrigidcheck(); // set labels for Garibaldi later
    //reactive vertex labelling:
    inputstructure.setvirtual();
	
	//parse neighbours for poly specs
	if ( given_poly ){
		cerr << "Parsing polyhedra." << endl;
		inputstructure.parsepoly( polyspec );
	}
	cerr << "Found " << inputstructure.poly.size() << " polyhedra." << endl;

	//now the non-poly bond clusters
	//note cluster array already contains null entry for each poly!
	if ( given_bond ){ // note given bond is required even if we have given bond input... tidy later?
			vector< Cluster > candidate = inputstructure.candidatecluster( bondspec ); // initial bonding clusters
			cerr << "Found " << candidate.size() << " non-poly clusters." << endl;          
			vector< Cluster > goodcandidate;
			goodcandidate = inputstructure.Garibaldi( candidate ); // reunification

			//finally put into cluster and ghost!
			for ( int i = 0 ; i < goodcandidate.size() ; i++ ){
				inputstructure.cluster.push_back( goodcandidate.at(i) );
				inputstructure.ghost.push_back( goodcandidate.at(i) );
			}
			candidate.clear();
			goodcandidate.clear(); // just housekeeping.
	}
  
	cerr << "Found " << inputstructure.cluster.size() << " total clusters." << endl;

	inputstructure.prepclustersandghosts();
	//polys now exist as poly, as cluster, and as ghost
	//nonpolys exist as cluster and as ghost
	// poly-ghosts have perfect geometry
	//hey, for MC purposes, we should replace the imperfect read polys with their perfect ghosts!
	
	//label atoms by inclust! and isvertex
	inputstructure.labelvertices();
	//initial structure has defined bonding, cluster and poly geometry.
	//initial_structure goes into structure now ready to move.


  structure = inputstructure; // :) use structure subsequently for e.g. relax

  findOverlap( structure, overlapArray );

  //okay now we invoke the filtering process to identify cluster things
  vector< bool > isMetal, isLigand, isPrimary, isSecondary, isTertiary, hasDefect, isMMM;
  int nc = structure.cluster.size(); //how many clusters...
  isMetal.resize( nc );
  isLigand.resize( nc );
  isPrimary.resize( nc );
  isSecondary.resize( nc );
  isTertiary.resize( nc );
  hasDefect.resize( nc );
  isMMM.resize( nc );
  
  //preset the values to all false
  for ( int i = 0 ; i < nc ; i++ ){
	  isMetal.at(i) = false;
	  isLigand.at(i) = false;
	  isPrimary.at(i) = false;
	  isSecondary.at(i) = false;
	  isTertiary.at(i) = false;
	  hasDefect.at(i) = false;
	  isMMM.at(i) = false;
  }
  
  //loop over clusters;
  //see if we contain either metal or reactive atoms
  //if metal, label metal
  //if not metal but reactive, label ligand
  
  int nMetal=0, nLigand=0;
  for ( int i = 0 ; i < nc ; i++ ){
	  bool gotMetal = false;
	  bool gotReactive = false;
	  int na = structure.cluster.at(i).members.size(); //atoms in this cluster
	  for ( int j = 0 ; j < na ; j++ ){
		  int k = structure.cluster.at(i).members.at(j);
		  if ( structure.atom.at( k ).role == -1 ){
			  gotMetal = true;
		  }
		  else if ( structure.atom.at(k).role > 0 ){
			  gotReactive = true;
		  }
		  if ( gotMetal ) break; //finished if we find a metal
	  }
	  if ( gotMetal ){
		  isMetal.at(i) = true; //noticed
		  nMetal++;
	  }
	  else if ( gotReactive ){
		  isLigand.at(i) = true; //not metal but reactive
		  nLigand++;
	  }
  }
  
  cerr << "In progress: found " << nMetal << " metal clusters and " << nLigand << " ligand clusters." << endl;
  
  //phase F rules revision
  //Primary cases: M with at least two neighbours of which at least one is also M
  //Secondary cases: M or L attached to Primary
  //Tertiary cases: M attached to Secondary cases.
  
  //detect Primary cases:
  int nP = 0;
  for ( int i = 0 ; i < nc ; i++ ){
	  //use the oa array for neighbour listing
	  if ( overlapArray.at(i).size() < 2 ){
		  continue; //not enough neighbours
	  }
	  //nWithN++;
	  //count metal and ligand neighbours!
	  int nM = 0;
	  int nL = 0;
	  
	  for ( int j = 0 ; j < overlapArray.at(i).size() ; j++ ){
		  int k = overlapArray.at(i).at(j); //a neighbouring cluster
		  if ( isMetal.at(k) ) nM++;
		  if ( isLigand.at(k) ) nL++;
	  }
	  if ( isMetal.at(i) ){
		  if ( nM > 0 ) isPrimary.at(i) = true; //M in M-M-L or M-M-M but not L-M-L
		  if ( nM > 1 ) isMMM.at(i) = true; //M in M-M-M specifically
	  }

	  if ( isPrimary.at(i) ) nP++; //primary!
  }
  cerr << "In progress: found " << nP << " primary clusters." << endl;
  
  //loop again to detect Secondary cases
  int nS = 0;
  for ( int i = 0 ; i < nc ; i++ ){
	  //skip cases with no neighbours and skip cases which are already primary
	  if ( isPrimary.at(i) ) continue; // done
	  if ( overlapArray.at(i).size() < 1 ) continue; //no neighbours
	  //now see if I have any primary cases among my neighbours
	  for ( int j = 0 ; j < overlapArray.at(i).size() ; j++ ){
		  int k = overlapArray.at(i).at(j); //a neighbouring cluster
		  if ( isPrimary.at(k) ){
			   isSecondary.at(i) = true;
			   nS++;
			   break; //leaving!
		  }
	  }
	  //done detecting secondary!
  }
  cerr << "In progress: found " << nS << " secondary clusters." << endl;

  //and loop one more time detecting Tertiary!
  int nT = 0;
  for ( int i = 0 ; i < nc ; i++ ){
	  //skip cases with no neighbours and skip cases which are already primary
	  if ( isPrimary.at(i) ) continue; // done
	  if ( isSecondary.at(i) ) continue; // done	  
	  if ( isLigand.at(i) ) continue; // done
	  if ( overlapArray.at(i).size() < 1 ) continue; //no neighbours
	  //now see if I have any primary cases among my neighbours
	  for ( int j = 0 ; j < overlapArray.at(i).size() ; j++ ){
		  int k = overlapArray.at(i).at(j); //a neighbouring cluster
		  if ( isPrimary.at(k) || isSecondary.at(k) ){
			   isTertiary.at(i) = true;
			   nT++;
			   break; //leaving!
		  }
	  }
	  //done 
  }
  cerr << "In progress: found " << nT << " tertiary clusters." << endl;



  
  //now we filter not-phase-F things out of overlapArray
  for ( int i = 0 ; i < nc ; i++ ){
	  if ( isPrimary.at(i) ) continue;
	  if ( isSecondary.at(i) ) continue;
	  if ( isTertiary.at(i) ) continue;
	  //now...
	  removeFromOverlap( i, overlapArray ); //filtering ungood things out of oa
  }
  
  
  
  //now we build the superclusters from the filtered overlapArray
  //because we need the superclusters to histogram the cluster sizes!
  supercluster = SCfromOA( overlapArray );
  
  //further tuning: cycle over the superclusters.
  //detect whether each contains an M-M-M motif (metal with two M overlaps)
  //if not:
  //remove entities from overlap array
  //after loop: reform superclusters.
  for ( int i = 0 ; i < supercluster.size() ; i++ ){
	  bool gotMMM = false;
	  for ( int j = 0 ; j < supercluster.at(i).size() ; j++ ){
		  int k = supercluster.at(i).at(j); //a cluster in this SC
		  if ( isMMM.at(k) ){
			  gotMMM = true;
			  break; //only need one
		  }
	  }
	  if ( gotMMM ) continue; //this cluster is fine, take no action
	  cerr << "A supercluster of size " << supercluster.at(i).size() << " lacks any M-M-M motif and is removed." << endl;
	  //if we're here, this SC must be removed for lacking an MMM
	  for ( int j = 0 ; j < supercluster.at(i).size() ; j++ ){
		  int k = supercluster.at(i).at(j); //a cluster in this SC
		  removeFromOverlap( k, overlapArray );
	  }	  
	  
  }
  supercluster = SCfromOA( overlapArray ); //newly reformed superclusters
  
  
  
  //then finally output the phaseA filtered structure (given structure name or built from input name)
  cerr << "DEBUG scan of superclusters: " << endl;
  cerr << "Found " << supercluster.size() << " superclusters. " << endl;
  int biggestSize= 0;
  for ( int i = 0 ; i < supercluster.size() ; i++ ){
	  //cerr << "Supercluster " << i << " has size " << supercluster.at(i).size() << endl;
	  if ( supercluster.at(i).size() > biggestSize ) biggestSize = supercluster.at(i).size();
  }
  cerr << "Largest supercluster: " << biggestSize << endl;
  
  //and report the histogram of cluster sizes after checking largest cluster size
  vector< int > bin;
  vector< int > count;
  vector< int > cumul;
  //int totalInPhaseA = 0;
  
  int newsize = biggestSize - 2;
  if ( newsize < 1 ) newsize = 1; //just to avoid crashes!
  
  bin.resize( newsize); //don't count 1 and 2 as sizes!
  count.resize( newsize );
  cumul.resize( newsize );
  for ( int i = 3; i < biggestSize +1 ; i++ ){
	  bin.at( i-3 ) = i; //bin label
	  count.at( i-3 ) = 0; //zero out
  }
  for ( int i = 0 ; i < supercluster.size() ; i++ ){
	  int n = supercluster.at(i).size();
	  if ( n < 3 ) continue; //ignore scraps
	  count.at( n-3 )++;
	  //totalInPhaseA += n;
  }
  //cumul should hold the number of entities in superclusters with given size or greater
  for ( int i = cumul.size() - 1 ; i > -1 ; i-- ){
	  if ( i == cumul.size() - 1 ){
		  cumul.at(i) = bin.at(i) * count.at(i) ; //bin size times number this size
	  }
	  else{
		  cumul.at(i) = cumul.at( i+1 ) + ( bin.at(i) * count.at(i) );
	  }
  }



  cerr << "Histogram of phase F precursor cluster sizes." << endl;
  //cout << "0 " << totalInPhaseA << endl; //using zero bin as total counter
  for ( int i = 3; i < biggestSize +1 ; i++ ){
	  cout << bin.at( i-3 ) << " "; //bin label
	  cout << count.at( i-3 ) << " ";
	  cout << cumul.at( i-3 ) << endl;
  }
    
  stringstream firstnamestream, secondnamestream, thirdnamestream;
  
  string firstname, secondname, thirdname;
  
  firstnamestream << input_structure_name << ".phaseF.cif"; //append for filtered
  secondnamestream << input_structure_name << ".phaseF.largest.cif"; //superfiltered
  thirdnamestream << input_structure_name << ".phaseF.histogram"; //cluster histogram info
  firstname = firstnamestream.str();
  secondname = secondnamestream.str();
  thirdname = thirdnamestream.str();

  //now, first wave of cif output:
  //only guys who are now in the overlap array
  overlapFilter = getFilter( structure, overlapArray );
  cerr << "Outputting filtered cif showing only phaseF precursor clusters to " << firstname << endl;
  structure.filteredcif( firstname, input_structure_name, overlapFilter ); //should output the phaseA.cif
  //second wave of cif output:
  //take everything except the biggest cluster(s) out of the overlap array
  for ( int i = 0 ; i < supercluster.size() ; i++ ){
	  int n = supercluster.at(i).size();
	  if ( n < ( biggestSize -2 ) ){
		  //cerr << "Removing non-biggest cluster of size " << n << " from array..." << endl;
		  for ( int j = 0 ; j < n ; j++ ){
			  int k = supercluster.at(i).at(j);
			  removeFromOverlap( k, overlapArray );
		  }
	  }
	  else{
		  cerr << "Retaining cluster of size " << n << " in array..." << endl;
	  }
  }  
  //now it's filtered
  cerr << "Outputting filtered cif showing only the largest phaseF precursor clusters to " << secondname << endl;
  overlapFilter = getFilter( structure, overlapArray );
  structure.filteredcif( secondname, input_structure_name, overlapFilter ); //should output the phaseA.largest.cif  
  //third wave...
  cerr << "Outputting histogram of phaseF precursor cluster sizes to " << thirdname << endl;
  ofstream histout( thirdname.c_str() ); //histogram output now
  //histout << "0 " << totalInPhaseA << endl; //using zero bin as total counter
  for ( int i = 3; i < biggestSize +1 ; i++ ){
	  histout << bin.at( i-3 ) << " "; //bin label
	  histout << count.at( i-3 ) << " ";
	  histout << cumul.at( i-3 ) << endl;
  }
  histout.close();

  cerr << "Consummatum est." << endl;
  exit(0); //final exit
} // END OF MAIN


