#include "MCcontrol.h"

int main(int argc, char *argv[]){
    
  cerr << "Welcome to size3Finder, analysing MOF simulation output." << endl;
  cerr << "Written by Stephen Wells at Bath Uni." << endl;
  cerr << endl;

  
  //cerr << "Args: " << argc << endl;
  string extraArgument;
  bool gotExtra = false;
  if ( argc == 1 ) {
     cerr << "No control filename given; seeking default file mcg.inp" << endl;
     inpfilename = "mcg.inp"; 
  }
  else{
     stringstream whatin;
     whatin << argv[1];
     inpfilename = whatin.str();
     cerr << "Reading input from file " << inpfilename << endl;
     
     if ( argc > 2 ){
		 stringstream fibble;
		 fibble << argv[2];
		 extraArgument = fibble.str();
		 cerr << "Additional argument: " << extraArgument << endl;
		 gotExtra = true;
	 }
     
  }
        
  //Step 1: parse input file
  bool inputokay = readcommands (inpfilename );
  if (inputokay){
     cerr << "Input okay, continuing." << endl;
  }
  else {
       cerr << "Input not found. Goodbye, cruel world." << endl;
       exit(1);
  }
  
  //Step 2: validate input file
  //do not use main validation routine
  //use only local validation:
  //I need a structure input and a bonding input
  
  
  //we shouldn't need any random thing but keep this for now...
  if ( !given_seed ){
	  seed = static_cast< long >( time(0) );
  }
  cerr << "Initiating Mersenne Twister with seed " << seed << endl;
  initialiseRandom( seed );

  //for now: no ligand logic check
  //will later divide clusters into Metal and Ligand based on containing metal atoms

  //using the structure input lines from main...
  
  if (!given_structure){
	  cerr << "Dying: we require structure input." << endl;
	  exit(1);
  }
  
  if ( input_structure_name == "$" ){
	  cerr << "Special structure input name: $" << endl;
	  if ( gotExtra ){
		  input_structure_name = extraArgument;
	  }
	  else{
		  cerr << "ERROR: $ calls for an additional filename argument on the command line." << endl;
		  exit(1);
	  }
  }
  
  
	bool cifok = inputstructure.readcif( input_structure_name );
	if ( !cifok ) {
		cerr << "Stopping execution due to invalid cif input." << endl;
		cerr << "I require flawless crystals." << endl;
		exit(1);     
	}
	if ( inputstructure.atom.size() == 0 ){
		cerr << "Problem - no atoms in input!" << endl;
		exit(1);
	}
	else {
       cerr << "Read " << inputstructure.atom.size() << " atoms." << endl;
	}
	bool isinit = inputstructure.initialise( gridmin);
	//do cell vectors, inverse vectors, and cartesian positions, also fill grid
	if ( !isinit ){
		cerr << "Sadly, we have choked on an unknown element. Please call an alchemist." << endl;
		exit(1); // die
	}


	if ( given_bond_input ){
		bool bok = readbonds( input_bonding_name , bondline );
		if ( !bok ) {
			cerr << "Stopping execution due to invalid bonding input. Better bondage please." << endl;
			exit(1);     
		}
		inputstructure.bondsintoatoms( bondline );
	}
	else{
		//die here without bonding!
		cerr << "Dying: we require bonding input." << endl;
		exit(1);
	}

	inputstructure.formbondlines( bondline ); // bondlines to output, also handles rigidity

	//okay, all bonding done
	inputstructure.allrigidcheck(); // set labels for Garibaldi later
    //reactive vertex labelling:
    inputstructure.setvirtual();
	
	//parse neighbours for poly specs
	if ( given_poly ){
		cerr << "Parsing polyhedra." << endl;
		inputstructure.parsepoly( polyspec );
	}
	cerr << "Found " << inputstructure.poly.size() << " polyhedra." << endl;

	//now the non-poly bond clusters
	//note cluster array already contains null entry for each poly!
	if ( given_bond ){ // note given bond is required even if we have given bond input... tidy later?
			vector< Cluster > candidate = inputstructure.candidatecluster( bondspec ); // initial bonding clusters
			cerr << "Found " << candidate.size() << " non-poly clusters." << endl;          
			vector< Cluster > goodcandidate;
			goodcandidate = inputstructure.Garibaldi( candidate ); // reunification

			//finally put into cluster and ghost!
			for ( int i = 0 ; i < goodcandidate.size() ; i++ ){
				inputstructure.cluster.push_back( goodcandidate.at(i) );
				inputstructure.ghost.push_back( goodcandidate.at(i) );
			}
			candidate.clear();
			goodcandidate.clear(); // just housekeeping.
	}
  
	cerr << "Found " << inputstructure.cluster.size() << " total clusters." << endl;

	inputstructure.prepclustersandghosts();
	//polys now exist as poly, as cluster, and as ghost
	//nonpolys exist as cluster and as ghost
	// poly-ghosts have perfect geometry
	//hey, for MC purposes, we should replace the imperfect read polys with their perfect ghosts!
	
	//label atoms by inclust! and isvertex
	inputstructure.labelvertices();
	//initial structure has defined bonding, cluster and poly geometry.
	//initial_structure goes into structure now ready to move.


  structure = inputstructure; // :) use structure subsequently for e.g. relax

  findOverlap( structure, overlapArray );

  //okay now we invoke the filtering process to identify phaseA cluster things
  vector< bool > isMetal, isLigand, isPrimary, isSecondary;
  int nc = structure.cluster.size(); //how many clusters...
  isMetal.resize( nc );
  isLigand.resize( nc );
  isPrimary.resize( nc );
  isSecondary.resize( nc );

  
  //preset the values to all false
  for ( int i = 0 ; i < nc ; i++ ){
	  isMetal.at(i) = false;
	  isLigand.at(i) = false;
	  isPrimary.at(i) = false;
	  isSecondary.at(i) = false;
  }
  
  //loop over clusters;
  //see if we contain either metal or reactive atoms
  //if metal, label metal
  //if not metal but reactive, label ligand
  
  int nMetal=0, nLigand=0;
  for ( int i = 0 ; i < nc ; i++ ){
	  bool gotMetal = false;
	  bool gotReactive = false;
	  int na = structure.cluster.at(i).members.size(); //atoms in this cluster
	  for ( int j = 0 ; j < na ; j++ ){
		  int k = structure.cluster.at(i).members.at(j);
		  if ( structure.atom.at( k ).role == -1 ){
			  gotMetal = true;
		  }
		  else if ( structure.atom.at(k).role > 0 ){
			  gotReactive = true;
		  }
		  if ( gotMetal ) break; //finished if we find a metal
	  }
	  if ( gotMetal ){
		  isMetal.at(i) = true; //noticed
		  nMetal++;
	  }
	  else if ( gotReactive ){
		  isLigand.at(i) = true; //not metal but reactive
		  nLigand++;
	  }
  }
  
  cerr << "In progress: found " << nMetal << " metal clusters and " << nLigand << " ligand clusters." << endl;
  
  //detect Primary cases:
  //anything with exactly two neighbours
  int nP = 0;
  for ( int i = 0 ; i < nc ; i++ ){
	  //use the oa array for neighbour listing
	  if ( overlapArray.at(i).size() == 2 ){
		  isPrimary.at(i) = true;
	  }

	  if ( isPrimary.at(i) ) nP++; //primary!
  }
  //cerr << "In progress: found " << nWithN << " clusters with neighbours." << endl;
  cerr << "In progress: found " << nP << " primary clusters." << endl;
  
  
  
  //loop again to detect Secondary cases
  //anything with exactly one neighbour which is Primary
  int nS = 0;
  for ( int i = 0 ; i < nc ; i++ ){

	  if ( overlapArray.at(i).size() != 1 ) continue; //no neighbours
	  int j = overlapArray.at(i).at(0); //only neighbour...
	  if ( isPrimary.at(j) ){
		  isSecondary.at(i) = true; // bound only to a Primary
		  nS++;
	  }
	  
	  //done detecting secondary!
  }
  cerr << "In progress: found " << nS << " secondary clusters." << endl;
  
  
  
  
  //now we filter not-size-3 things out of overlapArray
  for ( int i = 0 ; i < nc ; i++ ){
	  if ( isPrimary.at(i) ) continue;
	  if ( isSecondary.at(i) ) continue;
	  //now...
	  removeFromOverlap( i, overlapArray ); //filtering ungood things out of oa
  }

  
  //now we build the superclusters from the filtered overlapArray
  //because we need the superclusters to histogram the cluster sizes!
  supercluster = SCfromOA( overlapArray );
  
  cerr << "DEBUG scan of superclusters: " << endl;
  cerr << "Found " << supercluster.size() << " superclusters. " << endl;
  
  //count the number of these types:
  //M-M-M
  //M-M-L
  //M-L-M
  //L-M-L
  
  int nMMM = 0;
  int nMML = 0;
  int nMLM = 0;
  int nLML = 0;
  
  for ( int i = 0 ; i < nc ; i++ ){
	  cerr << "Examining cluster " << i+1 << " for category." << endl;
	  if ( !isPrimary.at(i) ) continue;
	  if ( overlapArray.at(i).size() != 2 ) continue; //some were stripped already!
	  int j = overlapArray.at(i).at(0);
	  int k = overlapArray.at(i).at(1);
	  if ( !isSecondary.at( j ) ) continue;
	  if ( !isSecondary.at(k) ) continue;
	  //in case of stripped
	  //so we're only looking at Primary cases with Secondary neighbours = true clusters of size 3
	  if ( isLigand.at(i) ){
		  nMLM ++; //if centre is ligand, neighbours must be M
		  //this is the "ligand capped with two metals" case
	  }
	  else if ( isMetal.at(i) ){
		  if ( isMetal.at(j) && isMetal.at(k) ){
			  nMMM ++; //it's three metals
		  }
		  else if ( isLigand.at(j) && isLigand.at(k) ){
			  nLML ++; //metal with two ligands
		  }
		  else if (  ( isLigand.at(i) && isMetal.at(k) ) || ( isMetal.at(j) && isLigand.at(k) ) ){
			  nMML ++; //mixed case
		  }
		  
	  }
  }  
  
  cerr << "Finished counting clusters: " << endl;
  cerr << "nMMM nMML nMLM nLML ";
  cerr << nMMM << " ";
  cerr << nMML << " ";
  cerr << nMLM << " ";
  cerr << nLML << endl;  
    
    
  stringstream firstnamestream, thirdnamestream;
  string firstname, thirdname;
  
  firstnamestream << input_structure_name << ".size3.cif"; //append for filtered
  thirdnamestream << input_structure_name << ".size3.histogram"; //cluster histogram info
  firstname = firstnamestream.str();
  thirdname = thirdnamestream.str();

  //now, first wave of cif output:
  //only guys who are now in the overlap array
  overlapFilter = getFilter( structure, overlapArray );
  cerr << "Outputting filtered cif showing only size 3 precursor clusters to " << firstname << endl;
  structure.filteredcif( firstname, input_structure_name, overlapFilter ); //should output the phaseA.cif
 
  //third wave...
  cerr << "Outputting histogram of size-3 precursor cluster sizes to " << thirdname << endl;
  ofstream histout( thirdname.c_str() ); //histogram output now
  //report number of different cluster types
  histout << "nMMM nMML nMLM nLML ";
  histout << nMMM << " ";
  histout << nMML << " ";
  histout << nMLM << " ";
  histout << nLML << endl;
  histout.close();

  cerr << "Consummatum est." << endl;
  exit(0); //final exit
} // END OF MAIN


