#ifndef __BASIC_UTILS_INCLUDED__
#define __BASIC_UTILS_INCLUDED__

#include <iostream>
#include <fstream>
#include <iomanip>
#define _USE_MATHS_DEFINES
#include <cmath>
#include <cstdlib>
#include <cstring>
#include <string.h>
#include <sstream>
#include <vector>
#include <list>
#include <map>
#include <bitset>
#include <typeinfo>
#include <algorithm>
#include <ctime> 
#include <new>

using namespace std;

const double mytwopi = 2.0 * M_PI;
const double radtodeg = 360.0/mytwopi;
const double degtorad = 1.0/radtodeg;

/* 
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.

   Before using, initialize the state by using init_genrand(seed)  
   or init_by_array(init_key, key_length).

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.
   Copyright (C) 2005, Mutsuo Saito
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote 
        products derived from this software without specific prior written 
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


   Any feedback is very welcome.
   http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html
   email: m-mat @ math.sci.hiroshima-u.ac.jp (remove space)
*/

/* initializes mt[N] with a seed */
void init_genrand(unsigned long s);

/* initialize by an array with array-length */
/* init_key is the array for initializing keys */
/* key_length is its length */
/* slight change for C++, 2004/2/26 */
void init_by_array(unsigned long init_key[], int key_length);

/* generates a random number on [0,0xffffffff]-interval */
unsigned long genrand_int32(void);

/* generates a random number on [0,0x7fffffff]-interval */
long genrand_int31(void);

/* These real versions are due to Isaku Wada, 2002/01/09 added */
/* generates a random number on [0,1]-real-interval */
double genrand_real1(void);

/* generates a random number on [0,1)-real-interval */
double genrand_real2(void);

/* generates a random number on (0,1)-real-interval */
double genrand_real3(void);

/* generates a random number on [0,1) with 53-bit resolution*/
double genrand_res53(void);


string to_lower( string &str );
string to_upper( string &str );
vector<string> chop( string &input, string delimiters );
void chomp( string &str );

void initialiseRandom(unsigned long s);
double getRandom();
bool isin ( int id, vector< int > &list );
void insertIfNotIn( int a, vector< int > &list );
void removeIfIn( int a, vector< int > &list );
bool compareTwoArrays( vector< vector< int > > &a1 , vector< vector< int > > &a2 );

vector< int > commonSet( vector< int > &A, vector< int > &B, vector< int > &disA, vector< int > &disB );
vector< int > commonSet( vector< int > &A, vector< int > &B);

vector< vector< int > > just3s ( vector< vector< int > > &V ); //returns just the size 3 instances, as filter

bool almostEqual( double i, double j, double margin = 1.e-4 );
string lowerCaseVersion( string str );



#endif
