#include "MCcontrol.h"

int main(int argc, char *argv[]){
    
  cerr << "Welcome to clusterCensus, analysing MOF simulation output." << endl;
  cerr << "Written by Stephen Wells at Bath Uni." << endl;
  cerr << endl;

  
  //cerr << "Args: " << argc << endl;
  string extraArgument;
  bool gotExtra = false;
  if ( argc == 1 ) {
     cerr << "No control filename given; seeking default file mcg.inp" << endl;
     inpfilename = "mcg.inp"; 
  }
  else{
     stringstream whatin;
     whatin << argv[1];
     inpfilename = whatin.str();
     cerr << "Reading input from file " << inpfilename << endl;
     
     if ( argc > 2 ){
		 stringstream fibble;
		 fibble << argv[2];
		 extraArgument = fibble.str();
		 cerr << "Additional argument: " << extraArgument << endl;
		 gotExtra = true;
	 }
     
  }
        
  //Step 1: parse input file
  bool inputokay = readcommands (inpfilename );
  if (inputokay){
     cerr << "Input okay, continuing." << endl;
  }
  else {
       cerr << "Input not found. Goodbye, cruel world." << endl;
       exit(1);
  }
  
  //Step 2: validate input file
  //do not use main validation routine
  //use only local validation:
  //I need a structure input and a bonding input
  
  
  //we shouldn't need any random thing but keep this for now...
  if ( !given_seed ){
	  seed = static_cast< long >( time(0) );
  }
  cerr << "Initiating Mersenne Twister with seed " << seed << endl;
  initialiseRandom( seed );

  //for now: no ligand logic check
  //will later divide clusters into Metal and Ligand based on containing metal atoms

  //using the structure input lines from main...
  
  if (!given_structure){
	  cerr << "Dying: we require structure input." << endl;
	  exit(1);
  }
  
  if ( input_structure_name == "$" ){
	  cerr << "Special structure input name: $" << endl;
	  if ( gotExtra ){
		  input_structure_name = extraArgument;
	  }
	  else{
		  cerr << "ERROR: $ calls for an additional filename argument on the command line." << endl;
		  exit(1);
	  }
  }
  
  
	bool cifok = inputstructure.readcif( input_structure_name );
	if ( !cifok ) {
		cerr << "Stopping execution due to invalid cif input." << endl;
		cerr << "I require flawless crystals." << endl;
		exit(1);     
	}
	if ( inputstructure.atom.size() == 0 ){
		cerr << "Problem - no atoms in input!" << endl;
		exit(1);
	}
	else {
       cerr << "Read " << inputstructure.atom.size() << " atoms." << endl;
	}
	bool isinit = inputstructure.initialise( gridmin);
	//do cell vectors, inverse vectors, and cartesian positions, also fill grid
	if ( !isinit ){
		cerr << "Sadly, we have choked on an unknown element. Please call an alchemist." << endl;
		exit(1); // die
	}


	if ( given_bond_input ){
		bool bok = readbonds( input_bonding_name , bondline );
		if ( !bok ) {
			cerr << "Stopping execution due to invalid bonding input. Better bondage please." << endl;
			exit(1);     
		}
		inputstructure.bondsintoatoms( bondline );
	}
	else{
		//die here without bonding!
		cerr << "Dying: we require bonding input." << endl;
		exit(1);
	}

	inputstructure.formbondlines( bondline ); // bondlines to output, also handles rigidity

	//okay, all bonding done
	inputstructure.allrigidcheck(); // set labels for Garibaldi later
    //reactive vertex labelling:
    inputstructure.setvirtual();
	
	//parse neighbours for poly specs
	if ( given_poly ){
		cerr << "Parsing polyhedra." << endl;
		inputstructure.parsepoly( polyspec );
	}
	cerr << "Found " << inputstructure.poly.size() << " polyhedra." << endl;

	//now the non-poly bond clusters
	//note cluster array already contains null entry for each poly!
	if ( given_bond ){ // note given bond is required even if we have given bond input... tidy later?
			vector< Cluster > candidate = inputstructure.candidatecluster( bondspec ); // initial bonding clusters
			cerr << "Found " << candidate.size() << " non-poly clusters." << endl;          
			vector< Cluster > goodcandidate;
			goodcandidate = inputstructure.Garibaldi( candidate ); // reunification

			//finally put into cluster and ghost!
			for ( int i = 0 ; i < goodcandidate.size() ; i++ ){
				inputstructure.cluster.push_back( goodcandidate.at(i) );
				inputstructure.ghost.push_back( goodcandidate.at(i) );
			}
			candidate.clear();
			goodcandidate.clear(); // just housekeeping.
	}
  
	cerr << "Found " << inputstructure.cluster.size() << " total clusters." << endl;

	inputstructure.prepclustersandghosts();
	//polys now exist as poly, as cluster, and as ghost
	//nonpolys exist as cluster and as ghost
	// poly-ghosts have perfect geometry
	//hey, for MC purposes, we should replace the imperfect read polys with their perfect ghosts!
	
	//label atoms by inclust! and isvertex
	inputstructure.labelvertices();
	//initial structure has defined bonding, cluster and poly geometry.
	//initial_structure goes into structure now ready to move.


  structure = inputstructure; // :) use structure subsequently for e.g. relax

  findOverlap( structure, overlapArray );
  
  //now we build the superclusters from the overlapArray
  //because we need the superclusters to histogram the cluster sizes!
  supercluster = SCfromOA( overlapArray );
  
  cerr << "DEBUG scan of superclusters: " << endl;
  cerr << "Found " << supercluster.size() << " superclusters. " << endl;
  
  overlapFilter = getFilter( structure, overlapArray );  
  
  //find the largest size of anything in the supercluster array
  //the smallest possible size must be 2 by construction
  int topsize = 0;
  for ( int i = 0 ; i < supercluster.size() ; i++ ){
  	int j = supercluster.at(i).size();
  	if ( j > topsize ) topsize = j;
  }  
  
  if ( topsize < 2 ){
  	cerr << "No clusters of size 2 or greater found!" << endl;
  	cout << "0    " << endl;
  	exit(0);
  }
  
  vector< int > tally;
  tally.resize( topsize ); //slightly too big but who cares :)
  for ( int i = 0 ; i < supercluster.size() ; i++ ){
  	int j = supercluster.at(i).size();
  	tally.at( j-1 )++; //incrementing count
  }
  
  //output to cout
  
  for ( int i = 1 ; i < topsize; i++ ){
  	cout << tally.at(i) << "   ";
  }
  cout << endl;

  cerr << "Consummatum est." << endl;
  exit(0); //final exit
} // END OF MAIN


