![\<logo\\\>](https://github.com/jbon/design-dependencies/blob/master/images/logo.png)

An open source and web-based application to store, display, manipulate and share
structured collections of design heuristics.

What it is for
--------------

Heuristics play a great role in design creativity and learning. There is
generally no systematic method designers can be provided with in order to derive
optimal design solutions. In other words, it is neither possible to list all
solutions to a given problem nor to prove the absolute superiority of a given
solution. However, guidance can be provided to designers in the form of
heuristics, i.e. set of solutions validated by practice, which have proven to
lead towards satisfactory solutions, but which are not guaranteed to be optimal
or perfect. Heuristics express a supposed causal relation between two design
parameters. For example, in the context of automobile development, “overall
weight” has a direct relation with “energy consumption in use.”

This tool allows displaying the network built by all causal relations between
design parameters. It provides an environment to explore and navigate in this
network in order to support creativity in design.

Learn more
----------

-   Bonvoisin J., F. Mathieux, L. Domingo, D. Brissaud. 2010. [Design for energy
    efficiency: proposition of a guidelines-based
    tool.](https://www.designsociety.org/publication/29408/design_for_energy_efficiency_proposition_of_a_guidelines-based_tool)
    In: *Proceedings of DESIGN 2010, the 11th International Design Conference*,
    edited by D. Marjanovic, M. Storga, N. Pavkovic and N. Bojcetic, 629-638.
    Castle Cary: The Design Society. 

-   Bonvoisin J., T. Buchert and R. Stark. 2018. *Formal system for the
    expression of target-oriented design heuristics.* Submitted to the 15th
    International Design Conference, May 21-24, Dubrovnik, Croatia.
