directory='E:\PhD Bath\Experimental Data\8. Warwick Fall 2017\Fixed Bed Studies\Week 34\20171219b\';
listing = dir([directory '*.txt']);
n=length(listing);
files=cell(n,1);
for i=1:n
    files{i}=[directory listing(i).name];
end;

%% file processing
accuracy_margin=0.15; % in min. RT+/- margin

rt_meoh=6.97;   rt_meoh=[6.78 7.15];
rt_dme=6.56;    rt_dme=[6.3150 6.66];
rt_aromatics=[14.136, 16.517, 18.532, 19.896, 22.20]'; %modified for c5
%rt_aromatics=[12.29, 14.61, 17.15, 18.41, 20.42]'; %L0.1
% rt_aromatics=[13.9, 16.03, 18.43, 19.8, 22.8]';
rt_aromatics=repmat(rt_aromatics,1,2);rt_aromatics=rt_aromatics+ repmat([-1 1].*accuracy_margin,length(rt_aromatics(:,1)),1);

rt_aliphatics=[ 5.25    5.49;    %c1 23/June
                5.5    5.74;    %c2
                5.91    6.33;
                7.16    9.29;     %c4
                9.3    10.0;   %c5  9.97
                10.01   14.3;    %C6    
                14.31   16.7;    %C7  15.24
                16.71   18.7;   %C8  17.18
                18.71   20.19;   %C9  18.88
                20.2   22.09;   %c10 20.39
                21.9   22.39;    
                22.4   24.0;    %C12 23.08 
                24.01   999];

rt_total_products_number=length(rt_meoh(:,1))+  length(rt_dme(:,1)) +length(rt_aromatics(:,1)) +  length(rt_aliphatics(:,1))   ;
full_list_compounds={'MeOH' 'DME' 'C6ar' 'C7ar' 'C8ar' 'C9ar' 'C10ar' 'C1' 'C2' 'C3' 'C4' 'C5' 'C6' 'C7' 'C8' 'C9' 'C10' 'C11' 'C12' 'heavy' 'Unaccounted'};
overallProductsRT=[rt_meoh;rt_dme;rt_aromatics;rt_aliphatics];

sensetivity_coefficient=0.002346234;    % in ppm
ECN_compounds=[0.80 1.23 6 7 8 9 10 1 2 3 4 5 6 7 8 9 10 11 12 12 14 ]; %following the list of compounds
resulting_sensetivity=sensetivity_coefficient./ECN_compounds;

% overallProductsRT=[rt_oxygenate; rt_aromatics;  rt_c1_c4; rt_c5_c7; rt_c8_c11; rt_heavy];
% product_assembler=overallProductsRT(:,1)*0;
% product_assembler(1:length(rt_oxygenate(:,1)))=1;
% product_assembler(length(rt_oxygenate(:,1))+1:length(rt_aromatics(:,1))+length(rt_oxygenate(:,1)))=2;
% product_assembler(length(rt_aromatics(:,1))+length(rt_oxygenate(:,1))+1)=3;


n=length(files);
time=zeros(n,1);
filename_short=cell(n,1);
peak_group_area=zeros(n,rt_total_products_number);
area_unaccounted=zeros(n,1);

for i=1:n,
    [time(i) filename_short(i) retention_time peak_areas]=processGCdata_MTH_peaks(files{i});
    retention_time=cell2mat(retention_time);
    peak_areas=cell2mat(peak_areas);
    rt_indexes=retention_time*0;
    %     [time(i) filename_short(i) peak_names_temp peak_group_area_temp peak_group_conc_temp]=processGCdata_MTH(files{i});
    for j=1:length(retention_time),
        for ii=1:length(overallProductsRT(:,1))
            if ((retention_time(j)-overallProductsRT(ii,1))*(retention_time(j)-overallProductsRT(ii,2)))<0,
                % RT is withing the range
                rt_indexes(j)=ii;
                break;
            end;
        end;
    end;
    for j=1:length(retention_time),
        if (rt_indexes(j)>0),
            peak_group_area(i,rt_indexes(j))=peak_group_area(i,rt_indexes(j))+(peak_areas(j));
        end;
    end;
    area_unaccounted(i)=sum(peak_areas)-sum(peak_group_area(i,:));
%     for j=1:length(full_list_compounds),
%         for k=1:length(peak_names_temp),
%             if (strcmp(full_list_compounds{j},peak_names_temp{k})),
%                 peak_group_conc(i,j)=peak_group_conc_temp(j);
%                 peak_group_area(i,j)=peak_group_area_temp(j);
%                 break;
%             end;
%         end;
%     end;
end;



% %% data analysis
% title={'MeOH to DME', 'DME to aliphatics' , 'DME to C1-C4', 'DME to C5-C8', 'DME to C8-C11', 'DME to aromatics'};
% summary=zeros(n, 6);    % MeOH to DME, DME to aliphatics, DME to C1-C4, DME to C5-C8, DME to C8-C11, DME to aromatics




timestamp=time;
time=(time-time(1))*24; % shift to he initial time and recalculation

%% output
output_result_area=['filename'                     'timestamp' 'time, h' full_list_compounds;
    [filename_short,      num2cell([timestamp, time ,   peak_group_area, area_unaccounted])]];

xlswrite([directory 'overall.xlsb'],output_result_area,'Compound_area');

zz= [peak_group_area, area_unaccounted].*repmat(resulting_sensetivity,size(peak_group_area,1),1);
output_result_area=['filename'                     'timestamp' 'time, h' full_list_compounds;
    [filename_short,      num2cell([timestamp, time ,  zz])]];
xlswrite([directory 'overall.xlsb'],output_result_area,'Compound_ppm');


% % plotting
% clf;
% plot(time,area,'-or');
% xlabel('Time/ h'); ylabel('Total area / a.u.');

