function [time filename_short retention_time peak_areas]=processGCdata_MTH_peaks(filename)
% function concentration=processGCdata2(filename)
% concentration=[MBA MBE MBY n-BuOH other]


%% reading the file
fileID=fopen(filename);

data = textscan(fileID, '%s','delimiter','\n');
data=data{1,1}; % textdata
fclose(fileID);

%% search for acuired date
for i=1:length(data),
    if ~isempty(data{i,1}), temp=textscan(data{i,1},'Acquired	%s','Delimiter','\t');end;
    if ~isempty(temp{1,1}); time=datenum(temp{1,1},'dd/mm/yyyy HH:MM:SS');end;
end;

%% search for the filename
for i=1:length(data),
    if ~isempty(data{i,1}), temp=textscan(data{i,1},'Data File Name	%s','Delimiter','\t');end;
    if ~isempty(temp{1,1}); [~, filename_short, ~] =fileparts(char(temp{1,1}));filename_short=cellstr(filename_short);break;end;
end;


%% dealing with compounds
% looking for a compound_results table
for i=1:length(data),
    if ~isempty(data{i,1}), if ~isempty(strfind(data{i,1},'[Peak Table(Ch1)]')), peak_table_start=i;end;end;
end;

% read total number of compounds
total_number_peaks=cell2mat(textscan(data{peak_table_start+1,1},'# of Peaks %d'));


% reading peaks
pre_data=cell(total_number_peaks,6);
for i=1:total_number_peaks,
    pre_data(i,:)=textscan(data{peak_table_start+2+i,1},'%f %f %f %f %f %f',1);
end;

peak_area_column_number=5;

% analysing compounds
retention_time=pre_data(:,2);
peak_areas=pre_data(:,peak_area_column_number);

% output



% end;
%
% function [fits]=retention_time_fits(RT_experimental, RT_table)
%     fits=0;
%     margin = 0.05;
%     if abs((RT_experimental-RT_table)/RT_table)<0.05
