function fldplot2( x, y, E )
% triangulation
tri = delaunay( x( : ), y( : ) );

% real
figure
trisurf( tri, x( : ) * 1e9, y( : ) * 1e9, real( E ) );
view( 0, 90 );
shading interp;
axis( [ min( x( : ) * 1e9 ), max( x( : ) * 1e9 ), min( y( : ) * 1e9 ), max( y( : ) * 1e9 ) ] );
colorbar;
set( gca, 'FontSize', 16 );
xlabel( 'nm' ); ylabel( 'nm' );

% imag
figure
trisurf( tri, x( : ) * 1e9, y( : ) * 1e9, imag( E ) );
view( 0, 90 );
shading interp;
axis( [ min( x( : ) * 1e9 ), max( x( : ) * 1e9 ), min( y( : ) * 1e9 ), max( y( : ) * 1e9 ) ] );
colorbar;
set( gca, 'FontSize', 16 );
xlabel( 'nm' ); ylabel( 'nm' );

end