%% set up the simulation background
% clear everything
clear; clc; path( pathdef );
% addpath
addpath( genpath( [ pwd, '/misc' ] ) );

%% load data
% wavelengths
load( [ pwd, '/fields/lam.mat' ] );
% coordinates
load( [ pwd, '/fields/pos.mat' ] );
% load ( el, hl )
load( [ pwd, '/fields/el.mat' ] );
load( [ pwd, '/fields/hl.mat' ] );
% load ( er, hr )
load( [ pwd, '/fields/er.mat' ] );
load( [ pwd, '/fields/hr.mat' ] );
% load ( rl,rr )
load( [ pwd, '/fields/rl.mat' ] );
load( [ pwd, '/fields/rr.mat' ] );

%% field plot
% lx, ly
lx = 2.4e-6; ly = 2.4e-6;

% X, Y
X = [ x( : ); x( : ) + 2.4e-6; x( : ) + 2.4e-6; x( : ) ];
Y = [ y( : ); y( : ); y( : ) - 2.4e-6; y( : ) - 2.4e-6 ];
% El, Er
El = cat( 1, el, el, el, el );
Er = cat( 1, er, er, er, er );

% loop around all the wavelengths
for ien = [ 62, 64, 68 ]
    % e ( the LCP case )
    fldplot( X, Y, El( :, :, ien ) );
    % e ( the RCP case )
    fldplot( X, Y, Er( :, :, ien ) );
end

%% reflectance
figure
plot( enei * 1e9, real( rl ), 'o-', 'LineWidth', 3 );
hold on;
plot( enei * 1e9, real( rr ), '--', 'LineWidth', 3 );
xlabel( 'Wavelengths (nm)', 'FontSize', 16 );
ylabel( 'Reflectance', 'FontSize', 16 );
set( gca, 'FontSize', 16 );
legend( 'LCP', 'RCP' );
axis( [ min( enei * 1e9 ) max( enei * 1e9 ) 0 1 ] );
