function fldplot( x, y, E )
% triangulation
tri = delaunay( x( : ), y( : ) );

% e
e = dot( E, E, 2 );

% mag
figure
trisurf( tri, x( : ) * 1e9, y( : ) * 1e9, e );
view( 0, 90 );
shading interp;
axis( [ min( x( : ) * 1e9 ), max( x( : ) * 1e9 ), min( y( : ) * 1e9 ), max( y( : ) * 1e9 ) ] );
colorbar;
set( gca, 'FontSize', 16 );
xlabel( 'nm' ); ylabel( 'nm' );

end