%% set up the environment
% clear everything
clear; clc; path( pathdef );
% addpath
addpath( genpath( [ pwd, '/misc' ] ) );

%% read data
% f
load( [ pwd, '/TCD/f.mat' ] );

% Uz
load( [ pwd, '/TCD/Uz.mat' ] );

% T_left
load( [ pwd, '/TCD/T_left.mat' ] ); 
T_left = T_grating; clear T_grating

% T_right
load( [ pwd, '/TCD/T_right.mat' ] ); 
T_right = T_grating; clear T_grating

%% constants & wavelengths
% eps0 and mu0
eps0 = 8.85e-12; mu0 = 4 * pi * 1e-7;
% c
c = 1 / sqrt( eps0 * mu0 );
% enei
enei = c ./ f;
enei = enei * 1e9;

%% CD
% set up CD
CD = zeros( 4, numel( enei ) );
% plot
figure
for idir = 2 : 2 : 4
    % the ith order
    idx = find( acos( Uz( 7, 7 + idir, : ) ) / pi * 180 ~= 90 );
    % CD
    CD( idir, idx ) = ( T_right( 7, 7 + idir, idx ) - T_left( 7, 7 + idir, idx ) ) ./ ...
                      ( T_right( 7, 7 + idir, idx ) + T_left( 7, 7 + idir, idx ) );
    % plot
    scatter( enei( idx ), acos( Uz( 7, 7 + idir, idx  ) ) / pi * 180, [], CD( idir, idx ), 'filled' )
    % hold on;
    hold on;
end
% hold off
hold off;
% colorbar
colorbar;
% caxis
caxis( [ -1 * max( max( CD ) ), +1 * max( max( CD ) ) ] );
% colormap
map = redblue( 1024 ); map = flipud( map );
colormap( map );
% axis
axis( [ 450 1000 0 90 ] );
% plot set
set( gca, 'FontSize', 16, 'box', 'on');
