%% set up the simulation background
% clear everything
clear; clc; path( pathdef );
% addpath
addpath( genpath( [ pwd, '/misc' ] ) );

%% load data
% wavelengths
load( [ pwd, '/CD/lam.mat' ] );
% k
load( [ pwd, '/CD/k.mat' ] );
% kz
load( [ pwd, '/CD/kz.mat' ] );
% pl
load( [ pwd, '/CD/pl.mat' ] );
% pr
load( [ pwd, '/CD/pr.mat' ] );

%% plot
% nenei
nenei = length( enei );
% set up CD
CD = zeros( 4, nenei );
% plot all the diffraction orders
figure
for idir = 1 : 4
    % the first order
    idx = find( imag( kz( idir, : ) ) == 0 );
    % Uz
    Uz = acos( kz( idir, idx ) ./ k( idx ) );
    Uz = Uz * 180 / pi;
    % CD
    CD( idir, idx ) = real( pr( idir, idx ) - pl( idir, idx ) ) ./ real( pr( idir, idx ) + pl( idir, idx ) );
    % scatter
    scatter( enei( idx ) * 1e9, Uz, [], CD( idir, idx ), 'filled' );
    % hold
    hold on;
end
% colorset
colorbar;
caxis( [ -1 * max( max( CD( 3, : ) ) ), +1 * max( max( CD( 3, : ) ) ) ] );
% colormap
map = redblue( 1024 ); map = flipud( map );
colormap( map );
% axis
axis( [ 450 1000 0 90 ] );
% plot set
set( gca, 'FontSize', 16, 'box', 'on');
