# -*- coding: utf-8 -*-
"""
Created on Tue Nov 27 11:31:57 2018

@author: ck336
"""

import plotly
from plotly.offline import iplot, init_notebook_mode
import plotly.graph_objs as go
import plotly.io as pio
import plotly.plotly as py
import os
import numpy as np
import math
import pandas as pd
import scipy.signal


# Read data from a csv
height, friction, deflection =np.loadtxt('4L_AFM_raw_data.txt',skiprows=431, unpack=True) #gets the data from file
size=int(math.sqrt(len(height)))

afm_array=np.reshape(height,(size,size))
x=np.linspace(0,4,size)
y=np.linspace(0,4,size)

k_size=9
kernel=np.divide(np.ones((k_size,k_size)), k_size**2)

afm=scipy.signal.convolve2d(afm_array,kernel,mode='same')

minimum=abs(min(np.ravel(afm)))
afm=np.add(afm,minimum)
afm=np.divide(afm,1.25) #accounts for miscalibration and found from calibration sample

data=[go.Surface(x=x,y=y,z=afm,colorscale= [[0.0, 'rgb(110,0,0)'], [1.0, 'rgb(250,250,0)']],colorbar = dict(
            title = 'Thickness (nm)',
            titleside = 'top',
            ticks = 'outside'
        ))]

layout = go.Layout(
    title='AFM image',
    scene=dict(
        aspectratio=dict(x=1,y=1,z=0.25),
        xaxis=dict(
            title="x (μm)",
            titlefont=dict(
                family='Arial',
                size=18,
                color='black'
            ),
            showticklabels=True,
            tickfont=dict(
                family='Arial',
                size=14,
                color='black'
            )),
        camera = dict(
            up=dict(x=0, y=0, z=1),
            center=dict(x=0, y=0, z=0),
            eye=dict(x=1.25, y=1.25, z=1.25)
            ),
        yaxis=dict(
            title="y (μm)",
            titlefont=dict(
                family='Arial',
                size=18,
                color='black'
            ),
            showticklabels=True,
            tickfont=dict(
                family='Arial',
                size=14,
                color='black'
            )),
        zaxis=dict(
            showgrid=False,
            showticklabels=False,
            showaxeslabels=False
            ),
    ),
    autosize=False,
    width=1000,
    height=1000
)
fig = go.Figure(data=data, layout=layout)
#py.iplot(fig, filename='AFM of L')
#%%
iplot(fig)


#%%
if not os.path.exists('images'):
    os.mkdir('images')
    
#pio.write_image(fig, 'images/fig1.pdf')