%% set up the simulation background
% clear everything
clear; clc; path( pathdef );
% addpath
addpath( genpath( [ pwd, '/misc' ] ) );

%% load data
% lam
load( [ pwd, '/fourier/lam.mat' ] );
% orders
load( [ pwd, '/fourier/orders.mat' ] );
% load ( p, P )
load( [ pwd, '/fourier/pl.mat' ] );
load( [ pwd, '/fourier/pr.mat' ] );

%% plot fourier coefficients
% ien
for ien = 83
    % N1, N2
    [ N1, N2 ] = ndgrid( n1, n2 );
    
    % CD
    CD = ( pl( :, ien ) - pr( :, ien ) ) ./ ( pl( :, ien ) + pr( :, ien ) );
    
    % scatter plot
    figure
    scatter( N1( : ), N2( : ), 500, CD, 's', 'filled' );
    % colorset
    colorbar;
    caxis( [ -2 * max( CD ), +2 * max( CD ) ] );
    % colormap
    map = redblue( 1024 ); map = flipud( map );
    colormap( map );
    % axis
    axis( [ -6, +6, -6, +6 ] );
    % grid
    grid off;
    % plot set
    set( gca, 'FontSize', 16, 'box', 'on');
end
