%% set up the environment
% clear everything
clear; clc; path( pathdef );
% addpath
addpath( genpath( [ pwd, '/misc' ] ) );

%% read data
% f
load( [ pwd, '/TCD/f.mat' ] );

% Uz
load( [ pwd, '/TCD/Uz.mat' ] );

% T_left
load( [ pwd, '/TCD/T_left.mat' ] ); 
T_left = T_grating;

% T_right
load( [ pwd, '/TCD/T_right.mat' ] ); 
T_right = T_grating;

%% plot power spectrum
% eps0 and mu0
eps0 = 8.85e-12; mu0 = 4 * pi * 1e-7;
% c
c = 1 / sqrt( eps0 * mu0 );
% enei
enei = c ./ f;
enei = enei * 1e9;

% T
T = T_left - T_right;
% T1, T2 and T3
T1 = squeeze( T( 4, 5, : ) );
T2 = squeeze( T( 4, 6, : ) );
T3 = squeeze( T( 4, 7, : ) );

% U1, U2 and U3
U1 = acos( squeeze( Uz( 4, 5, : ) ) ) * 180/pi;
U2 = acos( squeeze( Uz( 4, 6, : ) ) ) * 180/pi;
U3 = acos( squeeze( Uz( 4, 7, : ) ) ) * 180/pi;

figure
% the first order
idx = find( T1 ~= 0 );
scatter( enei( idx ), U1( idx ), [], T1( idx ), 'filled' )
hold on;
% the second order
idx = find( T2 ~= 0 );
scatter( enei( idx ), U2( idx ), [], T2( idx ), 'filled' )
% the third order
idx = find( T3 ~= 0 );
scatter( enei( idx ), U3( idx ), [], T3( idx ), 'filled' )
% colorset
colorbar;
% caxis( [ -1e-3, +1e-3 ] )
% colormap
map = redblue( 1024 ); % map = flipud( map );
colormap( map );
% axis
% axis( [ 450 1800 0 90 ] );
% axis( [ 450 1200 0 90 ] );
axis( [ 450 1050 0 90 ] );
% plot set
set( gca, 'FontSize', 16 );
