#!/bin/bash

# for p in "ackley" "ackleysmall" "rosenbrock"; do ./run_eval.sh "${p}"; done

if [ $# -ne 1 ]; then
	echo "Usage: ${0} <dataset>" 1>&2
	exit 1
fi

# Uncomment if you need to activate an environment
#conda activate tensorflow

DATASET="${1}"

# Avoid MSYS path conversion
export MSYS_NO_PATHCONV=1
export MSYS2_ARG_CONV_EXCL="*"

BASE_DIR="$(dirname "$0")"
DATA_DIR="data/${DATASET}"
OUTPUT_DIR="eval/${DATASET}"

SEED=0
USE_BIAS="y"
BATCH_SIZE=32
MAX_STEPS=100000
PATIENCE=-1
LEARNING_RATE=0.001

MODEL_NAMES=("NN" "2x2" "3x3" "4x4" "5x5" "6x6" "7x7")
SPLINE_POINTS=("none" "2,2" "3,3" "4,4" "5,5" "6,6" "7,7")
LINEAR_EVAL=("none" "4,4" "6,6" "8,8" "10,10" "12,12" "14,14")
CONSTANT_EVAL=("none" "8,8" "12,12" "16,16" "20,20" "24,24" "28,28")
HIDDEN_LAYERS=("100,100" "48,48" "31,31" "23,23" "18,18" "14,14" "12,12")

# ~ 10k params
# 1_100-100: 10501 params
# 2-2_48-48: 10180 params
# 3-3_31-31: 10053 params
# 4-4_23-23: 10320 params
# 5-5_18-18: 10375 params
# 6-6_14-14:  9612 params
# 7-7_12-12: 10045 params

#set -x
set -e
cd "${BASE_DIR}"

mkdir -p "${OUTPUT_DIR}/train"
for i in "${!MODEL_NAMES[@]}"; do
	echo "Training model ${MODEL_NAMES[${i}]}"
	python scripts/train_gfnn.py \
		--data-dir "${DATA_DIR}" \
		--log-dir "${OUTPUT_DIR}/train/${MODEL_NAMES[${i}]}" \
		--spline-points "${SPLINE_POINTS[${i}]}" \
		--hidden-layers "${HIDDEN_LAYERS[${i}]}" \
		--use-bias "${USE_BIAS}" \
		--max-steps "${MAX_STEPS}" \
		--patience "${PATIENCE}" \
		--linear-eval "${LINEAR_EVAL[${i}]}" \
		--constant-eval "${CONSTANT_EVAL[${i}]}" \
		--seed "${SEED}"
	echo
done

for model_name in "${MODEL_NAMES[@]}"; do
	model_file="${OUTPUT_DIR}/train/${model_name}/gfnn_cubic.tf"
	model_res_dir="${OUTPUT_DIR}/results/models/${model_name}"
	python scripts/model_figures.py "${DATASET}" "${model_file}" "${model_res_dir}"
done

for include_nn in "0" "1"; do
	res_dir="results"
	if [ "${include_nn}" = "1" ]; then
		res_dir="${res_dir}/all_"
	else
		res_dir="${res_dir}/gfnn_"
	fi
	for mode in "cubic" "linear" "constant"; do
		res_dir_mode="${res_dir}${mode}"
		model_evals=()
		for i in "${!MODEL_NAMES[@]}"; do
			name="${MODEL_NAMES[${i}]}"
			if [ "${name}" = "NN" ]; then
				if [ "${include_nn}" = "1" ]; then
					model_evals+=("${name}:${OUTPUT_DIR}/train/${name}/gfnn_cubic.tf?cubic")
				fi
			else
				model_evals+=("${name}/${mode}:${OUTPUT_DIR}/train/${name}/gfnn_${mode}.tf?${mode}")
			fi
		done
		echo "Evaluating ${res_dir_mode}..."
		python scripts/test_models.py \
			--models "${model_evals[@]}" \
			--out "${OUTPUT_DIR}/${res_dir_mode}" \
			--data "data:${DATA_DIR}/test"
	done
done

echo "Done"
