#!/bin/bash

# Uncomment if you need to activate an environment
#conda activate tensorflow

DATASET="ackley-revised"

# Avoid MSYS path conversion
export MSYS_NO_PATHCONV=1
export MSYS2_ARG_CONV_EXCL="*"

BASE_DIR="$(dirname "$0")"
DATA_DIR="data/${DATASET}"
OUTPUT_DIR="eval/ackley-revised"

SEED=0
USE_BIAS="y"
BATCH_SIZE=32
MAX_STEPS=100000
PATIENCE=-1
LEARNING_RATE=0.001

MODEL_NAMES=("NN" "7x7" "8x8" "9x9" "10x10" "11x11" "12x12" "13x13" "14x14" "15x15")
SPLINE_POINTS=("none" "7,7" "8,8" "9,9" "10,10" "11,11" "12,12" "13,13" "14,14" "15,15")
LINEAR_EVAL=("none" "none" "none" "none" "none" "none" "none" "none" "none" "none")
CONSTANT_EVAL=("none" "none" "none" "none" "none" "none" "none" "none" "none" "none")
HIDDEN_LAYERS=("250,250" "33,33" "29,29" "25,25" "22,22" "20,20" "18,18" "17,17" "15,15" "14,14")

# ~60k-63k parameters

#set -x
set -e
cd "${BASE_DIR}"

mkdir -p "${OUTPUT_DIR}/train"
for i in "${!MODEL_NAMES[@]}"; do
	echo "Training model ${MODEL_NAMES[${i}]}"
	python scripts/train_gfnn.py \
		--data-dir "${DATA_DIR}" \
		--log-dir "${OUTPUT_DIR}/train/${MODEL_NAMES[${i}]}" \
		--spline-points "${SPLINE_POINTS[${i}]}" \
		--hidden-layers "${HIDDEN_LAYERS[${i}]}" \
		--use-bias "${USE_BIAS}" \
		--max-steps "${MAX_STEPS}" \
		--patience "${PATIENCE}" \
		--linear-eval "${LINEAR_EVAL[${i}]}" \
		--constant-eval "${CONSTANT_EVAL[${i}]}" \
		--seed "${SEED}"
	echo
done

for model_name in "${MODEL_NAMES[@]}"; do
	model_file="${OUTPUT_DIR}/train/${model_name}/gfnn_cubic.tf"
	model_res_dir="${OUTPUT_DIR}/results/models/${model_name}"
	python scripts/model_figures.py "${DATASET}" "${model_file}" "${model_res_dir}"
done

for include_nn in "0" "1"; do
	res_dir="results"
	if [ "${include_nn}" = "1" ]; then
		res_dir="${res_dir}/all_"
	else
		res_dir="${res_dir}/gfnn_"
	fi
	for mode in "cubic"; do
		res_dir_mode="${res_dir}${mode}"
		model_evals=()
		for i in "${!MODEL_NAMES[@]}"; do
			name="${MODEL_NAMES[${i}]}"
			if [ "${name}" = "NN" ]; then
				if [ "${include_nn}" = "1" ]; then
					model_evals+=("${name}:${OUTPUT_DIR}/train/${name}/gfnn_cubic.tf?cubic")
				fi
			else
				model_evals+=("${name}/${mode}:${OUTPUT_DIR}/train/${name}/gfnn_${mode}.tf?${mode}")
			fi
		done
		echo "Evaluating ${res_dir_mode}..."
		python scripts/test_models.py \
			--models "${model_evals[@]}" \
			--out "${OUTPUT_DIR}/${res_dir_mode}" \
			--data "data:${DATA_DIR}/test"
	done
done

echo "Done"
