#!/bin/bash

# Uncomment if you need to activate an environment
#conda activate tensorflow

# Avoid MSYS path conversion
export MSYS_NO_PATHCONV=1
export MSYS2_ARG_CONV_EXCL="*"

cd "$(dirname "$0")"

BATH_SIZE=32
MAX_STEPS=300000
EVALUATION_STEPS=1000
DROPOUT=0.3
REGULARIZATION=1
LEARNING_RATE=0.0001
SEED=400


# GFNN 3x3 - linear approximation 7x7
scripts\train_quadruped.py --log-dir gfnn_3x3_linear-7x7 --train-data-dir data/records/train_restructured --test-data-dir data/records/test --num-feet 4 --num-joints 27 --past-trajectory-window 6 --future-trajectory-window 6 --num-styles 4 --with-terrain f --with-contact f --spline-points 3,1,3,1 --angvel-coords y --remove-styles y --remove-phase y --hidden-layers 512,512 --functioned-output y --use-bias y --batch-size $BATCH_SIZE --max-steps $MAX_STEPS --evaluation-steps $EVALUATION_STEPS --learning-rate $LEARNING_RATE --dropout $DROPOUT --regularization $REGULARIZATION --use-weights n --linear-eval 7,1,7,1 --seed $SEED

# MANN 8
workspace\train_quadruped_mann.py --log-dir mann_8 --train-data-dir data/records/train --test-data-dir data/records/test --num-feet 4 --num-joints 27 --past-trajectory-window 6 --future-trajectory-window 6 --num-styles 4 --with-terrain f --with-contact f --num-gated 8 --remove-styles y --remove-phase y --hidden-layers 512,512 --gating-hidden-layers 32,32 --gating-indices 14-15,54,66,78,195-197,210-212,222-224,234-236 --functioned-output y --use-bias y --batch-size $BATCH_SIZE --max-steps $MAX_STEPS --evaluation-steps $EVALUATION_STEPS --learning-rate $LEARNING_RATE --dropout $DROPOUT --regularization $REGULARIZATION --use-weights n --seed $SEED

# MANN 9
workspace\train_quadruped_mann.py --log-dir mann_9 --train-data-dir data/records/train --test-data-dir data/records/test --num-feet 4 --num-joints 27 --past-trajectory-window 6 --future-trajectory-window 6 --num-styles 4 --with-terrain f --with-contact f --num-gated 9 --remove-styles y --remove-phase y --hidden-layers 512,512 --gating-hidden-layers 32,32 --gating-indices 14-15,54,66,78,195-197,210-212,222-224,234-236 --functioned-output y --use-bias y --batch-size $BATCH_SIZE --max-steps $MAX_STEPS --evaluation-steps $EVALUATION_STEPS --learning-rate $LEARNING_RATE --dropout $DROPOUT --regularization $REGULARIZATION --use-weights n --seed $SEED

# Evaluation
python workspace/simulate_model.py --data gallop:data/records/eval/gallop.tfrecord gallop_turn:data/records/eval/gallop_turn.tfrecord walk:data/records/eval/walk.tfrecord walk_gallop:data/records/eval/walk_gallop.tfrecord walk_s:data/records/eval/walk_s.tfrecord walk_stand:data/records/eval/walk_stand.tfrecord walk_turn:data/records/eval/walk_turn.tfrecord "test:data/records/gait/test/*.tfrecord" --models "gfnn_3x3-spline:gfnn_3x3_linear-7x7/gfnn_cubic.tf?cubic" "gfnn_3x3_linear-7x7:gfnn_3x3_linear-7x7/gfnn_linear.tf?linear" "mann_8:mann_8/mann_best.tf?mann" "mann_9:mann_9/mann_best.tf?mann" --out eval

echo "Done"
