// Copyright 2017 Ninja Theory Ltd. All Rights Reserved.

#ifndef NTTENSORFLOW_NTTENSORFLOW_INL_
#define NTTENSORFLOW_NTTENSORFLOW_INL_

#include "NTTensorFlow.h"

// Explicit template instantiation / declaration

#ifdef NTTENSORFLOW_API_EXPORTS
#define NTTENSORFLOW_EXTERN
#else
#define NTTENSORFLOW_EXTERN extern
#endif

/*
Full TF type list (tensorflow/core/framework/types.h):

float, double,
tensorflow::int8, tensorflow::int16, tensorflow::int32, tensorflow::int64,
tensorflow::uint8, tensorflow::uint16,
tensorflow::complex64, tensorflow::complex128,
tensorflow::qint8, tensorflow::qint16, tensorflow::quint8, tensorflow::quint16, tensorflow::qint32,
bool, tensorflow::string,
tensorflow::bfloat16, Eigen::half , tensorflow::ResourceHandle
*/

// Insantiate just for non-TF types

#define NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, OutputType) \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT bool NTTensorFlow::TfRunner<InputType, StateType>::GetOutputImpl<OutputType>(uint32_t, typename NTTensorFlow::internal::ComplexTypeSupport<OutputType>::primitive_type*, size_t&) const;

#define NTTENSORFLOW_INSTANTIATE_STATE(InputType, StateType) \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>::TfRunner(TfRunner<InputType, StateType>&&); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>& NTTensorFlow::TfRunner<InputType, StateType>::operator=(TfRunner<InputType, StateType>&&); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>::~TfRunner(); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT void NTTensorFlow::TfRunner<InputType, StateType>::Reset(); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::NumFeeds() const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::NumInputs() const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::NumOutputs() const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::NumStates() const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::GetInputRank(uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT size_t NTTensorFlow::TfRunner<InputType, StateType>::GetInputSize(uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT size_t NTTensorFlow::TfRunner<InputType, StateType>::GetInputDimensionSize(uint32_t, uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::GetOutputRank(uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT size_t NTTensorFlow::TfRunner<InputType, StateType>::GetOutputSize(uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT size_t NTTensorFlow::TfRunner<InputType, StateType>::GetOutputDimensionSize(uint32_t, uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT uint32_t NTTensorFlow::TfRunner<InputType, StateType>::GetStateRank(uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT size_t NTTensorFlow::TfRunner<InputType, StateType>::GetStateSize(uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT size_t NTTensorFlow::TfRunner<InputType, StateType>::GetStateDimensionSize(uint32_t, uint32_t) const; \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>* NTTensorFlow::TfRunner<InputType, StateType>::CreateImpl( \
        const NTTensorFlow::TfModel&, \
        const char* const*, uint32_t, \
        const char* const*, uint32_t, \
        const char* const*, const char* const*, uint32_t); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>* NTTensorFlow::TfRunner<InputType, StateType>::CreateImpl( \
        const NTTensorFlow::TfModel&, \
        const char* const*, uint32_t, \
        const char* const*, uint32_t, \
        const char*, const char*); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>* NTTensorFlow::TfRunner<InputType, StateType>::CreateAliasedImpl( \
        const NTTensorFlow::TfModel&, \
        const char* const*, uint32_t, \
        const char* const*, uint32_t, \
        const char* const*, const char* const*, uint32_t); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT NTTensorFlow::TfRunner<InputType, StateType>* NTTensorFlow::TfRunner<InputType, StateType>::CreateAliasedImpl( \
        const NTTensorFlow::TfModel&, \
        const char* const*, uint32_t, \
        const char* const*, uint32_t, \
        const char*, const char*); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT bool NTTensorFlow::TfRunner<InputType, StateType>::FeedImpl(const typename NTTensorFlow::internal::ComplexTypeSupport<InputType>::primitive_type* const*, const size_t*, uint32_t); \
    NTTENSORFLOW_EXTERN template NTTENSORFLOW_EXPORT bool NTTensorFlow::TfRunner<InputType, StateType>::GetStateImpl(uint32_t, typename NTTensorFlow::internal::ComplexTypeSupport<StateType>::primitive_type*, size_t&) const; \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, float) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, double) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, int8_t) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, int16_t) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, int32_t) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, int64_t) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, uint8_t) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, uint16_t) \
    /* NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, std::complex<float>) */ \
    /* NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, std::complex<double>) */ \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, bool) \
    NTTENSORFLOW_INSTANTIATE_OUTPUT(InputType, StateType, std::string)

#define NTTENSORFLOW_INSTANTIATE_INPUT(InputType) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, float) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, double) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, int8_t) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, int16_t) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, int32_t) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, int64_t) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, uint8_t) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, uint16_t) \
    /* NTTENSORFLOW_INSTANTIATE_STATE(InputType, std::complex<float>) */ \
    /* NTTENSORFLOW_INSTANTIATE_STATE(InputType, std::complex<double>) */ \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, bool) \
    NTTENSORFLOW_INSTANTIATE_STATE(InputType, std::string)

#define NTTENSORFLOW_INSTANTIATE \
    NTTENSORFLOW_INSTANTIATE_INPUT(float) \
    NTTENSORFLOW_INSTANTIATE_INPUT(double) \
    NTTENSORFLOW_INSTANTIATE_INPUT(int8_t) \
    NTTENSORFLOW_INSTANTIATE_INPUT(int16_t) \
    NTTENSORFLOW_INSTANTIATE_INPUT(int32_t) \
    NTTENSORFLOW_INSTANTIATE_INPUT(int64_t) \
    NTTENSORFLOW_INSTANTIATE_INPUT(uint8_t) \
    NTTENSORFLOW_INSTANTIATE_INPUT(uint16_t) \
    /* NTTENSORFLOW_INSTANTIATE_INPUT(std::complex<float>) */ \
    /* NTTENSORFLOW_INSTANTIATE_INPUT(std::complex<double>) */ \
    NTTENSORFLOW_INSTANTIATE_INPUT(bool) \
    NTTENSORFLOW_INSTANTIATE_INPUT(std::string)

NTTENSORFLOW_INSTANTIATE

#undef NTTENSORFLOW_INSTANTIATE
#undef NTTENSORFLOW_INSTANTIATE_INPUT
#undef NTTENSORFLOW_INSTANTIATE_STATE
#undef NTTENSORFLOW_INSTANTIATE_OUTPUT
#undef NTTENSORFLOW_EXTERN

#endif  // NTTENSORFLOW_NTTENSORFLOW_INL_
