// cl test_model.cpp /EHsc /Ox /GL /link NTTensorFlow.lib /OUT:test_model.exe

#include <chrono>
#include <iostream>
#include <memory>
#include <string>
#include <vector>

#include "NTTensorFlow/NTTensorFlow.h"

#define WARM_REPS 1000
#define TEST_REPS 1000

using namespace std;
using namespace NTTensorFlow;

int main(int argc, char* argv[])
{
	if (argc != 5)
	{
		cerr << "Usage: " << argv[0] << " <TF file> <input size> <coords size> <mode>" << endl;
		return 1;
	}
	int in_size, coord_size;
	try
	{
		in_size = stoi(argv[2]);
		coord_size = stoi(argv[3]);
	}
	catch (...)
	{
		cerr << "Error: invalid arguments." << endl;
		return 2;
	}
	auto model = unique_ptr<TfModel>(TfModel::Load(argv[1]));
	if (!model)
	{
		cerr << "Error: cannot load model." << endl;
		return 3;
	}
	string mode = argv[4];
	auto runner = unique_ptr<TfRunner<float>>(TfRunner<float>::Create(*model, { "Input", "Coords" }, { "Output" + mode }));
	if (!model)
	{
		cerr << "Error: cannot load model." << endl;
		return 4;
	}
	vector<vector<float>> feed_dict = {vector<float>(in_size), vector<float>(coord_size)};
	float* inputValues[] = {feed_dict[0].data(), feed_dict[1].data()};
	size_t inputValueSizes[] = {size_t(in_size), size_t(coord_size)};
	int numInputValues = 2;
	auto ok = runner->Feed(inputValues, inputValueSizes, numInputValues);
	if (!ok)
	{
		cerr << "Error: cannot run model." << endl;
		return 5;
	}
	for (int i = 0; i < WARM_REPS; i++)
	{
		runner->Feed(inputValues, inputValueSizes, numInputValues);
	}
	auto start = chrono::steady_clock::now();
	for (int i = 0; i < TEST_REPS; i++)
	{
		runner->Feed(inputValues, inputValueSizes, numInputValues);
	}
	auto end = chrono::steady_clock::now();
	auto msPerRun = chrono::duration_cast<chrono::microseconds>(end - start).count() / double(1000 * TEST_REPS);
	cout << msPerRun << endl;
	return 0;
}
