// cl test_model_2.cpp /EHsc /Ox /GL /link NTTensorFlow.lib /OUT:test_model_2.exe

#include <chrono>
#include <iostream>
#include <memory>
#include <string>
#include <vector>

#include "NTTensorFlow/NTTensorFlow.h"

#define WARM_REPS 1000
#define TEST_REPS 1000

using namespace std;
using namespace NTTensorFlow;

int main(int argc, char* argv[])
{
	if (argc < 3 || argc % 2 != 1)
	{
		cerr << "Usage: " << argv[0] << " <TF file> [<input name> <input size>]* <output name>" << endl;
		return 1;
	}
	int in_size, coord_size;
	vector<string> inputNames;
	vector<size_t> inputSizes;
	try
	{
		for (int i = 0; i < argc / 2 - 1; i++)
		{
			int offset = 2 + i * 2;
			inputNames.push_back(argv[offset]);
			inputSizes.push_back(stoi(argv[offset + 1]));
		}
	}
	catch (...)
	{
		cerr << "Error: invalid arguments." << endl;
		return 2;
	}
	auto model = unique_ptr<TfModel>(TfModel::Load(argv[1]));
	if (!model)
	{
		cerr << "Error: cannot load model." << endl;
		return 3;
	}
	string output = argv[argc - 1];
	auto runner = unique_ptr<TfRunner<float>>(TfRunner<float>::Create(*model, inputNames, { output }));
	if (!model)
	{
		cerr << "Error: cannot load model." << endl;
		return 4;
	}
	vector<vector<float>> feedDict;
	vector<float*> inputValues;
	for (size_t in_size : inputSizes)
	{
		feedDict.push_back(vector<float>(in_size));
		inputValues.push_back(feedDict.back().data());
	}
	int numInputValues = feedDict.size();
	float** inputValuesPtr = inputValues.data();
	size_t* inputSizesPtr = inputSizes.data();
	auto ok = runner->Feed(inputValuesPtr, inputSizesPtr, numInputValues);
	if (!ok)
	{
		cerr << "Error: cannot run model." << endl;
		return 5;
	}
	for (int i = 0; i < WARM_REPS; i++)
	{
		runner->Feed(inputValuesPtr, inputSizesPtr, numInputValues);
	}
	auto start = chrono::steady_clock::now();
	for (int i = 0; i < TEST_REPS; i++)
	{
		runner->Feed(inputValuesPtr, inputSizesPtr, numInputValues);
	}
	auto end = chrono::steady_clock::now();
	auto msPerRun = chrono::duration_cast<chrono::microseconds>(end - start).count() / double(1000 * TEST_REPS);
	cout << msPerRun << endl;
	return 0;
}
