# Analysis for "Affect Recognition using Psychophysiological Correlates in High Intensity VR Exergaming"
# CHI 2020 paper by Soumya C. Barathi, Michael Proulx, Eamonn O'Neill, Christof Lutteroth
# Please cite the paper if you find the analysis below useful. Thanks!

# install the packages below in RStudio using Tools -> Install
library(reshape2)
library(dplyr)
library(nlme)
library(tidyverse)
library(rmcorr)
library(psych)
library(plyr)

dw = read.csv("Experiment_1.csv")

# wide to long conversion for IMI Interest/Enjoyment columns
d1 = melt(dw, 
         id.vars=c("P.No"), 
         measure.vars=c(
           "EG.IMI.Enj", "E.IMI.Enj", "G.IMI.Enj"), 
         variable.name="Condition",
         value.name="Interest")
d1$Condition <- as.character(d1$Condition)
d1$Condition[d1$Condition=="EG.IMI.Enj"] <- "EG"
d1$Condition[d1$Condition=="E.IMI.Enj"] <- "E"
d1$Condition[d1$Condition=="G.IMI.Enj"] <- "G"

# wide to long conversion for Blinks columns
d2 = melt(dw, 
          id.vars=c("P.No"), 
          measure.vars=c(
            "EG.Bpm", "E.Bpm", "G.Bpm"), 
          variable.name="Condition",
          value.name="Blinks")
d2$Condition <- as.character(d2$Condition)
d2$Condition[d2$Condition=="EG.Bpm"] <- "EG"
d2$Condition[d2$Condition=="E.Bpm"] <- "E"
d2$Condition[d2$Condition=="G.Bpm"] <- "G"

# wide to long conversion for Conductivity columns
d3 = melt(dw, 
          id.vars=c("P.No"), 
          measure.vars=c(
            "EG.SkCond.uS.Average", "E.SkCond.uS.Average", "G.SkCond.uS.Average"), 
          variable.name="Condition",
          value.name="SkCond")
d3$Condition <- as.character(d3$Condition)
d3$Condition[d3$Condition=="EG.SkCond.uS.Average"] <- "EG"
d3$Condition[d3$Condition=="E.SkCond.uS.Average"] <- "E"
d3$Condition[d3$Condition=="G.SkCond.uS.Average"] <- "G"

# merge all the newly created long tables together into a single one called d
d = merge(d1, d2)
d = merge(d, d3)
d$Condition <- as.factor(d$Condition)

# filter data, i.e. only consider data for Condition!="G"
# consider only conditions involving exercise (E and EG)
d = filter(d, Condition!="G") 


# Correlation Analysis

# Note: rmcorr calculates two-tailed p-values, but the hypotheses below
# are directed so require one-tailed p-values. The one-tailed p-values in
# the paper are calculated by halving the corresponding two-tailed p-values.

# Testing hypothesis H2, RmCorr for Conductivity and IMI Interest/Enjoyment
rmcorr(P.No, d$SkCond, d$Interest, d) # r=0.418

# Testing hypothesis H3, RmCorr for Blinks and IMI Interest/Enjoyment
rmcorr(P.No, d$Blinks, d$Interest, d) # r=-0.574
