[Raspberry Pi camera module]:missing
[camera mount]:missing
[M2x6mm screws]:missing
[1.5mm hex key]:missing
[M3x8mm screws]:missing
[long tube]:missing
[2.5mm hex key]:missing
[30mm O-rings]:missing
[white paper]:missing
[LED mount]:missing
[wires with female jumper connectors]:missing
[NeoPixel]:missing
[soldering iron]:missing
[solder]:missing
[wire strippers]:missing
[Arduino Mega]:missing
[Raspberry Pi]:missing
[SD card]:missing
[5V micro-USB power supply]:missing
[keyboard, monitor, and mouse]:missing


# Raspberry Pi camera calibration jig

This document describes how to build a calibration jig that illuminates a Raspberry Pi camera module with uniform-intensity, approximately-collimated light.  Used in conjunction with a suitable RGB LED, it enables the sensor to be calibrated for colour response, allowing the vignetting and loss of saturation at the edge of the sensor to be compensated for in post-processing.  It can also be used to calculate a suitable Lens Shading Table under some circumstances.

# Bill of materials

# Assembly instructions
## Step 1: Remove the lens from the camera module
First, remove the lens from the [Raspberry Pi camera module].  This is described in the [OpenFlexure Microscope] assembly instructions, but just consists of using the plastic lens tool (included with v2 of the camera module) to unscrew the lens.  Be gentle, and take care not to damage the small ribbon cable connecting the sensor to the PCB.

[Raspberry Pi camera module]: ./parts/raspberry_pi_camera_module.md


## Step 2: Fit the camera module into the mount
Place the [camera module][Raspberry Pi camera module] on the flat side of the [camera mount] and fix it in place with two [M2x6mm screws]. You will need a [1.5mm hex key].

![](Ims/camera_mount_back.jpg "")
![](Ims/camera_mount_front.jpg "")
![](Ims/camera_mount_parts.jpg "")

[M2x6mm screws]: ./parts/M2x6mm_screws.md
[1.5mm hex key]: ./parts/1_5mm_hex_key.md
[camera mount]: ./parts/camera_mount.md


## Step 3: Add screws to the tube
Screw four [M3x8mm screws] into the [long tube] using a [2.5mm hex key].

![](Ims/tube_screws_parts.jpg "")
![](Ims/tube_screws.jpg "")

[M3x8mm screws]: ./parts/M3x8mm_screws.md
[2.5mm hex key]: ./parts/2_5mm_hex_key.md
[long tube]: ./parts/long_tube.md

## Step 4: Fit the camera mount into the tube
Place the camera mount into the [long tube], and secure using two [30mm O-rings], one either side.  The [30mm O-rings] are wrapped around the [M3x8mm screws] and the protruding parts of the camera mount.  Each O-ring is wrapped around twice, to ensure the mount is held tightly.

![](Ims/mount_to_tube_back.jpg "")
![](Ims/mount_to_tube_side.jpg "")
![](Ims/mount_to_tube_parts.jpg "")

[30mm O-rings]: ./parts/30mm_o-rings.md

## Step 5: Add the paper diffuser
Place the piece of [white paper] on the bottom of the [long tube], then clamp it in place with the [LED mount] and four [M3x8mm screws], using a [2.5mm hex key].

![](Ims/diffuser_parts.jpg "")
![](Ims/diffuser_paper.jpg "")
![](Ims/diffuser_assembled.jpg "")

[white paper]: ./parts/white_paper.md
[LED mount]: ./parts/led_mount.md

## Step 6: Add the LED
Solder [wires with female jumper connectors] to the data and power pads on the [NeoPixel]. Clamp the [NeoPixel] onto the [LED mount] using the [LED clamp] and two [M3x8mm screws], using a [2.5mm hex key].  You will probably need a [soldering iron], [solder], and [wire strippers]

![](Ims/led_parts.jpg "")
![](Ims/led_assembled.jpg "")

[NeoPixel]: ./parts/neopixel.md
[wires with female jumper connectors]: ./parts/wires.md
[LED clamp]: ./parts/led_clamp.md
[soldering iron]: ./parts/soldering_iron.md
[solder]: ./parts/solder.md
[wire strippers]: ./parts/wire_strippers.md

## Step 7: Connect to electronics
Connect the [NeoPixel] to the [Arduino Mega], wiring the 5V and 0V lines to ground and power on the Arduino, and the data line to digital pin 6.  Connect the [Raspberry Pi camera module] to the [Raspberry Pi].  The [arduino][Arduino Mega] doesn't need a powers supply as it's powered via USB from the Raspberry Pi, and the [Raspberry Pi] will require an [SD card], a [5V micro-USB power supply], and a [keyboard, monitor, and mouse] or some other way of controlling it (e.g. a network cable). 

![](Ims/jig_assembled.jpg "")

[Arduino Mega]: ./parts/arduino_mega.md
[Raspberry Pi]: ./parts/raspberry_pi.md
[5v micro-USB power supply]: ./parts/pi_power_supply.md
[SD card]: ./parts/sd_card.md
[keyboard, monitor, and mouse]: ./parts/keyboard_monitor_mouse.md


[OpenFlexure Microscope]: https://www.openflexure.org/projects/microscope/