clear all
clc

L=500;bw=110;Es=200000;fy=562;As1=2*pi*10^2/4;As2=2*pi*3^2/4;fc=47.9;b1=0.8;ecu=0.0035;Ec=28000;d1=173;d2=21;%basic parameters of the beam
P=32100;Ps=0.75*P;

y1=linspace(490,10,99);%the calculation section
y2=linspace(495,5,100);%comparison sections

M1=sym('M1',[1 99]);%Moment applied on the section%
V1=Ps;
D1=sym('D1',[1 99]);%the depth of the sections%
X1=sym('X1',[1 99]);%the depth of compression zone of the section%



for i=1:99,
    M1(i)=(y1(i))*Ps;
    D1(i)=d2+y1(i)*(d1-d2)/L;
end 

D1=eval(D1);
M1=eval(M1);

M2=sym('M2',[1 100]);%Moment applied on the section%
V2=Ps;%shear force applied%
D2=sym('D2',[1 100]);%the depth of the sections%
X2=sym('X2',[1 100]);%the depth of compression zone of the section%
for i=1:100,
    M2(i)=(y2(i))*Ps;
    D2(i)=d2+y2(i)*(d1-d2)/L;
end 

D2=eval(D2);
M2=eval(M2);
%the load transfer



%calculate the N.A of comparison sections
xc=sym('xc',[1 100]); 
oc=sym('oc',[1 100]);
ec=sym('ec',[1 100]);
es=sym('es',[1 100]);
Ts=sym('Ts',[1 100]);
xt=sym('xt',[1 100]);
%calculation of the inclination
dy=5;

for i=1:33,
    
    k1=D2(i);k2=M2(i);
   
    p=fsolve(@(p) crack(p,k1,k2),[80;45;0.003;0.003],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xc(i)=p(1);oc(i)=p(2);ec(i)=p(3);es(i)=p(4);
    Ts(i)=es(i)*As1*Es;% the tensile force of frp
    
end
for i=34:66,
    
    k1=D2(i);k2=M2(i);
   
    p=fsolve(@(p) crack(p,k1,k2),[60;45;0.003;0.002],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xc(i)=p(1);oc(i)=p(2);ec(i)=p(3);es(i)=p(4);
    Ts(i)=es(i)*As1*Es;% the tensile force of frp
    
end
for i=67:100,
    
    k1=D2(i);k2=M2(i);
   
    p=fsolve(@(p) crack(p,k1,k2),[20;30;0.002;0.001],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xc(i)=p(1);oc(i)=p(2);ec(i)=p(3);es(i)=p(4);
    Ts(i)=es(i)*As1*Es;% the tensile force of frp
    
end

xc=eval(xc);
oc=eval(oc);
ec=eval(ec);
es=eval(es);


%the effective shear force of the calculation sections
T=sym('T',[1 99]);
dTv=sym('dTv',[1 99]);

for i=1:99,
    T(i)=(Ts(i)+Ts(i+1))/2;
    dTv(i)=(Ts(i)-Ts(i+1));%The difference force in frp 

end
T=eval(T);
dTv=eval(dTv);

z=sym('z',[501 99]);
%divide the sections
for i=1:99,
    for j=1:501,
        z(j,i)=D1(i)*(j-1)/500;
    end
end
z=eval(z);
%the normal stress calculation of variable and non-inclined sections
ocn1=sym('ocn1',[501 99]);
ocn2=sym('ocn2',[501 99]);


ecn1=sym('ecn1',[501 99]);
ecn2=sym('ecn2',[501 99]);

for i=1:99,
    for j=1:501,
        if z(j,i)<=xc(i),
            ecn1(j,i)=ec(i)*(1-z(j,i)/xc(i));
            ocn1(j,i)=(fc*ecn1(j,i)*2/ecu-fc/ecu^2*ecn1(j,i)^2);
        else
            ecn1(j,i)=0; 
            ocn1(j,i)=0;
        end
        if z(j,i)<=xc(i+1),
            ecn2(j,i)=ec(i+1)*(1-z(j,i)/xc(i+1));
            ocn2(j,i)=(fc*ecn2(j,i)*2/ecu-fc/ecu^2*ecn2(j,i)^2);
        else
            ecn2(j,i)=0; 
            ocn2(j,i)=0;
        end
    end
end    
ocn1=eval(ocn1);
ocn2=eval(ocn2);

ecn1=eval(ecn1);
ecn2=eval(ecn2);


%calculate the difference of normal stress at each point
docn=sym('docn',[501 99]);

for i=1:99
    for j=1:501,
        docn(j,i)=ocn1(j,i)-ocn2(j,i);
    end
end
docn=eval(docn);

%calculate the shear stress at each point
txy=sym('txy',[501 99]);
Oy=sym('Oy',[501 99]);
Ox=sym('Ox',[501 99]);

for i=1:99,
    txy(1,i)=0;
    Oy(1,i)=0;
    Ox(1,i)=ocn2(1,i);
    for j=2:501,
        if z(j,i)<D2(i+1),
            txy(j,i)=docn(j,i)*D1(i)/500/dy+txy(j-1,i);
        else
            txy(j,i)=docn(j,i)*D1(i)/500/dy-(z(j,i)-z(j-1,i))/(D2(i)-D2(i+1))*dTv(i)/bw/dy+txy(j-1,i);
        end
        Oy(j,i)=Oy(j-1,i)-D1(i)/500*(txy(j,i)-txy(j-1,i))/dy;
        Ox(j,i)=ocn2(j,i);
    end
end

txy=eval(txy);
Oy=eval(Oy);
Ox=eval(Ox);
%calculation of the difference of shear force upon frp


