% T.A.Wright et al (2020) 

% This script runs plots the BS-FWM spectra shown in Fig.4(a). 
% we plot the BS-FWM spectra obtained on an Optical Spectrum Analyser 
% (OSA). These spectra were saved by the OSA using a csv format. 
% The only data file required is A0001.CSV. 

% C5 contains five colours in rgb format for plotting.  
C5 = [0.346666666666667,0.536000000000000,0.690666666666667;...
    0.915294117647059,0.281568627450980,0.287843137254902;...
    0.441568627450980,0.749019607843137,0.432156862745098;...
    0.640000000000000,0.640000000000000,0.640000000000000;...
    0.636470588235294,0.375294117647059,0.675294117647059];

% Loads up the CSV containing the OSA Spectra. 
a = csvread('A0001.CSV',318,0);


a1_wl = a(:,1); %wavelengths for spectra with input at 1550 nm
a2_wl = a(:,3); %wavelengths for spectra w/out input at 1550 nm

a1_level = a(:,2); %intensity of spectra with input at 1550 nm
a2_level = a(:,4); %intensity of spectra w/out input at 1550 nm

% The OSA will arbitarily populate some bins with an intensity value of 
% -210, so we remove datapoints corresponding to these values here. 
a1_wl(a1_level == -210) = []; 
a2_wl(a2_level == -210) = [];
a1_level(a1_level == -210) = [];
a2_level(a2_level == -210) = [];

% We remove unpopulated areas of the spectra here. 
a1_wl(a1_level == 0) = [];
a2_wl(a2_level == 0) = [];
a1_level(a1_level == 0) = [];
a2_level(a2_level == 0) = [];

% creates a figure object, which is shared with plot_fig4a_inset.m,
% plot_fig4b.m and plot_fig4c.m.
fig1 = figure('color','white','units','centimeters','position',[5.5,9,8,8.9],'resize','off'); 

% defines some axis positions of Fig.4(a)
left = 0.9;
left_a = 0.775;
left_b = 4.775;
bottom = 0.8+4.5-0.1;
width = 4.775+3.15 - left;
height= 3.2;

% creates axis for Fig.4(a)
ax1 = axes('units','centimeters','Position',[left,bottom,width,height]);

% command to allow multiple plots on one set of axes. 
hold on

% plot commands (wl,vs intensity) for both spectra. 
plot(a1_wl,a1_level,'color',C5(1,:),'linewidth',0.75); %with input at 1550 nm
plot(a2_wl,a2_level,'color',C5(2,:),'linewidth',0.75); %no input at 1550 nm

% Commands to change appearance of the plot in Fig.4(a). 
xlim([700 1600]);
ylim([-100 20]);
ax1.XTick = 750:250:1550;
ax1.YTick = -90:30:0;
set(ax1,'XMinorTick','on');
ax1.XAxis.MinorTickValues = 700:50:1600;
set(ax1, 'Layer', 'top')
title(ax1,'(a)');

ax1.LineWidth = 0.75;
ax1.FontSize = 8;
ax1.FontName = 'CMU Serif';
box on;
xlabel('Wavelength [nm]');
ylabel('Intensity [dBm]');



