#Cleaning Associative Learning data for citalopram study
#Catherine Hobbs, University of Bath c.hobbs@bath.ac.uk
#24.03.2020
#RStudio Version 1.2.1335 Mac OS

#Packages needed
invisible(lapply(paste0('package:', names(sessionInfo()$otherPkgs)), detach, character.only=TRUE, unload=TRUE, force=TRUE))#Removing currently loaded packages to avoid compatability issues
library(tidyverse)
library(readxl)
library(doBy)

#Setting Working Directory
setwd("/Volumes/files/RDSSD/Katie Studies/Citalopram/8. Data/")
associative_df <- read_excel("Raw/Cognitive Tasks/Associative Learning/associative_raw_merged_anon.xlsx")

#Note: below code not needed for my purposes as have removed this info when anonymising data, however if you're using the task it may be useful to remove these columns to have a cleaner dataframe
#Dropping irrelevant variables
#associative_df <- subset(associative_df, select = -c(practice_resp.corr, practice_resp.keys, practice_resp.rt, practice_trial.thisIndex, practice_trial.thisN, practice_trial.thisRepN, practice_trial.thisTrialN, frameRate, intro_label1, intro_label2, intro_label3, intro_label_type1, intro_label_type2, trials.thisIndex, task_block.thisN, task_block.thisRepN, task_order.thisIndex, task_order.thisN, task_order.thisRepN, task_order.thisTrialN, key_commands.thisIndex, key_commands.thisN, key_commands.thisRepN, key_commands.thisTrialN, expName, date)) 
#associative_df <- associative_df[, -grep(".stopped$", colnames(associative_df))]
#associative_df <- associative_df[, -grep(".started$", colnames(associative_df))]

#Dropping practice trials
associative_df <- subset(associative_df, !is.na(trials.thisN))

#Dropping empty columns
associative_df <- associative_df %>%
  select(- `Unnamed: 141`, - `Unnamed: 141`)

#Creating a variable to show matching (1) versus not matching (0) trials
associative_df$Matching[associative_df$CorrectAnswer == "Yes"] <- 1
associative_df$Matching[associative_df$CorrectAnswer == "No"] <- 0

#Dropping trials less than 200 ms (46 trials less than 200 ms, 1360 NAs, 13354 trials fine)
summary(associative_df$trial_resp.rt)
associative_df$invalid_trials <- ifelse(associative_df$trial_resp.rt < 0.200, 1, ifelse(associative_df$trial_resp.rt >= 0.200, 2, ifelse((NA ))))

associative_df %>%
  group_by(invalid_trials) %>%
  summarise(Mean = mean(trial_resp.rt, na.rm = TRUE), Min = min(trial_resp.rt, na.rm = TRUE), Max = max (trial_resp.rt, na.rm = TRUE), N = n())

associative_df <- subset(associative_df, invalid_trials == 2)

#Collapsing
associative_df <- as.data.frame(associative_df)
associative_long <- summaryBy(trial_resp.corr + trial_resp.rt ~ participant + Task + Shape + Matching, FUN = mean, na.rm=TRUE, data = associative_df)

#Checking correct no. participants and conditions
table(associative_long$participant)
associative_long %>%
  summarise(n_distinct(participant))

#Renaming variables
names(associative_long)[names(associative_long) == "trial_resp.corr.mean"] <- "prop_acc"
associative_long$prop_acc <- (associative_long$prop_acc* 100)
associative_long$mean_rt_mult <- (associative_long$trial_resp.rt.mean * 1000)
names(associative_long)[names(associative_long) == "trial_resp.rt.mean"] <- "mean_rt_unmult"

#Generating numerical values for shape
associative_long$ShapeNo[associative_long$Shape == "Happy" | associative_long$Shape == "Self" | associative_long$Shape == "HighReward" ] <- 1
associative_long$ShapeNo[associative_long$Shape == "Neutral" | associative_long$Shape == "Friend" | associative_long$Shape == "MediumReward" ] <- 2
associative_long$ShapeNo[associative_long$Shape == "Sad" | associative_long$Shape == "Stranger" | associative_long$Shape == "LowReward" ] <- 3


associative_long$ShapeNo <- as.factor(associative_long$ShapeNo)

associative_long$ShapeNo <- factor(associative_long$ShapeNo,
                                   levels = c(1, 2, 3),
                                   labels = c("High","Medium", "Low"))

#Creating order variables for specific stimuli type
associative_long$stimuli <- ifelse(associative_long$Task == "Self" & associative_long$Shape == "Self", 1, 
                                   ifelse(associative_long$Task == "Self" & associative_long$Shape == "Friend", 2, 
                                          ifelse(associative_long$Task == "Self" & associative_long$Shape == "Stranger", 3, 
                                                 ifelse(associative_long$Task == "Reward" & associative_long$Shape == "HighReward", 4,
                                                        ifelse(associative_long$Task == "Reward" & associative_long$Shape == "MediumReward", 5, 
                                                        ifelse(associative_long$Task == "Reward" & associative_long$Shape == "LowReward", 6, 
                                                               ifelse(associative_long$Task == "Valence" & associative_long$Shape == "Happy", 7,
                                                                      ifelse(associative_long$Task == "Valence" & associative_long$Shape == "Neutral", 8, 9))))))))

associative_long$stimuli <- as.factor(associative_long$stimuli)

associative_long$stimuli <- factor(associative_long$stimuli,
                                   levels = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
                                   labels = c("Self", "Friend", "Stranger", "£9", "£3", "£1", "Happy", "Neutral", "Sad"))


#Merging with group data
drug_matching <- read_excel("Raw/Group Allocation/Blinded_drug_matching_KH_format_for_R_anon.xlsx")
associative_long <- merge(drug_matching, associative_long , by = "participant")

associative_long$group <- as.factor(associative_long$group)

#Checking no. subjects
associative_long %>%
  summarise(n_distinct(participant))

#Sorting
associative_long <- associative_long %>%
  arrange(participant, Task, ShapeNo, Matching)

#Saving Dataframe
save(associative_long, file = "Analysis/Associative Learning/associative_long")
write.csv(associative_long,"Analysis/Associative Learning/associative_long.csv")


