#Cleaning Questionnaire data for citalopram study
#Catherine Hobbs, University of Bath c.hobbs@bath.ac.uk
#23.03.2020
#RStudio Version 1.2.1335 Mac OS, R 3.6

#Packages needed (note for recode will have to specify where dplyr vs. car should be used)
library(tidyverse)
library(readxl)
library(car)

#Setting Working Directory
setwd("/Volumes/files/RDSSD/Katie Studies/Citalopram/8. Data/")

#Importing raw merged (all participant data) file
raw_qs <- read_excel("Raw/Questionnaires/Citalopram_Questionnaires_raw_anon.xlsx")
qs <- raw_qs

#Keeping variables needed (note: pd = post-drug, pc = post-cognitive testing)
paste(colnames(qs), collapse = ", ")
qs <- qs %>%
  select(subject, PHQ_Q1, PHQ_Q2, PHQ_Q3, PHQ_Q4, PHQ_Q5, PHQ_Q6, PHQ_Q7, PHQ_Q8, PHQ_Q9, BDI_Q1, BDI_Q2, BDI_Q3, BDI_Q4, BDI_Q5, BDI_Q6, BDI_Q7, BDI_Q8, BDI_Q9, BDI_Q10, BDI_Q11, BDI_Q12, BDI_Q13, BDI_Q14, BDI_Q15, BDI_Q16, BDI_Q17, BDI_Q18, BDI_Q19, BDI_Q20, BDI_Q21, GAD_Q1, GAD_Q2, GAD_Q3, GAD_Q4, GAD_Q5, GAD_Q6, GAD_Q7, BFNE_Q1, BFNE_Q2, BFNE_Q3, BFNE_Q4, BFNE_Q5, BFNE_Q6, BFNE_Q7, BFNE_Q8, BFNE_Q9, BFNE_Q10, BFNE_Q11, BFNE_Q12, EPQR_Q1, EPQR_Q2, EPQR_Q3, EPQR_Q4, EPQR_Q5, EPQR_Q6, EPQR_Q7, EPQR_Q8, EPQR_Q9, EPQR_Q10, EPQR_Q11, EPQR_Q12, EPQR_Q13, EPQR_Q14, EPQR_Q15, EPQR_Q16, EPQR_Q17, EPQR_Q18, EPQR_Q19, EPQR_Q20, EPQR_Q21, EPQR_Q22, EPQR_Q23, EPQR_Q24, EPQR_Q25, EPQR_Q26, EPQR_Q27, EPQR_Q28, EPQR_Q29, EPQR_Q30, EPQR_Q31, EPQR_Q32, EPQR_Q33, EPQR_Q34, EPQR_Q35, EPQR_Q36, EPQR_Q37, EPQR_Q38, EPQR_Q39, EPQR_Q40, EPQR_Q41, EPQR_Q42, EPQR_Q43, EPQR_Q44, EPQR_Q45, EPQR_Q46, EPQR_Q47, EPQR_Q48, STAIT_Q1, STAIT_Q2, STAIT_Q3, STAIT_Q4, STAIT_Q5, STAIT_Q6, STAIT_Q7, STAIT_Q8, STAIT_Q9, STAIT_Q10, STAIT_Q11, STAIT_Q12, STAIT_Q13, STAIT_Q14, STAIT_Q15, STAIT_Q16, STAIT_Q17, STAIT_Q18, STAIT_Q19, STAIT_Q20, STAIS_Q1, STAIS_Q2, STAIS_Q3, STAIS_Q4, STAIS_Q5, STAIS_Q6, STAIS_Q7, STAIS_Q8, STAIS_Q9, STAIS_Q10, STAIS_Q11, STAIS_Q12, STAIS_Q13, STAIS_Q14, STAIS_Q15, STAIS_Q16, STAIS_Q17, STAIS_Q18, STAIS_Q19, STAIS_Q20, PANAS_Q1, PANAS_Q2, PANAS_Q3, PANAS_Q4, PANAS_Q5, PANAS_Q6, PANAS_Q7, PANAS_Q8, PANAS_Q9, PANAS_Q10, PANAS_Q11, PANAS_Q12, PANAS_Q13, PANAS_Q14, PANAS_Q15, PANAS_Q16, PANAS_Q17, PANAS_Q18, PANAS_Q19, PANAS_Q20, SideEffects_Q1, SideEffects_Q2, SideEffects_Q3, SideEffects_Q5, SideEffects_Q6, SideEffects_Q7, VAS_1, VAS_2, VAS_3, VAS_4, VAS_5, VAS_6, VAS_7, STAIS_Q1_pd, STAIS_Q2_pd, STAIS_Q3_pd, STAIS_Q4_pd, STAIS_Q5_pd, STAIS_Q6_pd, STAIS_Q7_pd, STAIS_Q8_pd, STAIS_Q9_pd, STAIS_Q10_pd, STAIS_Q11_pd, STAIS_Q12_pd, STAIS_Q13_pd, STAIS_Q14_pd, STAIS_Q15_pd, STAIS_Q16_pd, STAIS_Q17_pd, STAIS_Q18_pd, STAIS_Q19_pd, STAIS_Q20_pd, PANAS_Q1_pd, PANAS_Q2_pd, PANAS_Q3_pd, PANAS_Q4_pd, PANAS_Q5_pd, PANAS_Q6_pd, PANAS_Q7_pd, PANAS_Q8_pd, PANAS_Q9_pd, PANAS_Q10_pd, PANAS_Q11_pd, PANAS_Q12_pd, PANAS_Q13_pd, PANAS_Q14_pd, PANAS_Q15_pd, PANAS_Q16_pd, PANAS_Q17_pd, PANAS_Q18_pd, PANAS_Q19_pd, PANAS_Q20_pd, SideEffects_Q1_pd, SideEffects_Q2_pd, SideEffects_Q3_pd, SideEffects_Q4_pd, SideEffects_Q5_pd, SideEffects_Q6_pd, VAS_pd_1, VAS_pd_2, VAS_pd_3, VAS_pd_4, VAS_pd_5, VAS_pd_6, VAS_pd_7, STAIS_Q1_pc, STAIS_Q2_pc, STAIS_Q3_pc, STAIS_Q4_pc, STAIS_Q5_pc, STAIS_Q6_pc, STAIS_Q7_pc, STAIS_Q8_pc, STAIS_Q9_pc, STAIS_Q10_pc, STAIS_Q11_pc, STAIS_Q12_pc, STAIS_Q13_pc, STAIS_Q14_pc, STAIS_Q15_pc, STAIS_Q16_pc, STAIS_Q17_pc, STAIS_Q18_pc, STAIS_Q19_pc, STAIS_Q20_pc, PANAS_Q1_pc, PANAS_Q2_pc, PANAS_Q3_pc, PANAS_Q4_pc, PANAS_Q5_pc, PANAS_Q6_pc, PANAS_Q7_pc, PANAS_Q8_pc, PANAS_Q9_pc, PANAS_Q10_pc, PANAS_Q11_pc, PANAS_Q12_pc, PANAS_Q13_pc, PANAS_Q14_pc, PANAS_Q15_pc, PANAS_Q16_pc, PANAS_Q17_pc, PANAS_Q18_pc, PANAS_Q19_pc, PANAS_Q20_pc, SideEffects_Q1_pc, SideEffects_Q2_pc, SideEffects_Q3_pc, SideEffects_Q4_pc, SideEffects_Q5_pc, SideEffects_Q6_pc, VAS_pc_1, VAS_pc_2, VAS_pc_3, VAS_pc_4, VAS_pc_5, VAS_pc_6, VAS_pc_7, drug_p_certainty_4, placebo_p_certainty_1, drug_p, drug_r_certainty_4, placebo_r_certainty_1, drug_r)


#Subtracting 1 from values where qualtrics scores from 1 onwards instead of 0 (e.g. PHQ)
minus_1 <- function(x){
  x-1
}

qs <- qs %>%
  mutate_at(vars(contains('PHQ')), minus_1) %>%
  mutate_at(vars(contains('GAD')), minus_1) %>%
  mutate_at(vars(contains('BDI')), minus_1)

#Changing coding of EPQR-S so 1 = Yes, 0 = No (currently 1 & 2 respectively)
qs[51:98]  <- lapply(qs[51:98], car::recode, "1 = 1; 2 = 0")
summary(qs[51:98] )

#Reverse coding variables
qs$BFNE_Q2 <- dplyr::recode(qs$BFNE_Q2, `1` = 5L, `2` = 4L, `3` = 3L, `4` = 2L, `5` = 1L)
qs$BFNE_Q4 <- dplyr::recode(qs$BFNE_Q4, `1` = 5L, `2` = 4L, `3` = 3L, `4` = 2L, `5` = 1L)
qs$BFNE_Q7 <- dplyr::recode(qs$BFNE_Q7, `1` = 5L, `2` = 4L, `3` = 3L, `4` = 2L, `5` = 1L)
qs$BFNE_Q10 <- dplyr::recode(qs$BFNE_Q10, `1` = 5L, `2` = 4L, `3` = 3L, `4` = 2L, `5` = 1L)

qs$EPQR_Q27 <- dplyr::recode(qs$EPQR_Q27, `1` = 0L, `0` = 1L)
qs$EPQR_Q41 <- dplyr::recode(qs$EPQR_Q41, `1` = 0L, `0` = 1L)
qs$EPQR_Q8 <- dplyr::recode(qs$EPQR_Q8, `1` = 0L, `0` = 1L)
qs$EPQR_Q12 <- dplyr::recode(qs$EPQR_Q12, `1` = 0L, `0` = 1L)
qs$EPQR_Q20 <- dplyr::recode(qs$EPQR_Q20, `1` = 0L, `0` = 1L)
qs$EPQR_Q24 <- dplyr::recode(qs$EPQR_Q24, `1` = 0L, `0` = 1L)
qs$EPQR_Q29 <- dplyr::recode(qs$EPQR_Q29, `1` = 0L, `0` = 1L)
qs$EPQR_Q33 <- dplyr::recode(qs$EPQR_Q33, `1` = 0L, `0` = 1L)
qs$EPQR_Q37 <- dplyr::recode(qs$EPQR_Q37, `1` = 0L, `0` = 1L)
qs$EPQR_Q40 <- dplyr::recode(qs$EPQR_Q40, `1` = 0L, `0` = 1L)
qs$EPQR_Q47 <- dplyr::recode(qs$EPQR_Q47, `1` = 0L, `0` = 1L)
qs$EPQR_Q2 <- dplyr::recode(qs$EPQR_Q2, `1` = 0L, `0` = 1L)
qs$EPQR_Q6 <- dplyr::recode(qs$EPQR_Q6, `1` = 0L, `0` = 1L)
qs$EPQR_Q18 <- dplyr::recode(qs$EPQR_Q18, `1` = 0L, `0` = 1L)
qs$EPQR_Q26 <- dplyr::recode(qs$EPQR_Q26, `1` = 0L, `0` = 1L)
qs$EPQR_Q28 <- dplyr::recode(qs$EPQR_Q28, `1` = 0L, `0` = 1L)
qs$EPQR_Q35 <- dplyr::recode(qs$EPQR_Q35, `1` = 0L, `0` = 1L)
qs$EPQR_Q43 <- dplyr::recode(qs$EPQR_Q43, `1` = 0L, `0` = 1L)

qs$STAIS_Q1 <- dplyr::recode(qs$STAIS_Q1, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q2 <- dplyr::recode(qs$STAIS_Q2, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q5 <- dplyr::recode(qs$STAIS_Q5, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q8 <- dplyr::recode(qs$STAIS_Q8, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q10 <- dplyr::recode(qs$STAIS_Q10, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q11 <- dplyr::recode(qs$STAIS_Q11, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q15 <- dplyr::recode(qs$STAIS_Q15, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q16 <- dplyr::recode(qs$STAIS_Q16, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q19 <- dplyr::recode(qs$STAIS_Q19, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q20 <- dplyr::recode(qs$STAIS_Q20, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)

qs$STAIS_Q1_pd <- dplyr::recode(qs$STAIS_Q1_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q2_pd <- dplyr::recode(qs$STAIS_Q2_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q5_pd <- dplyr::recode(qs$STAIS_Q5_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q8_pd <- dplyr::recode(qs$STAIS_Q8_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q10_pd <- dplyr::recode(qs$STAIS_Q10_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q11_pd <- dplyr::recode(qs$STAIS_Q11_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q15_pd <- dplyr::recode(qs$STAIS_Q15_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q16_pd <- dplyr::recode(qs$STAIS_Q16_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q19_pd <- dplyr::recode(qs$STAIS_Q19_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q20_pd <- dplyr::recode(qs$STAIS_Q20_pd, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)

qs$STAIS_Q1_pc <- dplyr::recode(qs$STAIS_Q1_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q2_pc <- dplyr::recode(qs$STAIS_Q2_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q5_pc <- dplyr::recode(qs$STAIS_Q5_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q8_pc <- dplyr::recode(qs$STAIS_Q8_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q10_pc <- dplyr::recode(qs$STAIS_Q10_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q11_pc <- dplyr::recode(qs$STAIS_Q11_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q15_pc <- dplyr::recode(qs$STAIS_Q15_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q16_pc <- dplyr::recode(qs$STAIS_Q16_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q19_pc <- dplyr::recode(qs$STAIS_Q19_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIS_Q20_pc <- dplyr::recode(qs$STAIS_Q20_pc, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)

qs$STAIT_Q1 <- dplyr::recode(qs$STAIT_Q1, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q3 <- dplyr::recode(qs$STAIT_Q3, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q6 <- dplyr::recode(qs$STAIT_Q6, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q7 <- dplyr::recode(qs$STAIT_Q7, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q10 <- dplyr::recode(qs$STAIT_Q10, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q13 <- dplyr::recode(qs$STAIT_Q13, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q14 <- dplyr::recode(qs$STAIT_Q14, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q16 <- dplyr::recode(qs$STAIT_Q16, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)
qs$STAIT_Q19 <- dplyr::recode(qs$STAIT_Q19, `1` = 4L, `2` = 3L, `3` = 2L, `4` = 1L)

#BDI (have to recode items 16 & 18 as they have 6 values)
qs$BDI_Q16 <- dplyr::recode(qs$BDI_Q16, `0` = 0L, `1` = 1L, `2` = 1L, `3` = 2L, `4` = 2L, `5` = 3L, `6` = 3L)
summary(qs$BDI_Q16)
qs$BDI_Q18 <- dplyr::recode(qs$BDI_Q18, `0` = 0L, `1` = 1L, `2` = 1L, `3` = 2L, `4` = 2L, `5` = 3L, `6` = 3L)
summary(qs$BDI_Q18)

#Totalling scores for scales
paste(colnames(qs), collapse = " + ")

qs <- qs %>%
  mutate(PHQ_tot = PHQ_Q1 + PHQ_Q2 + PHQ_Q3 + PHQ_Q4 + PHQ_Q5 + PHQ_Q6 + PHQ_Q7 + PHQ_Q8 + PHQ_Q9) %>%
  mutate(BDI_tot = BDI_Q1 + BDI_Q2 + BDI_Q3 + BDI_Q4 + BDI_Q5 + BDI_Q6 + BDI_Q7 + BDI_Q8 + BDI_Q9 + BDI_Q10 + BDI_Q11 + BDI_Q12 + BDI_Q13 + BDI_Q14 + BDI_Q15 + BDI_Q16 + BDI_Q17 + BDI_Q18 + BDI_Q19 + BDI_Q20 + BDI_Q21)%>%
  mutate(GAD_tot = GAD_Q1 + GAD_Q2 + GAD_Q3 + GAD_Q4 + GAD_Q5 + GAD_Q6 + GAD_Q7) %>%
  mutate(BFNE_tot = BFNE_Q1 + BFNE_Q2 + BFNE_Q3 + BFNE_Q4 + BFNE_Q5 + BFNE_Q6 + BFNE_Q7 + BFNE_Q8 + BFNE_Q9 + BFNE_Q10 + BFNE_Q11 + BFNE_Q12) %>%
  mutate(PANAS_pos = PANAS_Q1 + PANAS_Q3 + PANAS_Q5 + PANAS_Q9 + PANAS_Q10 + PANAS_Q12 + PANAS_Q14 + PANAS_Q16 + PANAS_Q17 + PANAS_Q19) %>%
  mutate(PANAS_neg = PANAS_Q2 + PANAS_Q4 + PANAS_Q6 + PANAS_Q7 + PANAS_Q8 + PANAS_Q11 + PANAS_Q13 + PANAS_Q15 + PANAS_Q18 + PANAS_Q20) %>%
  mutate(PANAS_pos_pd = PANAS_Q1_pd + PANAS_Q3_pd + PANAS_Q5_pd + PANAS_Q9_pd + PANAS_Q10_pd + PANAS_Q12_pd + PANAS_Q14_pd + PANAS_Q16_pd + PANAS_Q17_pd + PANAS_Q19_pd) %>%
  mutate(PANAS_neg_pd = PANAS_Q2_pd + PANAS_Q4_pd + PANAS_Q6_pd + PANAS_Q7_pd + PANAS_Q8_pd + PANAS_Q11_pd + PANAS_Q13_pd + PANAS_Q15_pd + PANAS_Q18_pd + PANAS_Q20_pd) %>%
  mutate(PANAS_pos_pc = PANAS_Q1_pc + PANAS_Q3_pc + PANAS_Q5_pc + PANAS_Q9_pc + PANAS_Q10_pc + PANAS_Q12_pc + PANAS_Q14_pc + PANAS_Q16_pc + PANAS_Q17_pc + PANAS_Q19_pc) %>%
  mutate(PANAS_neg_pc = PANAS_Q2_pc + PANAS_Q4_pc + PANAS_Q6_pc + PANAS_Q7_pc + PANAS_Q8_pc + PANAS_Q11_pc + PANAS_Q13_pc + PANAS_Q15_pc + PANAS_Q18_pc + PANAS_Q20_pc) %>%
  mutate(STAIT_tot = STAIT_Q1 + STAIT_Q2 + STAIT_Q3 + STAIT_Q4 + STAIT_Q5 + STAIT_Q6 + STAIT_Q7 + STAIT_Q8 + STAIT_Q9 + STAIT_Q10 + STAIT_Q11 + STAIT_Q12 + STAIT_Q13 + STAIT_Q14 + STAIT_Q15 + STAIT_Q16 + STAIT_Q17 + STAIT_Q18 + STAIT_Q19 + STAIT_Q20) %>%
  mutate(STAIS_tot = STAIS_Q1 + STAIS_Q2 + STAIS_Q3 + STAIS_Q4 + STAIS_Q5 + STAIS_Q6 + STAIS_Q7 + STAIS_Q8 + STAIS_Q9 + STAIS_Q10 + STAIS_Q11 + STAIS_Q12 + STAIS_Q13 + STAIS_Q14 + STAIS_Q15 + STAIS_Q16 + STAIS_Q17 + STAIS_Q18 + STAIS_Q19 + STAIS_Q20) %>%
  mutate(STAIS_tot_pd = STAIS_Q1_pd + STAIS_Q2_pd + STAIS_Q3_pd + STAIS_Q4_pd + STAIS_Q5_pd + STAIS_Q6_pd + STAIS_Q7_pd + STAIS_Q8_pd + STAIS_Q9_pd + STAIS_Q10_pd + STAIS_Q11_pd + STAIS_Q12_pd + STAIS_Q13_pd + STAIS_Q14_pd + STAIS_Q15_pd + STAIS_Q16_pd + STAIS_Q17_pd + STAIS_Q18_pd + STAIS_Q19_pd + STAIS_Q20_pd) %>%
  mutate(STAIS_tot_pc = STAIS_Q1_pc + STAIS_Q2_pc + STAIS_Q3_pc + STAIS_Q4_pc + STAIS_Q5_pc + STAIS_Q6_pc + STAIS_Q7_pc + STAIS_Q8_pc + STAIS_Q9_pc + STAIS_Q10_pc + STAIS_Q11_pc + STAIS_Q12_pc + STAIS_Q13_pc + STAIS_Q14_pc + STAIS_Q15_pc + STAIS_Q16_pc + STAIS_Q17_pc + STAIS_Q18_pc + STAIS_Q19_pc + STAIS_Q20_pc) %>%
  mutate(EPQR_Extraversion = EPQR_Q3 + EPQR_Q7 + EPQR_Q11 + EPQR_Q15 + EPQR_Q19 + EPQR_Q23 + EPQR_Q27 + EPQR_Q32 + EPQR_Q36 + EPQR_Q41 + EPQR_Q44 + EPQR_Q48) %>%
  mutate(EPQR_Neuroticism = EPQR_Q1 + EPQR_Q5 + EPQR_Q9 + EPQR_Q13 + EPQR_Q17 + EPQR_Q21 + EPQR_Q25 + EPQR_Q30 + EPQR_Q34 + EPQR_Q38 + EPQR_Q42 + EPQR_Q46) %>%
  mutate(EPQR_Lie = EPQR_Q4 + EPQR_Q8 + EPQR_Q12 + EPQR_Q16 + EPQR_Q20 + EPQR_Q24 + EPQR_Q29 + EPQR_Q33 + EPQR_Q37 + EPQR_Q40 + EPQR_Q45 + EPQR_Q47) %>%
  mutate(EPQR_Psychoticism = EPQR_Q2 + EPQR_Q6 + EPQR_Q10 + EPQR_Q14 + EPQR_Q18 + EPQR_Q22 + EPQR_Q26 + EPQR_Q28 + EPQR_Q31 + EPQR_Q35 + EPQR_Q39 + EPQR_Q43)

#Renaming incorrectly no. Side effects qs at baseline
qs <- qs %>%
  rename(SideEffects_Q4 = SideEffects_Q5, SideEffects_Q5 = SideEffects_Q6, SideEffects_Q6 = SideEffects_Q7)

#Calculating change from baseline to post-drug, and post-drug to post-cognitive testing
qs <- qs %>%
  mutate(VAS_1_base_pd = VAS_pd_1 - VAS_1, VAS_2_base_pd = VAS_pd_2 - VAS_2, VAS_3_base_pd = VAS_pd_3 - VAS_3, VAS_4_base_pd = VAS_pd_4 - VAS_4, VAS_5_base_pd = VAS_pd_5 - VAS_5, VAS_6_base_pd = VAS_pd_6 - VAS_6, VAS_7_base_pd = VAS_pd_7 - VAS_7) %>%
  mutate(VAS_1_pd_pc = VAS_pc_1 - VAS_pd_1, VAS_2_pd_pc = VAS_pc_2 - VAS_pd_2, VAS_3_pd_pc = VAS_pc_3 - VAS_pd_3, VAS_4_pd_pc = VAS_pc_4 - VAS_pd_4, VAS_5_pd_pc = VAS_pc_5 - VAS_pd_5, VAS_6_pd_pc = VAS_pc_6 - VAS_pd_6, VAS_7_pd_pc = VAS_pc_7 - VAS_pd_7) %>%
  mutate(PANAS_pos_base_pd = PANAS_pos_pd - PANAS_pos, PANAS_neg_base_pd = PANAS_neg_pd - PANAS_neg) %>%
  mutate(PANAS_pos_pd_pc = PANAS_pos_pc - PANAS_pos_pd, PANAS_neg_pd_pc = PANAS_neg_pc - PANAS_neg_pd) %>%
  mutate(STAIS_base_pd = STAIS_tot_pd - STAIS_tot, STAIS_pd_pc = STAIS_tot_pc - STAIS_tot_pd) %>%
  mutate(SideEffects_Q1_base_pd = SideEffects_Q1_pd - SideEffects_Q1, SideEffects_Q1_pd_pc = SideEffects_Q1_pc - SideEffects_Q1_pd) %>%
  mutate(SideEffects_Q2_base_pd = SideEffects_Q2_pd - SideEffects_Q2, SideEffects_Q2_pd_pc = SideEffects_Q2_pc - SideEffects_Q2_pd) %>%
  mutate(SideEffects_Q3_base_pd = SideEffects_Q3_pd - SideEffects_Q3, SideEffects_Q3_pd_pc = SideEffects_Q3_pc - SideEffects_Q3_pd) %>%
  mutate(SideEffects_Q4_base_pd = SideEffects_Q4_pd - SideEffects_Q4, SideEffects_Q4_pd_pc = SideEffects_Q4_pc - SideEffects_Q4_pd) %>%
  mutate(SideEffects_Q5_base_pd = SideEffects_Q5_pd - SideEffects_Q5, SideEffects_Q5_pd_pc = SideEffects_Q5_pc - SideEffects_Q5_pd) %>%
  mutate(SideEffects_Q6_base_pd = SideEffects_Q6_pd - SideEffects_Q6, SideEffects_Q6_pd_pc = SideEffects_Q6_pc - SideEffects_Q6_pd)

#Adding labels for researcher and participant drug group guess
qs$drug_p  <- factor(qs$drug_p,
                     levels = c(1,2),
                     labels = c("Citalopram", "Placebo"))

qs$drug_r  <- factor(qs$drug_r,
                     levels = c(1,4),
                     labels = c("Citalopram", "Placebo"))

#Renaming drug guess variables
qs <- qs %>%
  rename(group_guess_participant = drug_p, group_guess_researcher = drug_r, drug_guess_certainty_participant = drug_p_certainty_4, placebo_guess_certainty_participant = placebo_p_certainty_1, drug_guess_certainty_researcher = drug_r_certainty_4 , placebo_guess_certainty_researcher = placebo_r_certainty_1)

#Importing demographic data
raw_demographics <- read_excel("Raw/Demographics/Demographic_Data_anon.xlsx")
demographic <- raw_demographics

#Changing string variables into factors where appropriate
demographic$gender <- as.factor(demographic$gender)
demographic$employment <- as.factor(demographic$employment)
demographic$smoke <- as.factor(demographic$smoke)
demographic$ethnicity <- as.factor(demographic$ethnicity)
demographic$education <- as.factor(demographic$education)

demographic$english <- ifelse(demographic$english_first_language == "Yes", 1, 0)
demographic$english  <- factor(demographic$english,
                                                   levels = c(1,0),
                                                   labels = c("Yes", "No"))

demographic <- demographic %>%
  select(- english_first_language) %>%
  rename(english_first_language = english)

#Merging subject & questionnaire data
demo_qs <- merge(demographic, qs, by = "subject")

#Renaming subject variable to match with drug groups
demo_qs <- demo_qs %>%
  rename(participant = subject)

#Merging with group level data
drug_matching <- read_excel("Raw/Group Allocation/Blinded_drug_matching_KH_format_for_R_anon.xlsx")
demo_qs <- merge(drug_matching, demo_qs, by = "participant")
demo_qs$group <- as.factor(demo_qs$group)

#Saving Dataframes
save(demo_qs, file = "Analysis/Questionnaires/demo_qs")
write.csv(demo_qs, "Analysis/Questionnaires/demo_qs.csv")
