clear; clf; % spherical harmonics display 
load mfig1aorg.mat; 
h=figure(1); clf; set(h,'color',cg);
rf=ylmm*2*1.01; 
rr=r; rr(:,1:3)=rf; rr(:,end-2:end)=rf;
s1=surf(x,y,z,rr); 
s1.EdgeColor='none'; hold on; 
zzs=zz-min(zz,[],'all'); 
zzs=zzs/max(zzs,[],'all'); 
zzs=zzs*ylmm+ylmm; 
s2=surf(x2,y2,z2,zzs);
s2.EdgeColor='none';
h3=plot3(x3,y3,z3,'-k'); 
plot3(x4,y4,z4,'.k','markersize',20)
plot3(x5,y5,z5,'-w','linewidth',2);
plot3(x6(1:40),y6(1:40),z6(1:40),'--w','linewidth',2);
plot3(x7(1:60),y7(1:60),z7(1:60),':w','linewidth',2);
rdir=[0,1,0]; ra=93; 
rotate(s1,rdir,ra); 
rdir=[0,0,1]; ra=20; 
rotate(s1,rdir,ra);
view(-21,-20); 
view(-23,-9); 
colormap(cjet); %colorbar; 
axis equal; axis off; 
set(gcf,'inverthardcopy','off');
print fig1a.tif -dtiff -opengl -r300;
%print fig1a.eps -depsc -opengl -r300;
